/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.core;

import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.CacheLimit;
import com.trivago.triava.tcache.TCacheFactory;
import com.trivago.triava.tcache.core.Builder;
import com.trivago.triava.tcache.eviction.EvictionInterface;
import com.trivago.triava.tcache.eviction.LFUEviction;
import com.trivago.triava.tcache.eviction.LRUEviction;
import javax.cache.configuration.Configuration;

public class InternalBuilder<K, V>
extends Builder<K, V> {
    private static final long serialVersionUID = 242912192026515310L;
    private transient TCacheFactory factory = null;

    public InternalBuilder(TCacheFactory factory) {
        this.factory = Builder.verifyNotNull("factory", factory);
    }

    public InternalBuilder(TCacheFactory factory, Configuration<K, V> configuration) {
        super(configuration);
        this.factory = InternalBuilder.verifyNotNull("factory", factory);
    }

    @Override
    public Cache<K, V> build() {
        Cache cache;
        if (this.getId() == null) {
            this.setId("tcache-" + anonymousCacheId.incrementAndGet());
        }
        if (this.getEvictionClass() != null) {
            cache = new CacheLimit(this.factory, this);
        } else {
            switch (this.getEvictionPolicy()) {
                case LFU: {
                    cache = new CacheLimit(this.factory, this.setEvictionClass((EvictionInterface)new LFUEviction()));
                    break;
                }
                case LRU: {
                    cache = new CacheLimit(this.factory, this.setEvictionClass((EvictionInterface)new LRUEviction()));
                    break;
                }
                case CUSTOM: {
                    cache = new CacheLimit(this.factory, this);
                    break;
                }
                case NONE: {
                    cache = new Cache(this.factory, this);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid evictionPolicy=" + (Object)((Object)this.getEvictionPolicy()));
                }
            }
        }
        return cache;
    }
}

