/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache;

import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.CacheWriteMode;
import com.trivago.triava.tcache.TCacheHolder;
import com.trivago.triava.tcache.expiry.TCacheExpiryPolicy;
import com.trivago.triava.tcache.util.SecondsOrMillis;
import com.trivago.triava.tcache.util.Serializing;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.cache.CacheException;

public final class AccessTimeObjectHolder<V>
implements TCacheHolder<V> {
    private static final long serialVersionUID = 1774522368637513622L;
    static transient AtomicIntegerFieldUpdater<AccessTimeObjectHolder> useCountAFU = AtomicIntegerFieldUpdater.newUpdater(AccessTimeObjectHolder.class, "useCount");
    static final int SERIALIZATION_MASK = 3;
    static final int SERIALIZATION_NONE = 0;
    static final int SERIALIZATION_SERIALIZABLE = 1;
    static final int SERIALIZATION_EXTERNALIZABLE = 2;
    static final int STATE_MASK = 96;
    static final int STATE_INCOMPLETE = 0;
    static final int STATE_COMPLETE = 32;
    static final int STATE_RELEASED = 64;
    private volatile Object data;
    private int inputDate;
    private int lastAccess = 0;
    private int maxIdleTime = 0;
    private int maxCacheTime = 0;
    private volatile int useCount = 0;
    private volatile byte flags = 0;

    public AccessTimeObjectHolder(V value, CacheWriteMode writeMode) throws CacheException {
        try {
            switch (writeMode) {
                case Identity: {
                    this.flags = 0;
                    this.data = value;
                    break;
                }
                case Serialize: {
                    if (value instanceof Serializable) {
                        this.flags = 1;
                        byte[] valueAsBytearray = Serializing.toBytearray(value);
                        this.data = valueAsBytearray;
                        break;
                    }
                }
                case Intern: {
                    this.flags = 0;
                }
                default: {
                    throw new UnsupportedOperationException("CacheWriteMode not supported: " + (Object)((Object)writeMode));
                }
            }
        }
        catch (Exception exc) {
            throw new CacheException("Cannot serialize cache value for writeMode " + (Object)((Object)writeMode), (Throwable)exc);
        }
    }

    public AccessTimeObjectHolder(V value, long maxIdleTimeMillis, long maxCacheTimeSecs, CacheWriteMode writeMode) throws CacheException {
        this(value, writeMode);
        this.complete(maxIdleTimeMillis, maxCacheTimeSecs);
    }

    void complete(long maxIdleTimeMillis, long maxCacheTimeMillis) {
        this.maxIdleTime = SecondsOrMillis.fromMillisToInternal(maxIdleTimeMillis);
        this.maxCacheTime = SecondsOrMillis.fromMillisToInternal(maxCacheTimeMillis);
        this.flags = (byte)(this.flags | 0x20);
        this.setInputDate();
        this.setLastAccessTime();
    }

    public static boolean isValid(AccessTimeObjectHolder<?> holder) {
        return holder != null && !holder.isInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean release() {
        AccessTimeObjectHolder accessTimeObjectHolder = this;
        synchronized (accessTimeObjectHolder) {
            boolean alreadyReleased;
            boolean bl = alreadyReleased = (this.flags & 0x60) == 64;
            if (alreadyReleased) {
                return false;
            }
            this.flags = (byte)(this.flags & 0xFFFFFF9F | 0x40);
            return true;
        }
    }

    public void setMaxIdleTime(int idleTime, TimeUnit timeUnit) {
        this.maxIdleTime = SecondsOrMillis.fromMillisToInternal(timeUnit.toMillis(idleTime));
    }

    long calculateMaxIdleTimeFromUpdateOrCreation(boolean updated, TCacheExpiryPolicy expiryPolicy, AccessTimeObjectHolder<V> oldHolder) {
        long tmpIdleTimeMillis;
        long l = tmpIdleTimeMillis = updated ? expiryPolicy.getExpiryForUpdate() : expiryPolicy.getExpiryForCreation();
        if (tmpIdleTimeMillis == -1L) {
            return SecondsOrMillis.fromInternalToMillis(oldHolder.maxIdleTime);
        }
        return tmpIdleTimeMillis;
    }

    public void updateMaxIdleTime(long idleTimeMillis) {
        if (idleTimeMillis == 0L) {
            this.maxIdleTime = 0;
        }
        if (idleTimeMillis > 0L) {
            long cacheDurationMillis = this.currentTimeMillisEstimate() - this.getCreationTime();
            try {
                long newIdleTimeMillis = cacheDurationMillis + idleTimeMillis;
                if (newIdleTimeMillis < cacheDurationMillis) {
                    newIdleTimeMillis = Long.MAX_VALUE;
                }
                this.maxIdleTime = SecondsOrMillis.fromMillisToInternal(newIdleTimeMillis);
            }
            catch (Exception exc) {
                Cache.logger.error("updateMaxIdleTime() failed idleTimeMillis=" + idleTimeMillis + ", getInputDate()=" + this.getCreationTime() + ", cacheDurationMillis=" + cacheDurationMillis);
            }
        }
    }

    @Override
    public long getExpirationTime() {
        long idleDurationMillis = SecondsOrMillis.fromInternalToMillis(this.maxIdleTime);
        long expirationDurationMillis = SecondsOrMillis.fromInternalToMillis(this.maxCacheTime);
        long durationMillis = Math.min(expirationDurationMillis, idleDurationMillis);
        return this.getCreationTime() + durationMillis;
    }

    @Override
    public V get() {
        this.setLastAccessTime();
        return this.peek();
    }

    @Override
    public V peek() {
        int serializationMode = this.flags & 3;
        try {
            switch (serializationMode) {
                case 0: {
                    return (V)this.data;
                }
                case 1: {
                    Object dataRef = this.data;
                    return (V)(dataRef != null ? Serializing.fromBytearray((byte[])dataRef) : null);
                }
            }
            throw new UnsupportedOperationException("Serialization type is not supported: " + serializationMode);
        }
        catch (Exception exc) {
            throw new CacheException("Cannot serialize cache value for serialization type " + serializationMode, (Throwable)exc);
        }
    }

    private void setLastAccessTime() {
        this.lastAccess = (int)(this.currentTimeMillisEstimate() - Cache.baseTimeMillis);
    }

    private long currentTimeMillisEstimate() {
        return Cache.millisEstimator.millis();
    }

    @Override
    public long getLastAccessTime() {
        return Cache.baseTimeMillis + (long)this.lastAccess;
    }

    @Override
    public int getUseCount() {
        return this.useCount;
    }

    public void incrementUseCount() {
        useCountAFU.incrementAndGet(this);
    }

    private void setInputDate() {
        this.inputDate = (int)(this.currentTimeMillisEstimate() - Cache.baseTimeMillis);
    }

    @Override
    public long getCreationTime() {
        return Cache.baseTimeMillis + (long)this.inputDate;
    }

    @Override
    public boolean isInvalid() {
        return this.isInvalid(false);
    }

    private boolean isInvalid(boolean debug) {
        long cacheDurationMillis;
        boolean incomplete;
        if (this.data == null) {
            return true;
        }
        boolean bl = incomplete = (this.flags & 0x60) != 32;
        if (incomplete) {
            if (debug) {
                System.out.println("Dropped because holder is not complete: flags=" + this.flags + ": " + this.data);
            }
            return true;
        }
        long millisNow = this.currentTimeMillisEstimate();
        long expDurationMillis = SecondsOrMillis.fromInternalToMillis(this.maxCacheTime);
        if (expDurationMillis > 0L && (cacheDurationMillis = millisNow - this.getCreationTime()) > expDurationMillis) {
            if (debug) {
                System.out.println("Dropped because expired: millisNow=" + millisNow + ", maxCacheTime" + this.maxCacheTime + ", expDurationMillis" + expDurationMillis + "< cacheDurationMillis" + cacheDurationMillis);
            }
            return true;
        }
        long idleDurationMillis = SecondsOrMillis.fromInternalToMillis(this.maxIdleTime);
        if (idleDurationMillis == 0L) {
            if (debug) {
                System.out.println("Dropped because idle0: millisNow=" + millisNow + ", maxCacheTime" + this.maxCacheTime + ", expDurationMillis" + expDurationMillis + "< cacheDurationMillis" + idleDurationMillis);
            }
            return true;
        }
        long lastAccess = this.getLastAccessTime();
        long idleSince = millisNow - lastAccess;
        if (idleSince > idleDurationMillis) {
            if (debug) {
                System.out.println("Dropped because idle: millisNow=" + millisNow + ", maxCacheTime" + this.maxCacheTime + ", idleDurationMillis" + idleDurationMillis + "< idleSince" + idleSince + ", lastAccess=" + lastAccess);
            }
            return true;
        }
        return false;
    }

    public void setExpireUntil(int maxDelay, TimeUnit timeUnit, Random random) {
        long delayMillis;
        long millis = timeUnit.toMillis(maxDelay);
        if (millis == 0L) {
            delayMillis = millis;
        } else if (millis <= Integer.MAX_VALUE) {
            delayMillis = random.nextInt((int)millis);
        } else {
            int maxDelaySecs = (int)timeUnit.toSeconds(maxDelay);
            delayMillis = 1000L * (long)random.nextInt(maxDelaySecs);
        }
        long maxCacheTimeMillis = SecondsOrMillis.fromInternalToMillis(this.maxCacheTime);
        long creationTime = this.getCreationTime();
        long expirationOnCacheTime = maxCacheTimeMillis + creationTime;
        long expirationOnNewExpireUntil = this.currentTimeMillisEstimate() + delayMillis;
        if (maxCacheTimeMillis == 0L || expirationOnNewExpireUntil < expirationOnCacheTime) {
            long newMaxCacheTimeMillis = expirationOnNewExpireUntil - creationTime;
            this.maxCacheTime = SecondsOrMillis.fromMillisToInternal(newMaxCacheTimeMillis);
        }
    }

    public String toString() {
        return "AccessTimeObjectHolder [dataPresent=" + (this.data != null) + ", inputDate=" + this.inputDate + ", lastAccess=" + this.lastAccess + ", maxIdleTime=" + this.maxIdleTime + ", maxCacheTime=" + this.maxCacheTime + ", useCount=" + this.useCount + ", flags=" + this.flags + "]";
    }
}

