package com.trivago.cluecumber.engine.dagger;

import com.trivago.cluecumber.engine.CluecumberEngine;
import com.trivago.cluecumber.engine.constants.ChartConfiguration;
import com.trivago.cluecumber.engine.constants.ChartConfiguration_Factory;
import com.trivago.cluecumber.engine.filesystem.FileIO;
import com.trivago.cluecumber.engine.filesystem.FileIO_Factory;
import com.trivago.cluecumber.engine.filesystem.FileSystemManager;
import com.trivago.cluecumber.engine.filesystem.FileSystemManager_Factory;
import com.trivago.cluecumber.engine.json.JsonPojoConverter;
import com.trivago.cluecumber.engine.json.JsonPojoConverter_Factory;
import com.trivago.cluecumber.engine.json.processors.ElementIndexPreProcessor;
import com.trivago.cluecumber.engine.json.processors.ElementIndexPreProcessor_Factory;
import com.trivago.cluecumber.engine.json.processors.ElementJsonPostProcessor;
import com.trivago.cluecumber.engine.json.processors.ElementJsonPostProcessor_Factory;
import com.trivago.cluecumber.engine.json.processors.ElementMultipleRunsPreProcessor;
import com.trivago.cluecumber.engine.json.processors.ElementMultipleRunsPreProcessor_Factory;
import com.trivago.cluecumber.engine.json.processors.ReportJsonPostProcessor;
import com.trivago.cluecumber.engine.json.processors.ReportJsonPostProcessor_Factory;
import com.trivago.cluecumber.engine.logging.CluecumberLogger;
import com.trivago.cluecumber.engine.logging.CluecumberLogger_Factory;
import com.trivago.cluecumber.engine.properties.PropertiesFileLoader;
import com.trivago.cluecumber.engine.properties.PropertiesFileLoader_Factory;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.properties.PropertyManager_Factory;
import com.trivago.cluecumber.engine.rendering.ReportGenerator;
import com.trivago.cluecumber.engine.rendering.ReportGenerator_Factory;
import com.trivago.cluecumber.engine.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.engine.rendering.pages.charts.ChartJsonConverter_Factory;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllFeaturesPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllFeaturesPageRenderer_Factory;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllScenariosPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllScenariosPageRenderer_Factory;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllStepsPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllStepsPageRenderer_Factory;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllTagsPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllTagsPageRenderer_Factory;
import com.trivago.cluecumber.engine.rendering.pages.renderering.CustomCssRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.CustomCssRenderer_Factory;
import com.trivago.cluecumber.engine.rendering.pages.renderering.ScenarioDetailsPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.ScenarioDetailsPageRenderer_Factory;
import com.trivago.cluecumber.engine.rendering.pages.renderering.StartPageRenderer_Factory;
import com.trivago.cluecumber.engine.rendering.pages.renderering.TreeViewPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.TreeViewPageRenderer_Factory;
import com.trivago.cluecumber.engine.rendering.pages.templates.TemplateConfiguration;
import com.trivago.cluecumber.engine.rendering.pages.templates.TemplateConfiguration_Factory;
import com.trivago.cluecumber.engine.rendering.pages.templates.TemplateEngine;
import com.trivago.cluecumber.engine.rendering.pages.templates.TemplateEngine_Factory;
import com.trivago.cluecumber.engine.rendering.pages.visitors.FeatureVisitor;
import com.trivago.cluecumber.engine.rendering.pages.visitors.FeatureVisitor_Factory;
import com.trivago.cluecumber.engine.rendering.pages.visitors.ScenarioVisitor;
import com.trivago.cluecumber.engine.rendering.pages.visitors.ScenarioVisitor_Factory;
import com.trivago.cluecumber.engine.rendering.pages.visitors.StepVisitor;
import com.trivago.cluecumber.engine.rendering.pages.visitors.StepVisitor_Factory;
import com.trivago.cluecumber.engine.rendering.pages.visitors.TagVisitor;
import com.trivago.cluecumber.engine.rendering.pages.visitors.TagVisitor_Factory;
import com.trivago.cluecumber.engine.rendering.pages.visitors.VisitorDirectory;
import com.trivago.cluecumber.engine.rendering.pages.visitors.VisitorDirectory_Factory;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Provider;
import javax.annotation.processing.Generated;

@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation"
})
public final class DaggerCluecumberCoreGraph {
  private DaggerCluecumberCoreGraph() {
  }

  public static Builder builder() {
    return new Builder();
  }

  public static CluecumberCoreGraph create() {
    return new Builder().build();
  }

  public static final class Builder {
    private Builder() {
    }

    public CluecumberCoreGraph build() {
      return new CluecumberCoreGraphImpl();
    }
  }

  private static final class CluecumberCoreGraphImpl implements CluecumberCoreGraph {
    private final CluecumberCoreGraphImpl cluecumberCoreGraphImpl = this;

    private Provider<CluecumberLogger> cluecumberLoggerProvider;

    private Provider<FileIO> fileIOProvider;

    private Provider<PropertiesFileLoader> propertiesFileLoaderProvider;

    private Provider<PropertyManager> propertyManagerProvider;

    private Provider<FileSystemManager> fileSystemManagerProvider;

    private Provider<ReportJsonPostProcessor> reportJsonPostProcessorProvider;

    private Provider<ElementJsonPostProcessor> elementJsonPostProcessorProvider;

    private Provider<JsonPojoConverter> jsonPojoConverterProvider;

    private Provider<ElementIndexPreProcessor> elementIndexPreProcessorProvider;

    private Provider<ElementMultipleRunsPreProcessor> elementMultipleRunsPreProcessorProvider;

    private Provider<TemplateConfiguration> templateConfigurationProvider;

    private Provider<TemplateEngine> templateEngineProvider;

    private Provider<CustomCssRenderer> customCssRendererProvider;

    private Provider<ChartJsonConverter> chartJsonConverterProvider;

    private Provider<ChartConfiguration> chartConfigurationProvider;

    private Provider<AllScenariosPageRenderer> allScenariosPageRendererProvider;

    private Provider<ScenarioDetailsPageRenderer> scenarioDetailsPageRendererProvider;

    private Provider<ScenarioVisitor> scenarioVisitorProvider;

    private Provider<AllFeaturesPageRenderer> allFeaturesPageRendererProvider;

    private Provider<TreeViewPageRenderer> treeViewPageRendererProvider;

    private Provider<FeatureVisitor> featureVisitorProvider;

    private Provider<AllTagsPageRenderer> allTagsPageRendererProvider;

    private Provider<TagVisitor> tagVisitorProvider;

    private Provider<AllStepsPageRenderer> allStepsPageRendererProvider;

    private Provider<StepVisitor> stepVisitorProvider;

    private Provider<VisitorDirectory> visitorDirectoryProvider;

    private Provider<ReportGenerator> reportGeneratorProvider;

    private CluecumberCoreGraphImpl() {

      initialize();
      initialize2();

    }

    @SuppressWarnings("unchecked")
    private void initialize() {
      this.cluecumberLoggerProvider = DoubleCheck.provider(CluecumberLogger_Factory.create());
      this.fileIOProvider = DoubleCheck.provider(FileIO_Factory.create());
      this.propertiesFileLoaderProvider = DoubleCheck.provider(PropertiesFileLoader_Factory.create(fileIOProvider));
      this.propertyManagerProvider = DoubleCheck.provider(PropertyManager_Factory.create(cluecumberLoggerProvider, fileIOProvider, propertiesFileLoaderProvider));
      this.fileSystemManagerProvider = DoubleCheck.provider(FileSystemManager_Factory.create(cluecumberLoggerProvider));
      this.reportJsonPostProcessorProvider = DoubleCheck.provider(ReportJsonPostProcessor_Factory.create());
      this.elementJsonPostProcessorProvider = DoubleCheck.provider(ElementJsonPostProcessor_Factory.create(propertyManagerProvider, fileIOProvider, cluecumberLoggerProvider));
      this.jsonPojoConverterProvider = DoubleCheck.provider(JsonPojoConverter_Factory.create(reportJsonPostProcessorProvider, elementJsonPostProcessorProvider));
      this.elementIndexPreProcessorProvider = DoubleCheck.provider(ElementIndexPreProcessor_Factory.create());
      this.elementMultipleRunsPreProcessorProvider = DoubleCheck.provider(ElementMultipleRunsPreProcessor_Factory.create());
      this.templateConfigurationProvider = DoubleCheck.provider(TemplateConfiguration_Factory.create());
      this.templateEngineProvider = DoubleCheck.provider(TemplateEngine_Factory.create(templateConfigurationProvider));
      this.customCssRendererProvider = DoubleCheck.provider(CustomCssRenderer_Factory.create(propertyManagerProvider));
      this.chartJsonConverterProvider = DoubleCheck.provider(ChartJsonConverter_Factory.create());
      this.chartConfigurationProvider = DoubleCheck.provider(ChartConfiguration_Factory.create(propertyManagerProvider));
      this.allScenariosPageRendererProvider = DoubleCheck.provider(AllScenariosPageRenderer_Factory.create(chartJsonConverterProvider, chartConfigurationProvider, propertyManagerProvider));
      this.scenarioDetailsPageRendererProvider = DoubleCheck.provider(ScenarioDetailsPageRenderer_Factory.create(chartJsonConverterProvider, chartConfigurationProvider, propertyManagerProvider));
      this.scenarioVisitorProvider = DoubleCheck.provider(ScenarioVisitor_Factory.create(fileIOProvider, templateEngineProvider, propertyManagerProvider, allScenariosPageRendererProvider, scenarioDetailsPageRendererProvider));
      this.allFeaturesPageRendererProvider = DoubleCheck.provider(AllFeaturesPageRenderer_Factory.create(chartJsonConverterProvider, chartConfigurationProvider, propertyManagerProvider));
      this.treeViewPageRendererProvider = DoubleCheck.provider(TreeViewPageRenderer_Factory.create(propertyManagerProvider));
      this.featureVisitorProvider = DoubleCheck.provider(FeatureVisitor_Factory.create(fileIOProvider, templateEngineProvider, propertyManagerProvider, allFeaturesPageRendererProvider, allScenariosPageRendererProvider, treeViewPageRendererProvider));
      this.allTagsPageRendererProvider = DoubleCheck.provider(AllTagsPageRenderer_Factory.create(chartJsonConverterProvider, chartConfigurationProvider, propertyManagerProvider));
      this.tagVisitorProvider = DoubleCheck.provider(TagVisitor_Factory.create(fileIOProvider, templateEngineProvider, propertyManagerProvider, allTagsPageRendererProvider, allScenariosPageRendererProvider));
      this.allStepsPageRendererProvider = AllStepsPageRenderer_Factory.create(chartJsonConverterProvider, chartConfigurationProvider, propertyManagerProvider);
      this.stepVisitorProvider = DoubleCheck.provider(StepVisitor_Factory.create(fileIOProvider, templateEngineProvider, propertyManagerProvider, allStepsPageRendererProvider, allScenariosPageRendererProvider));
    }

    @SuppressWarnings("unchecked")
    private void initialize2() {
      this.visitorDirectoryProvider = DoubleCheck.provider(VisitorDirectory_Factory.create(scenarioVisitorProvider, featureVisitorProvider, tagVisitorProvider, stepVisitorProvider));
      this.reportGeneratorProvider = DoubleCheck.provider(ReportGenerator_Factory.create(fileIOProvider, templateEngineProvider, propertyManagerProvider, fileSystemManagerProvider, StartPageRenderer_Factory.create(), customCssRendererProvider, visitorDirectoryProvider));
    }

    @Override
    public CluecumberEngine getCluecumberEngine() {
      return new CluecumberEngine(cluecumberLoggerProvider.get(), propertyManagerProvider.get(), fileSystemManagerProvider.get(), fileIOProvider.get(), jsonPojoConverterProvider.get(), elementIndexPreProcessorProvider.get(), elementMultipleRunsPreProcessorProvider.get(), reportGeneratorProvider.get());
    }
  }
}
