package com.trivago.cluecumber.engine;

import com.trivago.cluecumber.engine.filesystem.FileIO;
import com.trivago.cluecumber.engine.filesystem.FileSystemManager;
import com.trivago.cluecumber.engine.json.JsonPojoConverter;
import com.trivago.cluecumber.engine.json.processors.ElementIndexPreProcessor;
import com.trivago.cluecumber.engine.json.processors.ElementMultipleRunsPreProcessor;
import com.trivago.cluecumber.engine.logging.CluecumberLogger;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.ReportGenerator;
import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import javax.inject.Provider;

@ScopeMetadata
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation"
})
public final class CluecumberEngine_Factory implements Factory<CluecumberEngine> {
  private final Provider<CluecumberLogger> loggerProvider;

  private final Provider<PropertyManager> propertyManagerProvider;

  private final Provider<FileSystemManager> fileSystemManagerProvider;

  private final Provider<FileIO> fileIOProvider;

  private final Provider<JsonPojoConverter> jsonPojoConverterProvider;

  private final Provider<ElementIndexPreProcessor> elementIndexPreProcessorProvider;

  private final Provider<ElementMultipleRunsPreProcessor> elementMultipleRunsPreProcessorProvider;

  private final Provider<ReportGenerator> reportGeneratorProvider;

  public CluecumberEngine_Factory(Provider<CluecumberLogger> loggerProvider,
      Provider<PropertyManager> propertyManagerProvider,
      Provider<FileSystemManager> fileSystemManagerProvider, Provider<FileIO> fileIOProvider,
      Provider<JsonPojoConverter> jsonPojoConverterProvider,
      Provider<ElementIndexPreProcessor> elementIndexPreProcessorProvider,
      Provider<ElementMultipleRunsPreProcessor> elementMultipleRunsPreProcessorProvider,
      Provider<ReportGenerator> reportGeneratorProvider) {
    this.loggerProvider = loggerProvider;
    this.propertyManagerProvider = propertyManagerProvider;
    this.fileSystemManagerProvider = fileSystemManagerProvider;
    this.fileIOProvider = fileIOProvider;
    this.jsonPojoConverterProvider = jsonPojoConverterProvider;
    this.elementIndexPreProcessorProvider = elementIndexPreProcessorProvider;
    this.elementMultipleRunsPreProcessorProvider = elementMultipleRunsPreProcessorProvider;
    this.reportGeneratorProvider = reportGeneratorProvider;
  }

  @Override
  public CluecumberEngine get() {
    return newInstance(loggerProvider.get(), propertyManagerProvider.get(), fileSystemManagerProvider.get(), fileIOProvider.get(), jsonPojoConverterProvider.get(), elementIndexPreProcessorProvider.get(), elementMultipleRunsPreProcessorProvider.get(), reportGeneratorProvider.get());
  }

  public static CluecumberEngine_Factory create(Provider<CluecumberLogger> loggerProvider,
      Provider<PropertyManager> propertyManagerProvider,
      Provider<FileSystemManager> fileSystemManagerProvider, Provider<FileIO> fileIOProvider,
      Provider<JsonPojoConverter> jsonPojoConverterProvider,
      Provider<ElementIndexPreProcessor> elementIndexPreProcessorProvider,
      Provider<ElementMultipleRunsPreProcessor> elementMultipleRunsPreProcessorProvider,
      Provider<ReportGenerator> reportGeneratorProvider) {
    return new CluecumberEngine_Factory(loggerProvider, propertyManagerProvider, fileSystemManagerProvider, fileIOProvider, jsonPojoConverterProvider, elementIndexPreProcessorProvider, elementMultipleRunsPreProcessorProvider, reportGeneratorProvider);
  }

  public static CluecumberEngine newInstance(CluecumberLogger logger,
      PropertyManager propertyManager, FileSystemManager fileSystemManager, FileIO fileIO,
      JsonPojoConverter jsonPojoConverter, ElementIndexPreProcessor elementIndexPreProcessor,
      ElementMultipleRunsPreProcessor elementMultipleRunsPreProcessor,
      ReportGenerator reportGenerator) {
    return new CluecumberEngine(logger, propertyManager, fileSystemManager, fileIO, jsonPojoConverter, elementIndexPreProcessor, elementMultipleRunsPreProcessor, reportGenerator);
  }
}
