/*
 * Decompiled with CFR 0.152.
 */
package com.triposo.barone;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.triposo.barone.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FlowLayout
extends ViewGroup {
    public static final int DEFAULT_HORIZONTAL_SPACING = 5;
    public static final int DEFAULT_VERTICAL_SPACING = 5;
    private final int horizontalSpacing;
    private final int verticalSpacing;
    private List<RowMeasurement> currentRows = Collections.emptyList();

    public FlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray styledAttributes = context.obtainStyledAttributes(attrs, R.styleable.FlowLayout);
        this.horizontalSpacing = styledAttributes.getDimensionPixelSize(R.styleable.FlowLayout_android_horizontalSpacing, 5);
        this.verticalSpacing = styledAttributes.getDimensionPixelSize(R.styleable.FlowLayout_android_verticalSpacing, 5);
        styledAttributes.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int maxInternalWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getHorizontalPadding();
        int maxInternalHeight = View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getVerticalPadding();
        ArrayList<RowMeasurement> rows = new ArrayList<RowMeasurement>();
        RowMeasurement currentRow = new RowMeasurement(maxInternalWidth, widthMode);
        rows.add(currentRow);
        for (View child : this.getLayoutChildren()) {
            ViewGroup.LayoutParams childLayoutParams = child.getLayoutParams();
            int childWidthSpec = this.createChildMeasureSpec(childLayoutParams.width, maxInternalWidth, widthMode);
            int childHeightSpec = this.createChildMeasureSpec(childLayoutParams.height, maxInternalHeight, heightMode);
            child.measure(childWidthSpec, childHeightSpec);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (currentRow.wouldExceedMax(childWidth)) {
                currentRow = new RowMeasurement(maxInternalWidth, widthMode);
                rows.add(currentRow);
            }
            currentRow.addChildDimensions(childWidth, childHeight);
        }
        int longestRowWidth = 0;
        int totalRowHeight = 0;
        for (int index = 0; index < rows.size(); ++index) {
            RowMeasurement row = (RowMeasurement)rows.get(index);
            totalRowHeight += row.getHeight();
            if (index < rows.size() - 1) {
                totalRowHeight += this.verticalSpacing;
            }
            longestRowWidth = Math.max(longestRowWidth, row.getWidth());
        }
        this.setMeasuredDimension(widthMode == 0x40000000 ? View.MeasureSpec.getSize((int)widthMeasureSpec) : longestRowWidth + this.getHorizontalPadding(), heightMode == 0x40000000 ? View.MeasureSpec.getSize((int)heightMeasureSpec) : totalRowHeight + this.getVerticalPadding());
        this.currentRows = Collections.unmodifiableList(rows);
    }

    private int createChildMeasureSpec(int childLayoutParam, int max, int parentMode) {
        int spec = childLayoutParam == -1 ? View.MeasureSpec.makeMeasureSpec((int)max, (int)0x40000000) : (childLayoutParam == -2 ? View.MeasureSpec.makeMeasureSpec((int)max, (int)(parentMode == 0 ? 0 : Integer.MIN_VALUE)) : View.MeasureSpec.makeMeasureSpec((int)childLayoutParam, (int)0x40000000));
        return spec;
    }

    protected void onLayout(boolean changed, int leftPosition, int topPosition, int rightPosition, int bottomPosition) {
        int widthOffset = this.getMeasuredWidth() - this.getPaddingRight();
        int x = this.getPaddingLeft();
        int y = this.getPaddingTop();
        Iterator<RowMeasurement> rowIterator = this.currentRows.iterator();
        RowMeasurement currentRow = rowIterator.next();
        for (View child : this.getLayoutChildren()) {
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (x + childWidth > widthOffset) {
                x = this.getPaddingLeft();
                y += currentRow.height + this.verticalSpacing;
                if (rowIterator.hasNext()) {
                    currentRow = rowIterator.next();
                }
            }
            int childY = y + (currentRow.height - childHeight) / 2;
            child.layout(x, childY, x + childWidth, childY + childHeight);
            x += childWidth + this.horizontalSpacing;
        }
    }

    private List<View> getLayoutChildren() {
        ArrayList<View> children = new ArrayList<View>();
        for (int index = 0; index < this.getChildCount(); ++index) {
            View child = this.getChildAt(index);
            if (child.getVisibility() == 8) continue;
            children.add(child);
        }
        return children;
    }

    protected int getVerticalPadding() {
        return this.getPaddingTop() + this.getPaddingBottom();
    }

    protected int getHorizontalPadding() {
        return this.getPaddingLeft() + this.getPaddingRight();
    }

    private final class RowMeasurement {
        private final int maxWidth;
        private final int widthMode;
        private int width;
        private int height;

        public RowMeasurement(int maxWidth, int widthMode) {
            this.maxWidth = maxWidth;
            this.widthMode = widthMode;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean wouldExceedMax(int childWidth) {
            return this.widthMode == 0 ? false : this.getNewWidth(childWidth) > this.maxWidth;
        }

        public void addChildDimensions(int childWidth, int childHeight) {
            this.width = this.getNewWidth(childWidth);
            this.height = Math.max(this.height, childHeight);
        }

        private int getNewWidth(int childWidth) {
            return this.width == 0 ? childWidth : this.width + FlowLayout.this.horizontalSpacing + childWidth;
        }
    }
}

