/*
 * Decompiled with CFR 0.152.
 */
package com.triposo.barone;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.triposo.barone.R;

public class FixedAspectRatioFrameLayout
extends FrameLayout {
    private float aspectRatio;

    public FixedAspectRatioFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FixedAspectRatioFrameLayout);
        this.aspectRatio = a.getFloat(R.styleable.FixedAspectRatioFrameLayout_aspectRatio, 1.3333f);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredHeight;
        int measuredWidth;
        boolean widthDynamic;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int receivedWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int receivedHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            widthDynamic = widthMode == 0x40000000 ? receivedWidth == 0 : true;
        } else if (widthMode == 0x40000000) {
            widthDynamic = false;
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (widthDynamic) {
            int w = (int)((float)receivedHeight * this.aspectRatio);
            measuredWidth = View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000);
            measuredHeight = heightMeasureSpec;
        } else {
            measuredWidth = widthMeasureSpec;
            int h = (int)((float)receivedWidth / this.aspectRatio);
            measuredHeight = View.MeasureSpec.makeMeasureSpec((int)h, (int)0x40000000);
        }
        super.onMeasure(measuredWidth, measuredHeight);
    }
}

