/*
 * Decompiled with CFR 0.152.
 */
package com.trevjonez.polyadapter.providers;

import android.arch.paging.PagedList;
import android.arch.paging.PagedListHacks;
import android.support.v7.util.AdapterListUpdateCallback;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import android.support.v7.widget.RecyclerView;
import com.trevjonez.polyadapter.PolyAdapter;
import com.trevjonez.polyadapter.diffutil.BackgroundPool;
import com.trevjonez.polyadapter.diffutil.CancelDiffException;
import com.trevjonez.polyadapter.diffutil.MainThread;
import com.trevjonez.polyadapter.providers.PolyPagedListProvider;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0012\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007JD\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u001a\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J,\u0010%\u001a\u00020\"2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010'\u001a\u00020(H\u0002J\u0014\u0010)\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/trevjonez/polyadapter/providers/PolyPagedListProvider;", "Lcom/trevjonez/polyadapter/PolyAdapter$ItemProvider;", "paddingItem", "", "backgroundExecutor", "Ljava/util/concurrent/Executor;", "mainThreadExecutor", "(Ljava/lang/Object;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)V", "isContiguous", "", "itemCallback", "Landroid/support/v7/util/DiffUtil$ItemCallback;", "listUpdateCallback", "Landroid/support/v7/util/AdapterListUpdateCallback;", "pagedList", "Landroid/arch/paging/PagedList;", "snapshot", "updateCallback", "com/trevjonez/polyadapter/providers/PolyPagedListProvider$updateCallback$1", "Lcom/trevjonez/polyadapter/providers/PolyPagedListProvider$updateCallback$1;", "updateCount", "", "callback", "Landroid/support/v7/util/DiffUtil$Callback;", "currentUpdateId", "oldSnapshot", "oldOffset", "newSnapshot", "oldSize", "newSize", "getItem", "position", "getItemCount", "onAttach", "", "adapter", "Lcom/trevjonez/polyadapter/PolyAdapter;", "postUpdates", "newList", "result", "Landroid/support/v7/util/DiffUtil$DiffResult;", "updateList", "core_release"})
public final class PolyPagedListProvider
implements PolyAdapter.ItemProvider {
    private AdapterListUpdateCallback listUpdateCallback;
    private DiffUtil.ItemCallback<Object> itemCallback;
    private int updateCount;
    private boolean isContiguous;
    private PagedList<Object> pagedList;
    private PagedList<Object> snapshot;
    private final updateCallback.1 updateCallback;
    private final Object paddingItem;
    private final Executor backgroundExecutor;
    private final Executor mainThreadExecutor;

    @Override
    public void onAttach(@NotNull PolyAdapter adapter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)adapter), (String)"adapter");
        this.listUpdateCallback = new AdapterListUpdateCallback((RecyclerView.Adapter)adapter);
        this.itemCallback = adapter.getItemCallback();
    }

    @Override
    public int getItemCount() {
        Integer n;
        PagedList<Object> pagedList = this.pagedList;
        if (pagedList != null) {
            n = pagedList.size();
        } else {
            PagedList<Object> pagedList2 = this.snapshot;
            n = pagedList2 != null ? Integer.valueOf(pagedList2.size()) : null;
        }
        return n != null ? n : 0;
    }

    @Override
    @NotNull
    public Object getItem(int position) {
        Object object;
        PagedList<Object> pagedListLocal = this.pagedList;
        if (pagedListLocal != null) {
            pagedListLocal.loadAround(position);
            object = pagedListLocal.get(position);
            if (object == null) {
                object = this.paddingItem;
            }
        } else {
            PagedList<Object> snapshotLocal = this.snapshot;
            if (snapshotLocal == null) {
                throw (Throwable)new IndexOutOfBoundsException("Item Provider is empty. " + position);
            }
            object = snapshotLocal.get(position);
            if (object == null) {
                object = this.paddingItem;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"if (pagedListLocal != nu\u2026paddingItem\n      }\n    }");
        return object;
    }

    public final void updateList(@NotNull PagedList<Object> newList) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(newList, (String)"newList");
        if (this.pagedList == null && this.snapshot == null) {
            this.isContiguous = PagedListHacks.getContiguous(newList);
        } else if (PagedListHacks.getContiguous(newList) != this.isContiguous) {
            throw (Throwable)new IllegalArgumentException("PolyPagedListProvider can't handle a mix of contiguous and non-contiguous lists.");
        }
        if (Intrinsics.areEqual(this.pagedList, newList)) {
            return;
        }
        PolyPagedListProvider polyPagedListProvider = this;
        ++polyPagedListProvider.updateCount;
        int currentUpdateId = polyPagedListProvider.updateCount;
        if (this.pagedList == null && this.snapshot == null) {
            this.pagedList = newList;
            newList.addWeakCallback(null, (PagedList.Callback)this.updateCallback);
            AdapterListUpdateCallback adapterListUpdateCallback = this.listUpdateCallback;
            if (adapterListUpdateCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listUpdateCallback");
            }
            adapterListUpdateCallback.onInserted(0, newList.size());
            return;
        }
        PagedList<Object> pagedList = this.pagedList;
        if (pagedList != null) {
            PagedList<Object> pagedList2;
            PagedList<Object> it = pagedList2 = pagedList;
            it.removeWeakCallback((PagedList.Callback)this.updateCallback);
            List list = it.snapshot();
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.arch.paging.PagedList<kotlin.Any>");
            }
            this.snapshot = (PagedList)list;
            this.pagedList = null;
        }
        boolean bl2 = bl = this.snapshot != null && this.pagedList == null;
        if (!bl) {
            String string = "must be in snapshot state to diff";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        PagedList<Object> pagedList3 = this.snapshot;
        if (pagedList3 == null) {
            Intrinsics.throwNpe();
        }
        PagedList<Object> oldSnapshot = pagedList3;
        List list = newList.snapshot();
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.arch.paging.PagedList<kotlin.Any>");
        }
        PagedList newSnapshot = (PagedList)list;
        this.backgroundExecutor.execute(new Runnable(this, oldSnapshot, newSnapshot, currentUpdateId, newList){
            final /* synthetic */ PolyPagedListProvider this$0;
            final /* synthetic */ PagedList $oldSnapshot;
            final /* synthetic */ PagedList $newSnapshot;
            final /* synthetic */ int $currentUpdateId;
            final /* synthetic */ PagedList $newList;

            public final void run() {
                try {
                    int oldOffset = PagedListHacks.getComputeLeadingNulls(this.$oldSnapshot);
                    int newOffset = PagedListHacks.getComputeLeadingNulls(this.$newSnapshot);
                    int oldSize = this.$oldSnapshot.size() - oldOffset - PagedListHacks.getComputeTrailingNulls(this.$oldSnapshot);
                    int newSize = this.$newSnapshot.size() - newOffset - PagedListHacks.getComputeTrailingNulls(this.$newSnapshot);
                    DiffUtil.DiffResult result2 = DiffUtil.calculateDiff((DiffUtil.Callback)PolyPagedListProvider.access$callback(this.this$0, this.$currentUpdateId, this.$oldSnapshot, oldOffset, this.$newSnapshot, oldSize, newSize));
                    PolyPagedListProvider.access$getMainThreadExecutor$p(this.this$0).execute(new Runnable(this, result2){
                        final /* synthetic */ updateList.3 this$0;
                        final /* synthetic */ DiffUtil.DiffResult $result;

                        public final void run() {
                            if (this.this$0.$currentUpdateId == PolyPagedListProvider.access$getUpdateCount$p(this.this$0.this$0)) {
                                boolean bl;
                                boolean bl2 = bl = PolyPagedListProvider.access$getSnapshot$p(this.this$0.this$0) != null && PolyPagedListProvider.access$getPagedList$p(this.this$0.this$0) == null;
                                if (!bl) {
                                    String string = "must be in snapshot state to diff";
                                    throw (Throwable)new IllegalArgumentException(string.toString());
                                }
                                PolyPagedListProvider.access$setPagedList$p(this.this$0.this$0, this.this$0.$newList);
                                PolyPagedListProvider.access$setSnapshot$p(this.this$0.this$0, null);
                                PolyPagedListProvider polyPagedListProvider = this.this$0.this$0;
                                PagedList pagedList = this.this$0.$oldSnapshot;
                                PagedList pagedList2 = this.this$0.$newList;
                                DiffUtil.DiffResult diffResult = this.$result;
                                Intrinsics.checkExpressionValueIsNotNull((Object)diffResult, (String)"result");
                                PolyPagedListProvider.access$postUpdates(polyPagedListProvider, pagedList, pagedList2, diffResult);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = diffResult;
                        }
                    });
                }
                catch (CancelDiffException cancelDiffException) {
                    // empty catch block
                }
            }
            {
                this.this$0 = polyPagedListProvider;
                this.$oldSnapshot = pagedList;
                this.$newSnapshot = pagedList2;
                this.$currentUpdateId = n;
                this.$newList = pagedList3;
            }
        });
    }

    private final DiffUtil.Callback callback(int currentUpdateId, PagedList<Object> oldSnapshot, int oldOffset, PagedList<Object> newSnapshot, int oldSize, int newSize) {
        return new DiffUtil.Callback(this, currentUpdateId, oldSnapshot, oldOffset, newSnapshot, oldSize, newSize){
            final /* synthetic */ PolyPagedListProvider this$0;
            final /* synthetic */ int $currentUpdateId;
            final /* synthetic */ PagedList $oldSnapshot;
            final /* synthetic */ int $oldOffset;
            final /* synthetic */ PagedList $newSnapshot;
            final /* synthetic */ int $oldSize;
            final /* synthetic */ int $newSize;

            @Nullable
            public Object getChangePayload(int oldItemPosition, int newItemPosition) {
                if (this.$currentUpdateId < PolyPagedListProvider.access$getUpdateCount$p(this.this$0)) {
                    throw (Throwable)new CancelDiffException();
                }
                Object oldItem = this.$oldSnapshot.get(oldItemPosition + this.$oldOffset);
                Object newItem = this.$newSnapshot.get(newItemPosition + PagedListHacks.getLeadingNulls(this.$newSnapshot));
                return oldItem == null || newItem == null ? null : PolyPagedListProvider.access$getItemCallback$p(this.this$0).getChangePayload(oldItem, newItem);
            }

            public int getOldListSize() {
                return this.$oldSize;
            }

            public int getNewListSize() {
                return this.$newSize;
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                Object newItem;
                if (this.$currentUpdateId < PolyPagedListProvider.access$getUpdateCount$p(this.this$0)) {
                    throw (Throwable)new CancelDiffException();
                }
                Object oldItem = this.$oldSnapshot.get(oldItemPosition + this.$oldOffset);
                return oldItem == (newItem = this.$newSnapshot.get(newItemPosition + PagedListHacks.getLeadingNulls(this.$newSnapshot))) ? true : (oldItem == null || newItem == null ? false : PolyPagedListProvider.access$getItemCallback$p(this.this$0).areItemsTheSame(oldItem, newItem));
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                Object newItem;
                if (this.$currentUpdateId < PolyPagedListProvider.access$getUpdateCount$p(this.this$0)) {
                    throw (Throwable)new CancelDiffException();
                }
                Object oldItem = this.$oldSnapshot.get(oldItemPosition + this.$oldOffset);
                return oldItem == (newItem = this.$newSnapshot.get(newItemPosition + PagedListHacks.getLeadingNulls(this.$newSnapshot))) ? true : (oldItem == null || newItem == null ? false : PolyPagedListProvider.access$getItemCallback$p(this.this$0).areContentsTheSame(oldItem, newItem));
            }
            {
                this.this$0 = $outer;
                this.$currentUpdateId = $captured_local_variable$1;
                this.$oldSnapshot = $captured_local_variable$2;
                this.$oldOffset = $captured_local_variable$3;
                this.$newSnapshot = $captured_local_variable$4;
                this.$oldSize = $captured_local_variable$5;
                this.$newSize = $captured_local_variable$6;
            }
        };
    }

    private final void postUpdates(PagedList<Object> oldSnapshot, PagedList<Object> newList, DiffUtil.DiffResult result2) {
        int trailingOld = PagedListHacks.getComputeTrailingNulls(oldSnapshot);
        int trailingNew = PagedListHacks.getComputeTrailingNulls(newList);
        int leadingOld = PagedListHacks.getComputeLeadingNulls(oldSnapshot);
        int leadingNew = PagedListHacks.getComputeLeadingNulls(newList);
        if (trailingOld == 0 && trailingNew == 0 && leadingOld == 0 && leadingNew == 0) {
            AdapterListUpdateCallback adapterListUpdateCallback = this.listUpdateCallback;
            if (adapterListUpdateCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listUpdateCallback");
            }
            result2.dispatchUpdatesTo((ListUpdateCallback)adapterListUpdateCallback);
            return;
        }
        if (trailingOld > trailingNew) {
            int count = trailingOld - trailingNew;
            AdapterListUpdateCallback adapterListUpdateCallback = this.listUpdateCallback;
            if (adapterListUpdateCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listUpdateCallback");
            }
            adapterListUpdateCallback.onRemoved(oldSnapshot.size() - count, count);
        } else if (trailingOld < trailingNew) {
            AdapterListUpdateCallback adapterListUpdateCallback = this.listUpdateCallback;
            if (adapterListUpdateCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listUpdateCallback");
            }
            adapterListUpdateCallback.onInserted(oldSnapshot.size(), trailingNew - trailingOld);
        }
        if (leadingOld > leadingNew) {
            AdapterListUpdateCallback adapterListUpdateCallback = this.listUpdateCallback;
            if (adapterListUpdateCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listUpdateCallback");
            }
            adapterListUpdateCallback.onRemoved(0, leadingOld - leadingNew);
        } else if (leadingOld < leadingNew) {
            AdapterListUpdateCallback adapterListUpdateCallback = this.listUpdateCallback;
            if (adapterListUpdateCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listUpdateCallback");
            }
            adapterListUpdateCallback.onInserted(0, leadingNew - leadingOld);
        }
        if (leadingNew != 0) {
            result2.dispatchUpdatesTo(new ListUpdateCallback(this, leadingNew){
                final /* synthetic */ PolyPagedListProvider this$0;
                final /* synthetic */ int $leadingNew;

                public void onInserted(int position, int count) {
                    PolyPagedListProvider.access$getListUpdateCallback$p(this.this$0).onInserted(position + this.$leadingNew, count);
                }

                public void onRemoved(int position, int count) {
                    PolyPagedListProvider.access$getListUpdateCallback$p(this.this$0).onRemoved(position + this.$leadingNew, count);
                }

                public void onMoved(int fromPosition, int toPosition) {
                    PolyPagedListProvider.access$getListUpdateCallback$p(this.this$0).onMoved(fromPosition + this.$leadingNew, toPosition + this.$leadingNew);
                }

                public void onChanged(int position, int count, @Nullable Object payload) {
                    PolyPagedListProvider.access$getListUpdateCallback$p(this.this$0).onChanged(position + this.$leadingNew, count, payload);
                }
                {
                    this.this$0 = $outer;
                    this.$leadingNew = $captured_local_variable$1;
                }
            });
        } else {
            AdapterListUpdateCallback adapterListUpdateCallback = this.listUpdateCallback;
            if (adapterListUpdateCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listUpdateCallback");
            }
            result2.dispatchUpdatesTo((ListUpdateCallback)adapterListUpdateCallback);
        }
    }

    public PolyPagedListProvider(@NotNull Object paddingItem, @NotNull Executor backgroundExecutor, @NotNull Executor mainThreadExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)paddingItem, (String)"paddingItem");
        Intrinsics.checkParameterIsNotNull((Object)backgroundExecutor, (String)"backgroundExecutor");
        Intrinsics.checkParameterIsNotNull((Object)mainThreadExecutor, (String)"mainThreadExecutor");
        this.paddingItem = paddingItem;
        this.backgroundExecutor = backgroundExecutor;
        this.mainThreadExecutor = mainThreadExecutor;
        this.updateCallback = new PagedList.Callback(this){
            final /* synthetic */ PolyPagedListProvider this$0;

            public void onChanged(int position, int count) {
                PolyPagedListProvider.access$getListUpdateCallback$p(this.this$0).onChanged(position, count, null);
            }

            public void onInserted(int position, int count) {
                PolyPagedListProvider.access$getListUpdateCallback$p(this.this$0).onInserted(position, count);
            }

            public void onRemoved(int position, int count) {
                PolyPagedListProvider.access$getListUpdateCallback$p(this.this$0).onRemoved(position, count);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public /* synthetic */ PolyPagedListProvider(Object object, Executor executor2, Executor executor3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            object = Unit.INSTANCE;
        }
        if ((n & 2) != 0) {
            executor2 = BackgroundPool.INSTANCE;
        }
        if ((n & 4) != 0) {
            executor3 = MainThread.INSTANCE;
        }
        this(object, executor2, executor3);
    }

    public PolyPagedListProvider() {
        this(null, null, null, 7, null);
    }

    @NotNull
    public static final /* synthetic */ DiffUtil.Callback access$callback(PolyPagedListProvider $this, int currentUpdateId, @NotNull PagedList oldSnapshot, int oldOffset, @NotNull PagedList newSnapshot, int oldSize, int newSize) {
        return $this.callback(currentUpdateId, (PagedList<Object>)oldSnapshot, oldOffset, (PagedList<Object>)newSnapshot, oldSize, newSize);
    }

    @NotNull
    public static final /* synthetic */ Executor access$getMainThreadExecutor$p(PolyPagedListProvider $this) {
        return $this.mainThreadExecutor;
    }

    public static final /* synthetic */ int access$getUpdateCount$p(PolyPagedListProvider $this) {
        return $this.updateCount;
    }

    public static final /* synthetic */ void access$setUpdateCount$p(PolyPagedListProvider $this, int n) {
        $this.updateCount = n;
    }

    @Nullable
    public static final /* synthetic */ PagedList access$getSnapshot$p(PolyPagedListProvider $this) {
        return $this.snapshot;
    }

    public static final /* synthetic */ void access$setSnapshot$p(PolyPagedListProvider $this, @Nullable PagedList pagedList) {
        $this.snapshot = pagedList;
    }

    @Nullable
    public static final /* synthetic */ PagedList access$getPagedList$p(PolyPagedListProvider $this) {
        return $this.pagedList;
    }

    public static final /* synthetic */ void access$setPagedList$p(PolyPagedListProvider $this, @Nullable PagedList pagedList) {
        $this.pagedList = pagedList;
    }

    public static final /* synthetic */ void access$postUpdates(PolyPagedListProvider $this, @NotNull PagedList oldSnapshot, @NotNull PagedList newList, @NotNull DiffUtil.DiffResult result2) {
        $this.postUpdates((PagedList<Object>)oldSnapshot, (PagedList<Object>)newList, result2);
    }

    @NotNull
    public static final /* synthetic */ DiffUtil.ItemCallback access$getItemCallback$p(PolyPagedListProvider $this) {
        DiffUtil.ItemCallback<Object> itemCallback = $this.itemCallback;
        if (itemCallback == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemCallback");
        }
        return itemCallback;
    }

    public static final /* synthetic */ void access$setItemCallback$p(PolyPagedListProvider $this, @NotNull DiffUtil.ItemCallback itemCallback) {
        $this.itemCallback = itemCallback;
    }

    @NotNull
    public static final /* synthetic */ AdapterListUpdateCallback access$getListUpdateCallback$p(PolyPagedListProvider $this) {
        AdapterListUpdateCallback adapterListUpdateCallback = $this.listUpdateCallback;
        if (adapterListUpdateCallback == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"listUpdateCallback");
        }
        return adapterListUpdateCallback;
    }

    public static final /* synthetic */ void access$setListUpdateCallback$p(PolyPagedListProvider $this, @NotNull AdapterListUpdateCallback adapterListUpdateCallback) {
        $this.listUpdateCallback = adapterListUpdateCallback;
    }
}

