/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle;

import com.trello.rxlifecycle.LifecycleTransformer;
import com.trello.rxlifecycle.UntilLifecycleCompletableTransformer;
import com.trello.rxlifecycle.UntilLifecycleSingleTransformer;
import javax.annotation.Nonnull;
import rx.Completable;
import rx.Observable;
import rx.Single;

final class UntilLifecycleObservableTransformer<T, R>
implements LifecycleTransformer<T> {
    final Observable<R> lifecycle;

    public UntilLifecycleObservableTransformer(@Nonnull Observable<R> lifecycle) {
        this.lifecycle = lifecycle;
    }

    public Observable<T> call(Observable<T> source) {
        return source.takeUntil(this.lifecycle);
    }

    @Override
    @Nonnull
    public Single.Transformer<T, T> forSingle() {
        return new UntilLifecycleSingleTransformer(this.lifecycle);
    }

    @Override
    @Nonnull
    public Completable.CompletableTransformer forCompletable() {
        return new UntilLifecycleCompletableTransformer<R>(this.lifecycle);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UntilLifecycleObservableTransformer that = (UntilLifecycleObservableTransformer)o;
        return this.lifecycle.equals(that.lifecycle);
    }

    public int hashCode() {
        return this.lifecycle.hashCode();
    }

    public String toString() {
        return "UntilLifecycleObservableTransformer{lifecycle=" + this.lifecycle + '}';
    }
}

