/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle;

import com.trello.rxlifecycle.Functions;
import javax.annotation.Nonnull;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

final class TakeUntilGenerator {
    @Nonnull
    static <T> Observable<T> takeUntilEvent(@Nonnull Observable<T> lifecycle, final @Nonnull T event) {
        return lifecycle.takeFirst(new Func1<T, Boolean>(){

            public Boolean call(T lifecycleEvent) {
                return lifecycleEvent.equals(event);
            }
        });
    }

    @Nonnull
    static <T> Observable<Boolean> takeUntilCorrespondingEvent(@Nonnull Observable<T> lifecycle, @Nonnull Func1<T, T> correspondingEvents) {
        return Observable.combineLatest((Observable)lifecycle.take(1).map(correspondingEvents), (Observable)lifecycle.skip(1), (Func2)new Func2<T, T, Boolean>(){

            public Boolean call(T bindUntilEvent, T lifecycleEvent) {
                return lifecycleEvent.equals(bindUntilEvent);
            }
        }).onErrorReturn(Functions.RESUME_FUNCTION).takeFirst(Functions.SHOULD_COMPLETE);
    }

    private TakeUntilGenerator() {
        throw new AssertionError((Object)"No instances!");
    }
}

