/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle;

import android.view.View;
import com.jakewharton.rxbinding.view.RxView;
import com.trello.rxlifecycle.ActivityEvent;
import com.trello.rxlifecycle.FragmentEvent;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.functions.Func2;

public class RxLifecycle {
    private static final Func1<Throwable, Boolean> RESUME_FUNCTION = new Func1<Throwable, Boolean>(){

        public Boolean call(Throwable throwable) {
            if (throwable instanceof OutsideLifecycleException) {
                return true;
            }
            Exceptions.propagate((Throwable)throwable);
            return false;
        }
    };
    private static final Func1<Boolean, Boolean> SHOULD_COMPLETE = new Func1<Boolean, Boolean>(){

        public Boolean call(Boolean shouldComplete) {
            return shouldComplete;
        }
    };
    private static final Func1<ActivityEvent, ActivityEvent> ACTIVITY_LIFECYCLE = new Func1<ActivityEvent, ActivityEvent>(){

        public ActivityEvent call(ActivityEvent lastEvent) {
            switch (lastEvent) {
                case CREATE: {
                    return ActivityEvent.DESTROY;
                }
                case START: {
                    return ActivityEvent.STOP;
                }
                case RESUME: {
                    return ActivityEvent.PAUSE;
                }
                case PAUSE: {
                    return ActivityEvent.STOP;
                }
                case STOP: {
                    return ActivityEvent.DESTROY;
                }
                case DESTROY: {
                    throw new OutsideLifecycleException("Cannot bind to Activity lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + (Object)((Object)lastEvent) + " not yet implemented");
        }
    };
    private static final Func1<FragmentEvent, FragmentEvent> FRAGMENT_LIFECYCLE = new Func1<FragmentEvent, FragmentEvent>(){

        public FragmentEvent call(FragmentEvent lastEvent) {
            switch (lastEvent) {
                case ATTACH: {
                    return FragmentEvent.DETACH;
                }
                case CREATE: {
                    return FragmentEvent.DESTROY;
                }
                case CREATE_VIEW: {
                    return FragmentEvent.DESTROY_VIEW;
                }
                case START: {
                    return FragmentEvent.STOP;
                }
                case RESUME: {
                    return FragmentEvent.PAUSE;
                }
                case PAUSE: {
                    return FragmentEvent.STOP;
                }
                case STOP: {
                    return FragmentEvent.DESTROY_VIEW;
                }
                case DESTROY_VIEW: {
                    return FragmentEvent.DESTROY;
                }
                case DESTROY: {
                    return FragmentEvent.DETACH;
                }
                case DETACH: {
                    throw new OutsideLifecycleException("Cannot bind to Fragment lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + (Object)((Object)lastEvent) + " not yet implemented");
        }
    };

    private RxLifecycle() {
        throw new AssertionError((Object)"No instances");
    }

    public static <T> Observable.Transformer<? super T, ? extends T> bindUntilFragmentEvent(Observable<FragmentEvent> lifecycle, FragmentEvent event) {
        return RxLifecycle.bindUntilEvent(lifecycle, event);
    }

    public static <T> Observable.Transformer<? super T, ? extends T> bindUntilActivityEvent(Observable<ActivityEvent> lifecycle, ActivityEvent event) {
        return RxLifecycle.bindUntilEvent(lifecycle, event);
    }

    private static <T, R> Observable.Transformer<? super T, ? extends T> bindUntilEvent(final Observable<R> lifecycle, final R event) {
        if (lifecycle == null) {
            throw new IllegalArgumentException("Lifecycle must be given");
        }
        if (event == null) {
            throw new IllegalArgumentException("Event must be given");
        }
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> source) {
                return source.takeUntil(lifecycle.takeFirst(new Func1<R, Boolean>(){

                    public Boolean call(R lifecycleEvent) {
                        return lifecycleEvent == event;
                    }
                }));
            }
        };
    }

    public static <T> Observable.Transformer<? super T, ? extends T> bindActivity(Observable<ActivityEvent> lifecycle) {
        return RxLifecycle.bind(lifecycle, ACTIVITY_LIFECYCLE);
    }

    public static <T> Observable.Transformer<? super T, ? extends T> bindFragment(Observable<FragmentEvent> lifecycle) {
        return RxLifecycle.bind(lifecycle, FRAGMENT_LIFECYCLE);
    }

    public static <T> Observable.Transformer<? super T, ? extends T> bindView(View view) {
        if (view == null) {
            throw new IllegalArgumentException("View must be given");
        }
        return RxLifecycle.bindView(RxView.detaches((View)view));
    }

    public static <T, E> Observable.Transformer<? super T, ? extends T> bindView(final Observable<? extends E> lifecycle) {
        if (lifecycle == null) {
            throw new IllegalArgumentException("Lifecycle must be given");
        }
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> source) {
                return source.takeUntil(lifecycle);
            }
        };
    }

    private static <T, R> Observable.Transformer<? super T, ? extends T> bind(Observable<R> lifecycle, final Func1<R, R> correspondingEvents) {
        if (lifecycle == null) {
            throw new IllegalArgumentException("Lifecycle must be given");
        }
        final Observable sharedLifecycle = lifecycle.share();
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> source) {
                return source.takeUntil(Observable.combineLatest((Observable)sharedLifecycle.take(1).map(correspondingEvents), (Observable)sharedLifecycle.skip(1), (Func2)new Func2<R, R, Boolean>(){

                    public Boolean call(R bindUntilEvent, R lifecycleEvent) {
                        return lifecycleEvent == bindUntilEvent;
                    }
                }).onErrorReturn(RESUME_FUNCTION).takeFirst(SHOULD_COMPLETE));
            }
        };
    }

    private static class OutsideLifecycleException
    extends IllegalStateException {
        public OutsideLifecycleException(String detailMessage) {
            super(detailMessage);
        }
    }
}

