/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle;

import com.trello.rxlifecycle.ActivityEvent;
import com.trello.rxlifecycle.FragmentEvent;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public class RxLifecycle {
    private static final Func1<ActivityEvent, ActivityEvent> ACTIVITY_LIFECYCLE = new Func1<ActivityEvent, ActivityEvent>(){

        public ActivityEvent call(ActivityEvent lastEvent) {
            if (lastEvent == null) {
                throw new NullPointerException("Cannot bind to null ActivityEvent.");
            }
            switch (lastEvent) {
                case CREATE: {
                    return ActivityEvent.DESTROY;
                }
                case START: {
                    return ActivityEvent.STOP;
                }
                case RESUME: {
                    return ActivityEvent.PAUSE;
                }
                case PAUSE: {
                    return ActivityEvent.STOP;
                }
                case STOP: {
                    return ActivityEvent.DESTROY;
                }
                case DESTROY: {
                    throw new IllegalStateException("Cannot bind to Activity lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + (Object)((Object)lastEvent) + " not yet implemented");
        }
    };
    private static final Func1<FragmentEvent, FragmentEvent> FRAGMENT_LIFECYCLE = new Func1<FragmentEvent, FragmentEvent>(){

        public FragmentEvent call(FragmentEvent lastEvent) {
            if (lastEvent == null) {
                throw new NullPointerException("Cannot bind to null FragmentEvent.");
            }
            switch (lastEvent) {
                case ATTACH: {
                    return FragmentEvent.DETACH;
                }
                case CREATE: {
                    return FragmentEvent.DESTROY;
                }
                case CREATE_VIEW: {
                    return FragmentEvent.DESTROY_VIEW;
                }
                case START: {
                    return FragmentEvent.STOP;
                }
                case RESUME: {
                    return FragmentEvent.PAUSE;
                }
                case PAUSE: {
                    return FragmentEvent.STOP;
                }
                case STOP: {
                    return FragmentEvent.DESTROY_VIEW;
                }
                case DESTROY_VIEW: {
                    return FragmentEvent.DESTROY;
                }
                case DESTROY: {
                    return FragmentEvent.DETACH;
                }
                case DETACH: {
                    throw new IllegalStateException("Cannot bind to Fragment lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + (Object)((Object)lastEvent) + " not yet implemented");
        }
    };

    private RxLifecycle() {
        throw new AssertionError((Object)"No instances");
    }

    public static <T> Observable.Transformer<T, T> bindUntilFragmentEvent(Observable<FragmentEvent> lifecycle, FragmentEvent event) {
        return RxLifecycle.bindUntilEvent(lifecycle, event);
    }

    public static <T> Observable.Transformer<T, T> bindUntilActivityEvent(Observable<ActivityEvent> lifecycle, ActivityEvent event) {
        return RxLifecycle.bindUntilEvent(lifecycle, event);
    }

    private static <T, R> Observable.Transformer<T, T> bindUntilEvent(final Observable<R> lifecycle, final R event) {
        if (lifecycle == null) {
            throw new IllegalArgumentException("Lifecycle must be given");
        }
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> source) {
                return source.takeUntil(lifecycle.takeFirst(new Func1<R, Boolean>(){

                    public Boolean call(R lifecycleEvent) {
                        return lifecycleEvent == event;
                    }
                }));
            }
        };
    }

    public static <T> Observable.Transformer<T, T> bindActivity(Observable<ActivityEvent> lifecycle) {
        return RxLifecycle.bind(lifecycle, ACTIVITY_LIFECYCLE);
    }

    public static <T> Observable.Transformer<T, T> bindFragment(Observable<FragmentEvent> lifecycle) {
        return RxLifecycle.bind(lifecycle, FRAGMENT_LIFECYCLE);
    }

    private static <T, R> Observable.Transformer<T, T> bind(Observable<R> lifecycle, final Func1<R, R> correspondingEvents) {
        if (lifecycle == null) {
            throw new IllegalArgumentException("Lifecycle must be given");
        }
        final Observable sharedLifecycle = lifecycle.share();
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> source) {
                return source.takeUntil(Observable.combineLatest((Observable)sharedLifecycle.take(1).map(correspondingEvents), (Observable)sharedLifecycle.skip(1), (Func2)new Func2<R, R, Boolean>(){

                    public Boolean call(R bindUntilEvent, R lifecycleEvent) {
                        return lifecycleEvent == bindUntilEvent;
                    }
                }).takeFirst((Func1)new Func1<Boolean, Boolean>(){

                    public Boolean call(Boolean shouldComplete) {
                        return shouldComplete;
                    }
                }));
            }
        };
    }
}

