/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle.components;

import android.app.Activity;
import android.os.Bundle;
import com.trello.rxlifecycle.ActivityEvent;
import com.trello.rxlifecycle.RxLifecycle;
import com.trello.rxlifecycle.components.ActivityLifecycleProvider;
import rx.Observable;
import rx.subjects.BehaviorSubject;

public class RxActivity
extends Activity
implements ActivityLifecycleProvider {
    private final BehaviorSubject<ActivityEvent> lifecycleSubject = BehaviorSubject.create();

    @Override
    public final Observable<ActivityEvent> lifecycle() {
        return this.lifecycleSubject.asObservable();
    }

    @Override
    public final <T> Observable.Transformer<T, T> bindUntilEvent(ActivityEvent event) {
        return RxLifecycle.bindUntilActivityEvent(this.lifecycleSubject, (ActivityEvent)event);
    }

    @Override
    public final <T> Observable.Transformer<T, T> bindToLifecycle() {
        return RxLifecycle.bindActivity(this.lifecycleSubject);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.lifecycleSubject.onNext((Object)ActivityEvent.CREATE);
    }

    protected void onStart() {
        super.onStart();
        this.lifecycleSubject.onNext((Object)ActivityEvent.START);
    }

    protected void onResume() {
        super.onResume();
        this.lifecycleSubject.onNext((Object)ActivityEvent.RESUME);
    }

    protected void onPause() {
        this.lifecycleSubject.onNext((Object)ActivityEvent.PAUSE);
        super.onPause();
    }

    protected void onStop() {
        this.lifecycleSubject.onNext((Object)ActivityEvent.STOP);
        super.onStop();
    }

    protected void onDestroy() {
        this.lifecycleSubject.onNext((Object)ActivityEvent.DESTROY);
        super.onDestroy();
    }
}

