/*
 * Decompiled with CFR 0.152.
 */
package com.trello.navi2.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.trello.navi2.Event;
import com.trello.navi2.Listener;
import com.trello.navi2.NaviComponent;
import com.trello.navi2.internal.Constants;
import com.trello.navi2.internal.HandledEvents;
import com.trello.navi2.model.ActivityResult;
import com.trello.navi2.model.BundleBundle;
import com.trello.navi2.model.RequestPermissionsResult;
import com.trello.navi2.model.ViewCreated;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class NaviEmitter
implements NaviComponent {
    private final Set<Event<?>> handledEvents;
    private final Map<Event<?>, List<Listener>> listenerMap;
    private final Map<Listener, Event<?>> eventMap;

    public NaviEmitter(@NonNull Collection<Event<?>> handledEvents) {
        this.handledEvents = Collections.unmodifiableSet(new HashSet(handledEvents));
        this.listenerMap = new ConcurrentHashMap();
        this.eventMap = new ConcurrentHashMap();
    }

    public static NaviEmitter createActivityEmitter() {
        return new NaviEmitter(HandledEvents.ACTIVITY_EVENTS);
    }

    public static NaviEmitter createFragmentEmitter() {
        return new NaviEmitter(HandledEvents.FRAGMENT_EVENTS);
    }

    @Override
    public final boolean handlesEvents(Event ... events) {
        for (int a = 0; a < events.length; ++a) {
            Event event = events[a];
            if (event == Event.ALL || this.handledEvents.contains(event)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final <T> void addListener(@NonNull Event<T> event, @NonNull Listener<T> listener) {
        if (!this.handlesEvents(event)) {
            throw new IllegalArgumentException("This component cannot handle event " + event);
        }
        if (this.eventMap.containsKey(listener)) {
            Event<?> otherEvent = this.eventMap.get(listener);
            if (!event.equals(otherEvent)) {
                throw new IllegalStateException("Cannot use the same listener for two events! e1: " + event + " e2: " + otherEvent);
            }
            return;
        }
        this.eventMap.put(listener, event);
        if (!this.listenerMap.containsKey(event)) {
            this.listenerMap.put(event, new CopyOnWriteArrayList());
        }
        List<Listener> listeners = this.listenerMap.get(event);
        listeners.add(listener);
    }

    @Override
    public final <T> void removeListener(@NonNull Listener<T> listener) {
        Event<?> event = this.eventMap.remove(listener);
        if (event != null && this.listenerMap.containsKey(event)) {
            this.listenerMap.get(event).remove(listener);
        }
    }

    private void emitEvent(@NonNull Event<Object> event) {
        this.emitEvent(event, Constants.SIGNAL);
    }

    private <T> void emitEvent(@NonNull Event<T> event, @NonNull T data) {
        Iterator<Listener> allListenersIterator;
        List<Listener> listeners = this.listenerMap.get(event);
        ListIterator<Listener> listenersIterator = listeners != null ? listeners.listIterator() : null;
        List<Listener> allListeners = this.listenerMap.get(Event.ALL);
        Iterator<Listener> iterator = allListenersIterator = allListeners != null ? allListeners.iterator() : null;
        if (allListenersIterator != null) {
            Event.Type type = event.type();
            while (allListenersIterator.hasNext()) {
                allListenersIterator.next().call(type);
            }
        }
        if (listeners != null) {
            while (listenersIterator.hasNext()) {
                ((Listener)listenersIterator.next()).call(data);
            }
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        this.emitEvent(Event.ACTIVITY_CREATED, savedInstanceState != null ? savedInstanceState : new Bundle());
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        this.emitEvent(Event.ACTIVITY_RESULT, ActivityResult.create(requestCode, resultCode, data));
    }

    public void onAttach(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT < 23) {
            this.emitEvent(Event.ATTACH, activity);
        }
    }

    public void onAttach(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.emitEvent(Event.ATTACH, context);
        }
    }

    public void onAttachedToWindow() {
        this.emitEvent(Event.ATTACHED_TO_WINDOW);
    }

    public void onBackPressed() {
        this.emitEvent(Event.BACK_PRESSED);
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        this.emitEvent(Event.CONFIGURATION_CHANGED, newConfig);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        this.emitEvent(Event.CREATE, savedInstanceState != null ? savedInstanceState : new Bundle());
    }

    public void onCreate(@Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        this.emitEvent(Event.CREATE_PERSISTABLE, BundleBundle.create(savedInstanceState, persistentState));
    }

    public void onCreateView(@Nullable Bundle savedInstanceState) {
        this.emitEvent(Event.CREATE_VIEW, savedInstanceState != null ? savedInstanceState : new Bundle());
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        this.emitEvent(Event.VIEW_CREATED, ViewCreated.create(view, bundle));
    }

    public void onDestroy() {
        this.emitEvent(Event.DESTROY);
    }

    public void onDestroyView() {
        this.emitEvent(Event.DESTROY_VIEW);
    }

    public void onDetach() {
        this.emitEvent(Event.DETACH);
    }

    public void onDetachedFromWindow() {
        this.emitEvent(Event.DETACHED_FROM_WINDOW);
    }

    public void onNewIntent(@NonNull Intent intent) {
        this.emitEvent(Event.NEW_INTENT, intent);
    }

    public void onPause() {
        this.emitEvent(Event.PAUSE);
    }

    public void onPostCreate(@Nullable Bundle savedInstanceState) {
        this.emitEvent(Event.POST_CREATE, savedInstanceState != null ? savedInstanceState : new Bundle());
    }

    public void onPostCreate(@Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        this.emitEvent(Event.POST_CREATE_PERSISTABLE, BundleBundle.create(savedInstanceState, persistentState));
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.emitEvent(Event.REQUEST_PERMISSIONS_RESULT, RequestPermissionsResult.create(requestCode, permissions, grantResults));
    }

    public void onRestart() {
        this.emitEvent(Event.RESTART);
    }

    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        this.emitEvent(Event.RESTORE_INSTANCE_STATE, savedInstanceState != null ? savedInstanceState : new Bundle());
    }

    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        this.emitEvent(Event.RESTORE_INSTANCE_STATE_PERSISTABLE, BundleBundle.create(savedInstanceState, persistentState));
    }

    public void onResume() {
        this.emitEvent(Event.RESUME);
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        this.emitEvent(Event.SAVE_INSTANCE_STATE, outState);
    }

    public void onSaveInstanceState(@NonNull Bundle outState, @NonNull PersistableBundle outPersistentState) {
        this.emitEvent(Event.SAVE_INSTANCE_STATE_PERSISTABLE, BundleBundle.create(outState, outPersistentState));
    }

    public void onStart() {
        this.emitEvent(Event.START);
    }

    public void onStop() {
        this.emitEvent(Event.STOP);
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        this.emitEvent(Event.VIEW_STATE_RESTORED, savedInstanceState != null ? savedInstanceState : new Bundle());
    }
}

