/*
 * Decompiled with CFR 0.152.
 */
package com.trello.navi2;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.trello.navi2.model.ActivityResult;
import com.trello.navi2.model.BundleBundle;
import com.trello.navi2.model.RequestPermissionsResult;
import com.trello.navi2.model.ViewCreated;

public final class Event<T> {
    public static final Event<Type> ALL = new Event<Type>(Type.ALL, Type.class);
    public static final Event<Bundle> CREATE = new Event<Bundle>(Type.CREATE, Bundle.class);
    public static final Event<BundleBundle> CREATE_PERSISTABLE = new Event<BundleBundle>(Type.CREATE_PERSISTABLE, BundleBundle.class);
    public static final Event<Object> START = new Event<Object>(Type.START, Object.class);
    public static final Event<Bundle> POST_CREATE = new Event<Bundle>(Type.POST_CREATE, Bundle.class);
    public static final Event<BundleBundle> POST_CREATE_PERSISTABLE = new Event<BundleBundle>(Type.POST_CREATE_PERSISTABLE, BundleBundle.class);
    public static final Event<Object> RESUME = new Event<Object>(Type.RESUME, Object.class);
    public static final Event<Object> PAUSE = new Event<Object>(Type.PAUSE, Object.class);
    public static final Event<Object> STOP = new Event<Object>(Type.STOP, Object.class);
    public static final Event<Object> DESTROY = new Event<Object>(Type.DESTROY, Object.class);
    public static final Event<Bundle> SAVE_INSTANCE_STATE = new Event<Bundle>(Type.SAVE_INSTANCE_STATE, Bundle.class);
    public static final Event<BundleBundle> SAVE_INSTANCE_STATE_PERSISTABLE = new Event<BundleBundle>(Type.SAVE_INSTANCE_STATE_PERSISTABLE, BundleBundle.class);
    public static final Event<Configuration> CONFIGURATION_CHANGED = new Event<Configuration>(Type.CONFIGURATION_CHANGED, Configuration.class);
    public static final Event<ActivityResult> ACTIVITY_RESULT = new Event<ActivityResult>(Type.ACTIVITY_RESULT, ActivityResult.class);
    public static final Event<RequestPermissionsResult> REQUEST_PERMISSIONS_RESULT = new Event<RequestPermissionsResult>(Type.REQUEST_PERMISSIONS_RESULT, RequestPermissionsResult.class);
    public static final Event<Object> RESTART = new Event<Object>(Type.RESTART, Object.class);
    public static final Event<Bundle> RESTORE_INSTANCE_STATE = new Event<Bundle>(Type.RESTORE_INSTANCE_STATE, Bundle.class);
    public static final Event<BundleBundle> RESTORE_INSTANCE_STATE_PERSISTABLE = new Event<BundleBundle>(Type.RESTORE_INSTANCE_STATE_PERSISTABLE, BundleBundle.class);
    public static final Event<Intent> NEW_INTENT = new Event<Intent>(Type.NEW_INTENT, Intent.class);
    public static final Event<Object> BACK_PRESSED = new Event<Object>(Type.BACK_PRESSED, Object.class);
    public static final Event<Object> ATTACHED_TO_WINDOW = new Event<Object>(Type.ATTACHED_TO_WINDOW, Object.class);
    public static final Event<Object> DETACHED_FROM_WINDOW = new Event<Object>(Type.DETACHED_FROM_WINDOW, Object.class);
    public static final Event<Context> ATTACH = new Event<Context>(Type.ATTACH, Context.class);
    public static final Event<Bundle> CREATE_VIEW = new Event<Bundle>(Type.CREATE_VIEW, Bundle.class);
    public static final Event<ViewCreated> VIEW_CREATED = new Event<ViewCreated>(Type.VIEW_CREATED, ViewCreated.class);
    public static final Event<Bundle> ACTIVITY_CREATED = new Event<Bundle>(Type.ACTIVITY_CREATED, Bundle.class);
    public static final Event<Bundle> VIEW_STATE_RESTORED = new Event<Bundle>(Type.VIEW_STATE_RESTORED, Bundle.class);
    public static final Event<Object> DESTROY_VIEW = new Event<Object>(Type.DESTROY_VIEW, Object.class);
    public static final Event<Object> DETACH = new Event<Object>(Type.DETACH, Object.class);
    private final Type eventType;
    private final Class<T> callbackType;

    private Event(@NonNull Type eventType, @NonNull Class<T> callbackType) {
        this.eventType = eventType;
        this.callbackType = callbackType;
    }

    public Type type() {
        return this.eventType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.eventType != event.eventType) {
            return false;
        }
        return this.callbackType.equals(event.callbackType);
    }

    public int hashCode() {
        int result = this.eventType.hashCode();
        result = 31 * result + this.callbackType.hashCode();
        return result;
    }

    public String toString() {
        return "Event{eventType=" + (Object)((Object)this.eventType) + ", callbackType=" + this.callbackType + '}';
    }

    public static enum Type {
        ALL,
        CREATE,
        START,
        RESUME,
        PAUSE,
        STOP,
        DESTROY,
        SAVE_INSTANCE_STATE,
        CONFIGURATION_CHANGED,
        ACTIVITY_RESULT,
        REQUEST_PERMISSIONS_RESULT,
        CREATE_PERSISTABLE,
        POST_CREATE,
        POST_CREATE_PERSISTABLE,
        RESTART,
        SAVE_INSTANCE_STATE_PERSISTABLE,
        RESTORE_INSTANCE_STATE,
        RESTORE_INSTANCE_STATE_PERSISTABLE,
        NEW_INTENT,
        BACK_PRESSED,
        ATTACHED_TO_WINDOW,
        DETACHED_FROM_WINDOW,
        ATTACH,
        CREATE_VIEW,
        VIEW_CREATED,
        ACTIVITY_CREATED,
        VIEW_STATE_RESTORED,
        DESTROY_VIEW,
        DETACH;

    }
}

