/*
 * Decompiled with CFR 0.152.
 */
package com.trello.navi.rx;

import com.trello.navi.Event;
import com.trello.navi.Listener;
import com.trello.navi.NaviComponent;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

final class NaviOnSubscribe<T>
implements Observable.OnSubscribe<T> {
    private final NaviComponent component;
    private final Event<T> event;

    NaviOnSubscribe(NaviComponent component, Event<T> event) {
        this.component = component;
        this.event = event;
    }

    public void call(final Subscriber<? super T> subscriber) {
        final Listener listener = new Listener<T>(){

            @Override
            public void call(T t) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext(t);
                }
            }
        };
        this.component.addListener(this.event, listener);
        subscriber.add(Subscriptions.create((Action0)new Action0(){

            public void call() {
                NaviOnSubscribe.this.component.removeListener(listener);
            }
        }));
    }
}

