/*
 * Decompiled with CFR 0.152.
 */
package com.trello.navi.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import com.trello.navi.Event;
import com.trello.navi.Listener;
import com.trello.navi.NaviComponent;
import com.trello.navi.internal.HandledEvents;
import com.trello.navi.model.ActivityResult;
import com.trello.navi.model.BundleBundle;
import com.trello.navi.model.RequestPermissionsResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class NaviEmitter
implements NaviComponent {
    private final Set<Event<?>> handledEvents;
    private final Map<Event<?>, List<Listener>> listenerMap;
    private final Map<Listener, Event<?>> eventMap;

    public NaviEmitter(@NonNull Collection<Event<?>> handledEvents) {
        this.handledEvents = Collections.unmodifiableSet(new HashSet(handledEvents));
        this.listenerMap = new ConcurrentHashMap();
        this.eventMap = new ConcurrentHashMap();
    }

    public static NaviEmitter createActivityEmitter() {
        return new NaviEmitter(HandledEvents.ACTIVITY_EVENTS);
    }

    public static NaviEmitter createFragmentEmitter() {
        return new NaviEmitter(HandledEvents.FRAGMENT_EVENTS);
    }

    @Override
    public boolean handlesEvents(Event ... events) {
        for (int a = 0; a < events.length; ++a) {
            Event event = events[a];
            if (event == Event.ALL || this.handledEvents.contains(event)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> void addListener(Event<T> event, Listener<T> listener) {
        if (!this.handlesEvents(event)) {
            throw new IllegalArgumentException("This component cannot handle event " + event);
        }
        if (this.eventMap.containsKey(listener)) {
            Event<?> otherEvent = this.eventMap.get(listener);
            if (!event.equals(otherEvent)) {
                throw new IllegalStateException("Cannot use the same listener for two events! e1: " + event + " e2: " + otherEvent);
            }
            return;
        }
        this.eventMap.put(listener, event);
        if (!this.listenerMap.containsKey(event)) {
            this.listenerMap.put(event, new CopyOnWriteArrayList());
        }
        List<Listener> listeners = this.listenerMap.get(event);
        listeners.add(listener);
    }

    @Override
    public <T> void removeListener(Listener<T> listener) {
        Event<?> event = this.eventMap.remove(listener);
        if (event != null && this.listenerMap.containsKey(event)) {
            this.listenerMap.get(event).remove(listener);
        }
    }

    private void emitEvent(Event<Void> event) {
        this.emitEvent(event, null);
    }

    private <T> void emitEvent(Event<T> event, T data) {
        Iterator<Listener> allListenersIterator;
        List<Listener> listeners = this.listenerMap.get(event);
        ListIterator<Listener> listenersIterator = listeners != null ? listeners.listIterator() : null;
        List<Listener> allListeners = this.listenerMap.get(Event.ALL);
        Iterator<Listener> iterator = allListenersIterator = allListeners != null ? allListeners.iterator() : null;
        if (allListenersIterator != null) {
            Event.Type type = event.type();
            while (allListenersIterator.hasNext()) {
                allListenersIterator.next().call(type);
            }
        }
        if (listeners != null) {
            while (listenersIterator.hasNext()) {
                ((Listener)listenersIterator.next()).call(data);
            }
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        this.emitEvent(Event.ACTIVITY_CREATED, savedInstanceState);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.emitEvent(Event.ACTIVITY_RESULT, new ActivityResult(requestCode, resultCode, data));
    }

    public void onAttach(Activity activity) {
        if (Build.VERSION.SDK_INT < 23) {
            this.emitEvent(Event.ATTACH, activity);
        }
    }

    public void onAttach(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.emitEvent(Event.ATTACH, context);
        }
    }

    public void onAttachedToWindow() {
        this.emitEvent(Event.ATTACHED_TO_WINDOW);
    }

    public void onBackPressed() {
        this.emitEvent(Event.BACK_PRESSED);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.emitEvent(Event.CONFIGURATION_CHANGED, newConfig);
    }

    public void onCreate(Bundle savedInstanceState) {
        this.emitEvent(Event.CREATE, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState, PersistableBundle persistentState) {
        this.emitEvent(Event.CREATE_PERSISTABLE, new BundleBundle(savedInstanceState, persistentState));
    }

    public void onCreateView(Bundle savedInstanceState) {
        this.emitEvent(Event.CREATE_VIEW, savedInstanceState);
    }

    public void onDestroy() {
        this.emitEvent(Event.DESTROY);
    }

    public void onDestroyView() {
        this.emitEvent(Event.DESTROY_VIEW);
    }

    public void onDetach() {
        this.emitEvent(Event.DETACH);
    }

    public void onDetachedFromWindow() {
        this.emitEvent(Event.DETACHED_FROM_WINDOW);
    }

    public void onNewIntent(Intent intent) {
        this.emitEvent(Event.NEW_INTENT, intent);
    }

    public void onPause() {
        this.emitEvent(Event.PAUSE);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        this.emitEvent(Event.REQUEST_PERMISSIONS_RESULT, new RequestPermissionsResult(requestCode, permissions, grantResults));
    }

    public void onRestart() {
        this.emitEvent(Event.RESTART);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        this.emitEvent(Event.RESTORE_INSTANCE_STATE, savedInstanceState);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState, PersistableBundle persistentState) {
        this.emitEvent(Event.RESTORE_INSTANCE_STATE_PERSISTABLE, new BundleBundle(savedInstanceState, persistentState));
    }

    public void onResume() {
        this.emitEvent(Event.RESUME);
    }

    public void onSaveInstanceState(Bundle outState) {
        this.emitEvent(Event.SAVE_INSTANCE_STATE, outState);
    }

    public void onSaveInstanceState(Bundle outState, PersistableBundle outPersistentState) {
        this.emitEvent(Event.SAVE_INSTANCE_STATE_PERSISTABLE, new BundleBundle(outState, outPersistentState));
    }

    public void onStart() {
        this.emitEvent(Event.START);
    }

    public void onStop() {
        this.emitEvent(Event.STOP);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        this.emitEvent(Event.VIEW_STATE_RESTORED, savedInstanceState);
    }
}

