/*
 * Decompiled with CFR 0.152.
 */
package com.trello.navi;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import com.trello.navi.model.ActivityResult;
import com.trello.navi.model.BundleBundle;
import com.trello.navi.model.RequestPermissionsResult;

public final class Event<T> {
    public static final Event<Type> ALL = new Event<Type>(Type.ALL, Type.class);
    public static final Event<Bundle> CREATE = new Event<Bundle>(Type.CREATE, Bundle.class);
    public static final Event<BundleBundle> CREATE_PERSISTABLE = new Event<BundleBundle>(Type.CREATE_PERSISTABLE, BundleBundle.class);
    public static final Event<Void> START = new Event<Void>(Type.START, Void.class);
    public static final Event<Void> RESUME = new Event<Void>(Type.RESUME, Void.class);
    public static final Event<Void> PAUSE = new Event<Void>(Type.PAUSE, Void.class);
    public static final Event<Void> STOP = new Event<Void>(Type.STOP, Void.class);
    public static final Event<Void> DESTROY = new Event<Void>(Type.DESTROY, Void.class);
    public static final Event<Bundle> SAVE_INSTANCE_STATE = new Event<Bundle>(Type.SAVE_INSTANCE_STATE, Bundle.class);
    public static final Event<BundleBundle> SAVE_INSTANCE_STATE_PERSISTABLE = new Event<BundleBundle>(Type.SAVE_INSTANCE_STATE_PERSISTABLE, BundleBundle.class);
    public static final Event<Configuration> CONFIGURATION_CHANGED = new Event<Configuration>(Type.CONFIGURATION_CHANGED, Configuration.class);
    public static final Event<ActivityResult> ACTIVITY_RESULT = new Event<ActivityResult>(Type.ACTIVITY_RESULT, ActivityResult.class);
    public static final Event<RequestPermissionsResult> REQUEST_PERMISSIONS_RESULT = new Event<RequestPermissionsResult>(Type.REQUEST_PERMISSIONS_RESULT, RequestPermissionsResult.class);
    public static final Event<Void> RESTART = new Event<Void>(Type.RESTART, Void.class);
    public static final Event<Bundle> RESTORE_INSTANCE_STATE = new Event<Bundle>(Type.RESTORE_INSTANCE_STATE, Bundle.class);
    public static final Event<BundleBundle> RESTORE_INSTANCE_STATE_PERSISTABLE = new Event<BundleBundle>(Type.RESTORE_INSTANCE_STATE_PERSISTABLE, BundleBundle.class);
    public static final Event<Intent> NEW_INTENT = new Event<Intent>(Type.NEW_INTENT, Intent.class);
    public static final Event<Void> BACK_PRESSED = new Event<Void>(Type.BACK_PRESSED, Void.class);
    public static final Event<Void> ATTACHED_TO_WINDOW = new Event<Void>(Type.ATTACHED_TO_WINDOW, Void.class);
    public static final Event<Void> DETACHED_FROM_WINDOW = new Event<Void>(Type.DETACHED_FROM_WINDOW, Void.class);
    public static final Event<Context> ATTACH = new Event<Context>(Type.ATTACH, Context.class);
    public static final Event<Bundle> CREATE_VIEW = new Event<Bundle>(Type.CREATE_VIEW, Bundle.class);
    public static final Event<Bundle> ACTIVITY_CREATED = new Event<Bundle>(Type.ACTIVITY_CREATED, Bundle.class);
    public static final Event<Bundle> VIEW_STATE_RESTORED = new Event<Bundle>(Type.VIEW_STATE_RESTORED, Bundle.class);
    public static final Event<Void> DESTROY_VIEW = new Event<Void>(Type.DESTROY_VIEW, Void.class);
    public static final Event<Void> DETACH = new Event<Void>(Type.DETACH, Void.class);
    private final Type eventType;
    private final Class<T> callbackType;

    private Event(Type eventType, Class<T> callbackType) {
        this.eventType = eventType;
        this.callbackType = callbackType;
    }

    public Type type() {
        return this.eventType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.eventType != event.eventType) {
            return false;
        }
        return this.callbackType.equals(event.callbackType);
    }

    public int hashCode() {
        int result = this.eventType.hashCode();
        result = 31 * result + this.callbackType.hashCode();
        return result;
    }

    public String toString() {
        return "Event{eventType=" + (Object)((Object)this.eventType) + ", callbackType=" + this.callbackType + '}';
    }

    public static enum Type {
        ALL,
        CREATE,
        START,
        RESUME,
        PAUSE,
        STOP,
        DESTROY,
        SAVE_INSTANCE_STATE,
        CONFIGURATION_CHANGED,
        ACTIVITY_RESULT,
        REQUEST_PERMISSIONS_RESULT,
        CREATE_PERSISTABLE,
        RESTART,
        SAVE_INSTANCE_STATE_PERSISTABLE,
        RESTORE_INSTANCE_STATE,
        RESTORE_INSTANCE_STATE_PERSISTABLE,
        NEW_INTENT,
        BACK_PRESSED,
        ATTACHED_TO_WINDOW,
        DETACHED_FROM_WINDOW,
        ATTACH,
        CREATE_VIEW,
        ACTIVITY_CREATED,
        VIEW_STATE_RESTORED,
        DESTROY_VIEW,
        DETACH;

    }
}

