/*
 * Decompiled with CFR 0.152.
 */
package com.trafi.anchorbottomsheetbehavior;

import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.trafi.anchorbottomsheetbehavior.AnchorBottomSheetBehavior;

public class BottomSheetUtils {
    public static void setupViewPager(ViewPager pager) {
        View bottomSheetView = BottomSheetUtils.findBottomSheetView((View)pager);
        if (bottomSheetView != null) {
            pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new BottomSheetViewPagerListener(pager, bottomSheetView));
        }
    }

    private static View findBottomSheetView(View root) {
        View current = root;
        while (current != null) {
            ViewGroup.LayoutParams params = current.getLayoutParams();
            if (params instanceof CoordinatorLayout.LayoutParams && ((CoordinatorLayout.LayoutParams)params).getBehavior() instanceof AnchorBottomSheetBehavior) {
                return current;
            }
            ViewParent parent = current.getParent();
            current = parent == null || !(parent instanceof View) ? null : (View)parent;
        }
        return null;
    }

    private static class BottomSheetViewPagerListener
    extends ViewPager.SimpleOnPageChangeListener {
        private final View pager;
        private final AnchorBottomSheetBehavior behavior;

        private BottomSheetViewPagerListener(ViewPager pager, View bottomSheetView) {
            this.pager = pager;
            this.behavior = AnchorBottomSheetBehavior.from(bottomSheetView);
        }

        public void onPageSelected(int position) {
            this.pager.post(new Runnable(){

                @Override
                public void run() {
                    BottomSheetViewPagerListener.this.behavior.invalidateScrollingChild();
                }
            });
        }
    }
}

