/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.util;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

public class ViewUtils {
    public static final int LAYOUT_PARAMS_TOP_R = 1;
    public static final int LAYOUT_PARAMS_TOP_L = 2;
    public static final int LAYOUT_PARAMS_BOT_R = 3;
    public static final int LAYOUT_PARAMS_BOT_L = 4;

    public static ViewGroup.LayoutParams generateLayoutParamsByViewGroup(ViewGroup viewGroup, int n2, int n3, int n4) {
        if (viewGroup instanceof FrameLayout) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n2, n3);
            ViewUtils.setFrameLayoutParamsPosition(layoutParams, n4);
            return layoutParams;
        }
        if (viewGroup instanceof RelativeLayout) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n2, n3);
            ViewUtils.setRelativeLayoutParamsPosition(layoutParams, n4);
            return layoutParams;
        }
        if (viewGroup instanceof LinearLayout) {
            LinearLayout.LayoutParams layoutParams;
            viewGroup = layoutParams;
            layoutParams = new LinearLayout.LayoutParams(n2, n3);
            switch (n4) {
                default: {
                    break;
                }
                case 4: {
                    viewGroup.gravity = 83;
                    break;
                }
                case 3: {
                    viewGroup.gravity = 85;
                    break;
                }
                case 2: {
                    viewGroup.gravity = 51;
                    break;
                }
                case 1: {
                    viewGroup.gravity = 53;
                }
            }
            return viewGroup;
        }
        return new ViewGroup.LayoutParams(n2, n3);
    }

    public static void setFrameLayoutParamsPosition(FrameLayout.LayoutParams layoutParams, int n2) {
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                layoutParams.gravity = 83;
                break;
            }
            case 3: {
                layoutParams.gravity = 85;
                break;
            }
            case 2: {
                layoutParams.gravity = 51;
                break;
            }
            case 1: {
                layoutParams.gravity = 53;
            }
        }
    }

    public static void setRelativeLayoutParamsPosition(RelativeLayout.LayoutParams layoutParams, int n2) {
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                RelativeLayout.LayoutParams layoutParams2 = layoutParams;
                layoutParams2.addRule(12);
                layoutParams2.addRule(9);
                break;
            }
            case 3: {
                RelativeLayout.LayoutParams layoutParams3 = layoutParams;
                layoutParams3.addRule(12);
                layoutParams3.addRule(11);
                break;
            }
            case 2: {
                RelativeLayout.LayoutParams layoutParams4 = layoutParams;
                layoutParams4.addRule(10);
                layoutParams4.addRule(9);
                break;
            }
            case 1: {
                RelativeLayout.LayoutParams layoutParams5 = layoutParams;
                layoutParams5.addRule(10);
                layoutParams5.addRule(11);
            }
        }
    }

    public static int dp2px(Context context, int n2) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)((float)n2 * f2 + 0.5f);
    }

    public static int pxToDp(Context context, int n2) {
        float f2 = context.getApplicationContext().getResources().getDisplayMetrics().density;
        return (int)((float)n2 / f2 + 0.5f);
    }

    public static boolean isCover(View view) {
        Rect rect;
        Rect rect2 = rect;
        boolean bl = view.getGlobalVisibleRect(new Rect());
        Rect rect3 = rect2;
        int n2 = rect3.bottom - rect2.top;
        View view2 = view;
        int n3 = view2.getMeasuredHeight();
        n3 = (rect3.right - rect2.left) * n2 >= view2.getMeasuredWidth() * n3 / 2 ? 1 : 0;
        if (!(bl && n3 != 0)) {
            return true;
        }
        View view3 = view;
        while (view3.getParent() instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view3.getParent();
            if (viewGroup.getVisibility() != 0) {
                return true;
            }
            for (n2 = 0; n2 < viewGroup.getChildCount() && viewGroup.getChildAt(n2) != view3; ++n2) {
            }
            for (int i2 = n2 + 1; i2 < viewGroup.getChildCount(); ++i2) {
                Rect rect4;
                Drawable drawable;
                Rect rect5;
                Rect rect6 = rect5;
                view.getGlobalVisibleRect(new Rect());
                View view4 = viewGroup.getChildAt(i2);
                if (view4.getVisibility() != 0 || (drawable = view4.getBackground()) == null || drawable instanceof ColorDrawable && ((ColorDrawable)drawable).getAlpha() == 0) continue;
                View view5 = view4;
                view4 = rect4;
                view5.getGlobalVisibleRect(new Rect());
                if (!Rect.intersects((Rect)rect6, (Rect)view4)) continue;
                Rect rect7 = rect6;
                int n4 = Math.min(rect7.right, view4.right) - Math.max(rect6.left, view4.left);
                View view6 = view;
                int n5 = view6.getMeasuredHeight();
                if ((Math.min(rect7.bottom, view4.bottom) - Math.max(rect6.top, view4.top)) * n4 * 2 < view6.getMeasuredWidth() * n5) continue;
                return true;
            }
            view3 = viewGroup;
        }
        return false;
    }
}

