/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.util;

import android.os.Looper;
import com.tp.adx.sdk.util.InnerLog;
import java.util.IllegalFormatException;

public final class Preconditions {
    public static final String EMPTY_ARGUMENTS = "";

    public static void checkArgument(boolean bl) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.a(bl, true, "Illegal argument.", objectArray2);
    }

    public static void checkArgument(boolean bl, String string) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.a(bl, true, string, objectArray2);
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        Preconditions.a(bl, true, string, objectArray);
    }

    public static void checkState(boolean bl) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.b(bl, true, "Illegal state.", objectArray2);
    }

    public static void checkState(boolean bl, String string) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.b(bl, true, string, objectArray2);
    }

    public static void checkState(boolean bl, String string, Object ... objectArray) {
        Preconditions.b(bl, true, string, objectArray);
    }

    public static void checkNotNull(Object objectArray) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = EMPTY_ARGUMENTS;
        Preconditions.a(objectArray2, true, "Object can not be null.", objectArray);
    }

    public static void checkNotNull(Object objectArray, String string) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = EMPTY_ARGUMENTS;
        Preconditions.a(objectArray2, true, string, objectArray);
    }

    public static void checkNotNull(Object object, String string, Object ... objectArray) {
        Preconditions.a(object, true, string, objectArray);
    }

    public static void checkUiThread() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.a(true, "This method must be called from the UI thread.", objectArray2);
    }

    public static void checkUiThread(String string) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = EMPTY_ARGUMENTS;
        Preconditions.a(true, string, objectArray2);
    }

    public static void checkUiThread(String string, Object ... objectArray) {
        Preconditions.a(true, string, objectArray);
    }

    public static boolean a(boolean bl, boolean bl2, String string, Object ... objectArray) {
        if (bl) {
            return true;
        }
        String string2 = String.valueOf(string);
        try {
            string2 = String.format(string2, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            InnerLog.d("TradPlus preconditions had a format exception: " + illegalFormatException.getMessage());
        }
        if (!bl2) {
            InnerLog.d(string2);
            return false;
        }
        throw new IllegalArgumentException(string2);
    }

    public static boolean b(boolean bl, boolean bl2, String string, Object ... objectArray) {
        if (bl) {
            return true;
        }
        String string2 = String.valueOf(string);
        try {
            string2 = String.format(string2, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            InnerLog.d("TradPlus preconditions had a format exception: " + illegalFormatException.getMessage());
        }
        if (!bl2) {
            InnerLog.d(string2);
            return false;
        }
        throw new IllegalStateException(string2);
    }

    public static boolean a(Object object, boolean bl, String string, Object ... objectArray) {
        if (object != null) {
            return true;
        }
        object = String.valueOf(string);
        try {
            object = String.format((String)object, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            InnerLog.d("TradPlus preconditions had a format exception: " + illegalFormatException.getMessage());
        }
        if (!bl) {
            InnerLog.d((String)object);
            return false;
        }
        throw new NullPointerException((String)object);
    }

    public static boolean a(boolean bl, String string, Object ... objectArray) {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            return true;
        }
        string = String.valueOf(string);
        try {
            string = String.format(string, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            InnerLog.d("TradPlus preconditions had a format exception: " + illegalFormatException.getMessage());
        }
        if (!bl) {
            InnerLog.d(string);
            return false;
        }
        throw new IllegalStateException(string);
    }

    public static final class NoThrow {
        public static volatile boolean a = false;

        public static void setStrictMode(boolean bl) {
            a = bl;
        }

        public static boolean checkArgument(boolean bl) {
            return Preconditions.a(bl, a, "Illegal argument", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkArgument(boolean bl, String string) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.a(bl, a, string, objectArray2);
        }

        public static boolean checkArgument(boolean bl, String string, Object ... objectArray) {
            return Preconditions.a(bl, a, string, objectArray);
        }

        public static boolean checkState(boolean bl) {
            return Preconditions.b(bl, a, "Illegal state.", Preconditions.EMPTY_ARGUMENTS);
        }

        public static boolean checkState(boolean bl, String string) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.b(bl, a, string, objectArray2);
        }

        public static boolean checkState(boolean bl, String string, Object ... objectArray) {
            return Preconditions.b(bl, a, string, objectArray);
        }

        public static boolean checkNotNull(Object object) {
            return Preconditions.a(object, a, "Object can not be null.", Preconditions.EMPTY_ARGUMENTS);
        }

        public static boolean checkNotNull(Object objectArray, String string) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.a(objectArray2, a, string, objectArray);
        }

        public static boolean checkNotNull(Object object, String string, Object ... objectArray) {
            return Preconditions.a(object, a, string, objectArray);
        }

        public static boolean checkUiThread() {
            return Preconditions.a(a, "This method must be called from the UI thread.", Preconditions.EMPTY_ARGUMENTS);
        }

        public static boolean checkUiThread(String objectArray) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = Preconditions.EMPTY_ARGUMENTS;
            return Preconditions.a(a, (String)objectArray2, objectArray);
        }

        public static boolean checkUiThread(String string, Object ... objectArray) {
            return Preconditions.a(false, string, objectArray);
        }
    }
}

