/*
 * Decompiled with CFR 0.152.
 */
package com.touchlane.exovideo;

import junit.framework.Assert;

final class Size {
    private final int mWidth;
    private final int mHeight;

    Size(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Size) {
            Size other = (Size)obj;
            return this.mWidth == other.mWidth && this.mHeight == other.mHeight;
        }
        return false;
    }

    public String toString() {
        return this.mWidth + "x" + this.mHeight;
    }

    private static NumberFormatException invalidSize(String s) {
        throw new NumberFormatException("Invalid Size: \"" + s + "\"");
    }

    public static Size parseSize(String string) throws NumberFormatException {
        Assert.assertNotNull((String)"string must not be null", (Object)string);
        int sep_ix = string.indexOf(42);
        if (sep_ix < 0) {
            sep_ix = string.indexOf(120);
        }
        if (sep_ix < 0) {
            throw Size.invalidSize(string);
        }
        try {
            return new Size(Integer.parseInt(string.substring(0, sep_ix)), Integer.parseInt(string.substring(sep_ix + 1)));
        }
        catch (NumberFormatException e) {
            throw Size.invalidSize(string);
        }
    }

    public int hashCode() {
        return this.mHeight ^ (this.mWidth << 16 | this.mWidth >>> 16);
    }
}

