/*
 * Decompiled with CFR 0.152.
 */
package com.touchlane.exovideo;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.TextureView;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.touchlane.exovideo.ExoVideoController;
import com.touchlane.exovideo.R;
import com.touchlane.exovideo.Size;

public class ExoVideoView
extends FrameLayout {
    private TextureView mTextureView;
    private ImageView mThumbnail;
    private SurfaceTexture mSurfaceTexture;
    private Size mViewSize;
    private Size mVideoSize;
    private Uri mVideoUri;
    private ExoVideoController mExoVideoController;
    private ExoVideoController.PlayerConnection mPlayerConnection;
    private VideoEndListener mVideoEndListener;
    private ThumbnailProvider mThumbnailProvider;
    private boolean mHideThumbnailOnNewFrame = false;
    private TextureView.SurfaceTextureListener mSurfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            ExoVideoView.this.mViewSize = new Size(width, height);
            ExoVideoView.this.mSurfaceTexture = surface;
            ExoVideoView.this.trySetAspectRatio();
            ExoVideoView.this.trySetSurfaceTexture();
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            ExoVideoView.this.mViewSize = new Size(width, height);
            ExoVideoView.this.trySetAspectRatio();
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            ExoVideoView.this.mSurfaceTexture = null;
            if (ExoVideoView.this.mPlayerConnection != null) {
                ExoVideoView.this.mPlayerConnection.setSurfaceTexture(null);
            }
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            if (ExoVideoView.this.mHideThumbnailOnNewFrame && ExoVideoView.this.mVideoSize != null) {
                ExoVideoView.this.mHideThumbnailOnNewFrame = false;
                ExoVideoView.this.showThumbnail(false);
            }
        }
    };
    private ExoVideoController.Listener mExoVideoContollerListener = new ExoVideoController.Listener(){

        @Override
        public void onVideoEnded() {
            if (ExoVideoView.this.mPlayerConnection != null) {
                ExoVideoView.this.mPlayerConnection.close();
            }
            if (ExoVideoView.this.mVideoEndListener != null) {
                ExoVideoView.this.mVideoEndListener.onVideoEnded();
            }
        }

        @Override
        public void onVideoSizeChanged(int width, int height) {
            ExoVideoView.this.mVideoSize = new Size(width, height);
            ExoVideoView.this.trySetAspectRatio();
        }

        @Override
        public void onPlayerConnectionClosed() {
            ExoVideoView.this.showThumbnail(true);
            ExoVideoView.this.mPlayerConnection = null;
            if (ExoVideoView.this.mVideoEndListener != null) {
                ExoVideoView.this.mVideoEndListener.onPlayerDisconnected();
            }
        }
    };

    public ExoVideoView(@NonNull Context context) {
        this(context, null);
    }

    public ExoVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExoVideoView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initLayout();
    }

    private void initLayout() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.view_exo_video, (ViewGroup)this, true);
        this.mTextureView = (TextureView)this.findViewById(R.id.texture);
        this.mTextureView.setSurfaceTextureListener(this.mSurfaceTextureListener);
        this.mThumbnail = (ImageView)this.findViewById(R.id.thumbnail);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPlayerConnection != null) {
            this.mPlayerConnection.close();
        }
    }

    private void trySetAspectRatio() {
        if (this.mVideoSize != null && this.mViewSize != null) {
            Matrix matrix = ExoVideoView.createAspectRatioCorrectionMatrix(this.mViewSize, this.mVideoSize);
            this.mTextureView.setTransform(matrix);
        }
    }

    private static Matrix createAspectRatioCorrectionMatrix(Size viewSize, Size contentSize) {
        float scaleY;
        float scaleX;
        float viewRatio;
        Matrix matrix = new Matrix();
        float previewRatio = (float)contentSize.getWidth() / (float)contentSize.getHeight();
        float scaleFactor = previewRatio / (viewRatio = (float)viewSize.getWidth() / (float)viewSize.getHeight());
        if (scaleFactor > 1.0f) {
            scaleX = scaleFactor;
            scaleY = 1.0f;
        } else {
            scaleX = 1.0f;
            scaleY = 1.0f / scaleFactor;
        }
        matrix.setScale(scaleX, scaleY, (float)viewSize.getWidth() / 2.0f, (float)viewSize.getHeight() / 2.0f);
        return matrix;
    }

    private void showThumbnail(boolean show) {
        this.mThumbnail.setVisibility(show ? 0 : 4);
    }

    public void setSource(Uri uri) {
        this.mVideoUri = uri;
        this.showThumbnail(true);
        if (this.mThumbnailProvider != null) {
            this.mThumbnailProvider.provideThumbnail(this.mThumbnail, this.mVideoUri);
        }
    }

    public void setExoVideoController(ExoVideoController exoVideoController) {
        this.mExoVideoController = exoVideoController;
    }

    public void play() {
        if (this.mPlayerConnection == null || !this.mPlayerConnection.getUri().equals((Object)this.mVideoUri)) {
            this.mPlayerConnection = this.mExoVideoController.connectToPlayer(this.mVideoUri, this.mExoVideoContollerListener);
            this.mVideoSize = null;
            this.trySetSurfaceTexture();
        }
        this.mPlayerConnection.play();
        this.mHideThumbnailOnNewFrame = true;
    }

    private void trySetSurfaceTexture() {
        if (this.mPlayerConnection != null && this.mSurfaceTexture != null) {
            this.mPlayerConnection.setSurfaceTexture(this.mSurfaceTexture);
        }
    }

    public boolean isPlaying() {
        return this.mPlayerConnection != null && this.mPlayerConnection.isPlaying();
    }

    public void pause() {
        if (this.mPlayerConnection != null) {
            this.mPlayerConnection.pause();
        }
    }

    public long getCurrentPosition() {
        if (this.mPlayerConnection != null) {
            return this.mPlayerConnection.getCurrentPosition();
        }
        return 0L;
    }

    public void seekTo(long position) {
        if (this.mPlayerConnection != null) {
            this.mPlayerConnection.seekTo(position);
        }
    }

    public void stop() {
        if (this.mPlayerConnection != null) {
            this.mPlayerConnection.close();
        }
    }

    public void setVideoEndListener(VideoEndListener listener) {
        this.mVideoEndListener = listener;
    }

    public void setThumbnailProvider(ThumbnailProvider thumbnailProvider) {
        this.mThumbnailProvider = thumbnailProvider;
    }

    public static interface ThumbnailProvider {
        public void provideThumbnail(ImageView var1, Uri var2);
    }

    public static interface VideoEndListener {
        public void onVideoEnded();

        public void onPlayerDisconnected();
    }
}

