/*
 * Decompiled with CFR 0.152.
 */
package com.touchlane.exovideo;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.view.Surface;
import android.view.Window;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;
import com.touchlane.exovideo.SimpleEventListener;

public final class ExoVideoController {
    private final Context mContext;
    private final Window mWindow;
    private SimpleExoPlayer mPlayer;
    private int mPlaybackState;
    private PlayerConnection mPlayerConnection;
    private final SimpleExoPlayer.VideoListener mVideoListener = new SimpleExoPlayer.VideoListener(){

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            if (ExoVideoController.this.mPlayerConnection != null) {
                ExoVideoController.this.mPlayerConnection.mListener.onVideoSizeChanged(width, height);
            }
        }

        public void onRenderedFirstFrame() {
        }
    };
    private final Player.EventListener mEventListener = new SimpleEventListener(){

        @Override
        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            boolean playbackStateChanged = ExoVideoController.this.mPlaybackState != playbackState;
            ExoVideoController.this.mPlaybackState = playbackState;
            if (playbackStateChanged && playbackState == 4 && ExoVideoController.this.mPlayerConnection != null) {
                ExoVideoController.this.mPlayerConnection.mListener.onVideoEnded();
            }
        }
    };

    public ExoVideoController(Context context) {
        this.mContext = context;
        this.mWindow = ((Activity)context).getWindow();
    }

    public void init() {
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)bandwidthMeter);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        this.mPlayer = ExoPlayerFactory.newSimpleInstance((Context)this.mContext, (TrackSelector)trackSelector);
        this.mPlayer.addVideoListener(this.mVideoListener);
        this.mPlayer.addListener(this.mEventListener);
    }

    PlayerConnection connectToPlayer(Uri uri, Listener listener) {
        this.closePlayerConnection();
        this.mPlaybackState = this.mPlayer.getPlaybackState();
        this.mPlayerConnection = new PlayerConnection(uri, listener);
        return this.mPlayerConnection;
    }

    private MediaSource createMediaSource(Uri uri) {
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(this.mContext, Util.getUserAgent((Context)this.mContext, (String)"com.touchlane.exovideo"));
        return new ExtractorMediaSource(uri, (DataSource.Factory)dataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory(), null, null);
    }

    private void closePlayerConnection() {
        if (this.mPlayerConnection != null) {
            this.mPlayerConnection.close();
        }
    }

    public void release() {
        this.closePlayerConnection();
        this.mPlayer.release();
        this.mPlayer = null;
    }

    private void keepScreenOn() {
        this.mWindow.addFlags(128);
    }

    private void dontKeepScreenOn() {
        this.mWindow.clearFlags(128);
    }

    class PlayerConnection {
        private boolean mClosed = false;
        private final Uri mUri;
        private final Listener mListener;
        private Surface mSurface;

        PlayerConnection(Uri uri, Listener listener) {
            this.mUri = uri;
            this.mListener = listener;
            ExoVideoController.this.mPlayer.prepare(ExoVideoController.this.createMediaSource(this.mUri));
        }

        Uri getUri() {
            return this.mUri;
        }

        private void assertNotClosed() {
            if (this.mClosed) {
                throw new IllegalStateException("this connection was closed");
            }
        }

        void setSurfaceTexture(SurfaceTexture surfaceTexture) {
            this.assertNotClosed();
            this.releaseSurface();
            if (surfaceTexture != null) {
                this.mSurface = new Surface(surfaceTexture);
                ExoVideoController.this.mPlayer.setVideoSurface(this.mSurface);
            }
        }

        private void releaseSurface() {
            if (this.mSurface != null) {
                ExoVideoController.this.mPlayer.setVideoSurface(null);
                this.mSurface.release();
                this.mSurface = null;
            }
        }

        void play() {
            this.assertNotClosed();
            ExoVideoController.this.mPlayer.setPlayWhenReady(true);
            ExoVideoController.this.keepScreenOn();
        }

        boolean isPlaying() {
            this.assertNotClosed();
            return ExoVideoController.this.mPlayer.getPlayWhenReady();
        }

        void pause() {
            this.assertNotClosed();
            ExoVideoController.this.mPlayer.setPlayWhenReady(false);
            ExoVideoController.this.dontKeepScreenOn();
        }

        void seekTo(long position) {
            this.assertNotClosed();
            ExoVideoController.this.mPlayer.seekTo(position);
        }

        long getCurrentPosition() {
            return ExoVideoController.this.mPlayer.getCurrentPosition();
        }

        void close() {
            this.assertNotClosed();
            this.mClosed = true;
            this.releaseSurface();
            ExoVideoController.this.mPlayer.stop();
            ExoVideoController.this.mPlayerConnection = null;
            ExoVideoController.this.dontKeepScreenOn();
            this.mListener.onPlayerConnectionClosed();
        }
    }

    static interface Listener {
        public void onVideoEnded();

        public void onVideoSizeChanged(int var1, int var2);

        public void onPlayerConnectionClosed();
    }
}

