/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.RawImagesFlowManager;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfInt;
import org.opencv.core.Rect;
import org.opencv.imgcodecs.Imgcodecs;

public class FileUtils {
    private static final String tag = Logger.makeLogTag("FileUtils");
    public static String tempPath = ".mobiflow";
    public static final String tempDebugPath = ".debugmobiflow";
    private static final String tempVideoPath = ".debugmobiflow" + File.separator + "video";
    private static final String tempVideoValidPath = String.valueOf(tempVideoPath) + File.separator + "valid";
    private static final String tempVideoInValidPath = String.valueOf(tempVideoPath) + File.separator + "invalid";
    private static boolean externalStorageAvailable;
    private static boolean externalStorageWriteable;
    public static String internalStorageLocation;
    public static String logFilePath;

    public static void makeAppDirExists(final Context context) {
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                File tempFileDir = FileUtils.getFolder(context, FileUtils.tempDebugPath);
                if (!tempFileDir.exists()) {
                    tempFileDir.mkdirs();
                    Logger.i("FileUtils", ".debugmobiflow created");
                }
                File fileDir = FileUtils.getFolder(context, tempPath);
                FileUtils.createFolder(context, tempPath);
                if (!fileDir.exists()) {
                    fileDir.mkdirs();
                    Logger.i("FileUtils", String.valueOf(tempPath) + " created");
                }
                FileUtils.createFolder(context, FileUtils.tempDebugPath);
                FileUtils.createFolder(context, tempPath);
            }
        };
        thread1.start();
    }

    public static String getHighResImagePath(Context context) {
        File fileDir = FileUtils.getFolder(context, tempPath);
        return fileDir.getAbsolutePath();
    }

    public static String getTestImagePath(Context context) {
        File fileDir = Environment.getExternalStorageDirectory();
        return String.valueOf(fileDir.getAbsolutePath()) + "/" + tempPath;
    }

    public static String getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd_HH.mm.ss", Locale.US);
        String currentDateAndTime = dateFormat.format(new Date());
        return currentDateAndTime;
    }

    public static void clearSessionImages(Context context) {
        FileUtils.clearFiles(context, String.valueOf(internalStorageLocation) + "/.mobiflow");
        FileUtils.clearFiles(context, String.valueOf(internalStorageLocation) + "/.debugmobiflow");
    }

    public static void clearLogFile(String folder) {
        try {
            File file = new File(folder);
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isMinimumCPUSpeed() {
        int maxFreq;
        block17: {
            maxFreq = -1;
            RandomAccessFile reader = null;
            try {
                try {
                    reader = new RandomAccessFile("/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state", "r");
                    boolean done = false;
                    while (!done) {
                        int freq;
                        String line = reader.readLine();
                        if (line == null) {
                            done = true;
                            break;
                        }
                        String[] splits = line.split("\\s+");
                        assert (splits.length == 2);
                        int timeInState = Integer.parseInt(splits[1]);
                        if (timeInState <= 0 || (freq = Integer.parseInt(splits[0]) / 1000) <= maxFreq) continue;
                        maxFreq = freq;
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Logger.i(tag, "device CPU speed is " + maxFreq);
        return maxFreq >= 1000 || FileUtils.getNumCores() > 1;
    }

    public static int getNumCores() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]+", pathname.getName());
                }
            }
            File[] files = dir.listFiles(new CpuFilter());
            Logger.i(tag, "device cores number is " + files.length);
            return files.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return FileUtils.capitalize(model);
        }
        return String.valueOf(FileUtils.capitalize(manufacturer)) + " " + model;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return String.valueOf(Character.toUpperCase(first)) + s.substring(1);
    }

    public static void clearMemory() {
        SessionResultParams.tiffFront = null;
        SessionResultParams.jpegBWFront = null;
        SessionResultParams.grayscaleFront = null;
        SessionResultParams.colorFront = null;
        SessionResultParams.originalFront = null;
        SessionResultParams.tiffBack = null;
        SessionResultParams.jpegBWBack = null;
        SessionResultParams.grayscaleBack = null;
        SessionResultParams.colorBack = null;
        SessionResultParams.originalBack = null;
    }

    public static boolean writeToFile(byte[] array2, String path) {
        FileOutputStream stream = null;
        boolean success = true;
        try {
            try {
                if (array2 == null || path == null) {
                    Logger.i(tag, "failed to create image byte array from, image may be corrupted " + path);
                    success = false;
                }
                if (!FileUtils.whiteListFiles(path)) {
                    Logger.i(tag, "Invalid file name" + path);
                    success = false;
                }
                if ((stream = new FileOutputStream(path)) != null && array2.length > 0) {
                    stream.write(array2);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return success;
    }

    private static boolean whiteListFiles(String path) {
        String[] validationPath;
        block3: {
            try {
                validationPath = path.split("_");
                if (validationPath[0].contains("FRONT") || validationPath[0].contains("BACK")) break block3;
                return false;
            }
            catch (Exception e) {
                Logger.e(tag, Log.getStackTraceString((Throwable)e));
                return false;
            }
        }
        return validationPath[1].matches("([0-9]{2})-([0-9]{2})-([0-9]{2})") && validationPath[2].matches("([0-9]{2}).([0-9]{2}).([0-9]{2})");
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getDeviceBrand() {
        String manufacturer = Build.MANUFACTURER;
        return FileUtils.capitalize(manufacturer);
    }

    public static boolean isSamsungS5() {
        try {
            return CameraManagerController.deviceBrand.toLowerCase(Locale.US).contains("samsung") && CameraManagerController.deviceModal.toLowerCase(Locale.US).contains("g900");
        }
        catch (Exception e) {
            Logger.e(tag, Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    public static boolean isSonyDevice() {
        return CameraManagerController.deviceBrand.toLowerCase(Locale.US).contains("sony");
    }

    public static boolean isSamsungS4() {
        return CameraManagerController.deviceBrand.toLowerCase(Locale.US).contains("samsung") && (CameraManagerController.deviceModal.toLowerCase(Locale.US).equals("gt-i9500") || CameraManagerController.deviceModal.toLowerCase(Locale.US).equals("shv-e300k") || CameraManagerController.deviceModal.toLowerCase(Locale.US).equals("gt-i9505") || CameraManagerController.deviceModal.toLowerCase(Locale.US).equals("gt-i9506") || CameraManagerController.deviceModal.toLowerCase(Locale.US).equals("sch-i545"));
    }

    public static void clearFiles(Context context, final String path) {
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                try {
                    File cacheDir = new File(path);
                    if (cacheDir.exists()) {
                        List<File> filesList = Arrays.asList(cacheDir.listFiles());
                        if (filesList == null) {
                            return;
                        }
                        int filesNumber = filesList.size();
                        int i = 0;
                        while (i < filesNumber) {
                            File curr = filesList.get(i);
                            Logger.i(tag, "deleting file " + curr.getAbsolutePath());
                            curr.delete();
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thread1.start();
    }

    public static String readRawResource(Context context, int resourceId, String fileName) {
        return FileUtils.readRawResource(context, resourceId, "micr", fileName);
    }

    public static String readRawResource(Context context, int resourceId, String folderName, String fileName) {
        String result;
        block9: {
            result = "";
            InputStream is = null;
            FileOutputStream os = null;
            if (fileName == null || folderName == null || resourceId == -1) {
                return null;
            }
            try {
                try {
                    is = context.getResources().openRawResource(resourceId);
                    File localAssetDir = context.getDir(folderName, 0);
                    File localFile = new File(localAssetDir, fileName);
                    if (localFile != null) {
                        os = new FileOutputStream(localFile);
                    }
                    int size = is.available();
                    byte[] buffer = new byte[size];
                    if (is != null && buffer != null && buffer.length > 0) {
                        int bytesRead;
                        while ((bytesRead = is.read(buffer)) != -1) {
                            if (bytesRead <= 0) continue;
                            os.write(buffer, 0, bytesRead);
                        }
                    }
                    result = localFile.getAbsolutePath();
                }
                catch (Exception e) {
                    Logger.e(tag, "Error readRawResource: " + e.getMessage());
                    FileUtils.closeInputStream(is);
                    FileUtils.closeOutputStream(os);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeInputStream(is);
                FileUtils.closeOutputStream(os);
                throw throwable;
            }
            FileUtils.closeInputStream(is);
            FileUtils.closeOutputStream(os);
        }
        return result;
    }

    public static String readFromAsset(Context ctx, String fileToRead, String fileToSave) {
        ByteArrayOutputStream outputStream;
        block22: {
            AssetManager assetManager = ctx.getAssets();
            outputStream = null;
            FileOutputStream os = null;
            if (fileToRead == null || fileToSave == null) {
                return null;
            }
            InputStream inputStream = null;
            try {
                try {
                    inputStream = assetManager.open(fileToRead);
                    outputStream = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    try {
                        int len;
                        while ((len = inputStream.read(buf)) != -1) {
                            if (os == null || len <= 0) continue;
                            os.write(buf, 0, len);
                        }
                    }
                    catch (IOException iOException) {}
                }
                catch (IOException iOException) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        break block22;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (outputStream != null) {
            return outputStream.toString();
        }
        return null;
    }

    public static void readRaw(Context ctx, int res_id, String fileName) {
        InputStream is = ctx.getResources().openRawResource(res_id);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr, 8192);
        try {
            String test;
            while ((test = br.readLine()) != null) {
            }
            isr.close();
            is.close();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readOCRMaskRawResources(Context context, String folderName) throws Throwable {
        String result = "";
        result = FileUtils.readRawResource(context, R.raw.ocr_mask0, folderName, "0.png");
        result = result.substring(0, result.indexOf("0.png"));
        FileUtils.readRawResource(context, R.raw.ocr_mask1, folderName, "1.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask2, folderName, "2.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask3, folderName, "3.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask4, folderName, "4.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask5, folderName, "5.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask6, folderName, "6.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask7, folderName, "7.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask8, folderName, "8.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask9, folderName, "9.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask11, folderName, "11.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask12, folderName, "12.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask13, folderName, "13.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask14, folderName, "14.png");
        FileUtils.readRawResource(context, R.raw.ocr_mask15, folderName, "15.png");
        return result;
    }

    public static String readOCRMRZRawResources(Context context, String folderName) throws Throwable {
        String result = "";
        result = FileUtils.readRawResource(context, R.raw.mrz0, folderName, "0.xml");
        result = result.substring(0, result.indexOf("0.xml"));
        FileUtils.readRawResource(context, R.raw.mrz0, folderName, "0.xml");
        FileUtils.readRawResource(context, R.raw.mrz1, folderName, "1.xml");
        FileUtils.readRawResource(context, R.raw.mrz2, folderName, "2.xml");
        FileUtils.readRawResource(context, R.raw.mrz3, folderName, "3.xml");
        FileUtils.readRawResource(context, R.raw.mrz4, folderName, "4.xml");
        FileUtils.readRawResource(context, R.raw.mrz5, folderName, "5.xml");
        FileUtils.readRawResource(context, R.raw.mrz6, folderName, "6.xml");
        FileUtils.readRawResource(context, R.raw.mrz7, folderName, "7.xml");
        FileUtils.readRawResource(context, R.raw.mrz8, folderName, "8.xml");
        FileUtils.readRawResource(context, R.raw.mrz9, folderName, "9.xml");
        FileUtils.readRawResource(context, R.raw.mrz10, folderName, "10.xml");
        FileUtils.readRawResource(context, R.raw.mrz11, folderName, "11.xml");
        FileUtils.readRawResource(context, R.raw.mrz12, folderName, "12.xml");
        FileUtils.readRawResource(context, R.raw.mrz13, folderName, "13.xml");
        FileUtils.readRawResource(context, R.raw.mrz14, folderName, "14.xml");
        FileUtils.readRawResource(context, R.raw.mrz15, folderName, "15.xml");
        FileUtils.readRawResource(context, R.raw.mrz16, folderName, "16.xml");
        FileUtils.readRawResource(context, R.raw.mrz17, folderName, "17.xml");
        FileUtils.readRawResource(context, R.raw.mrz18, folderName, "18.xml");
        FileUtils.readRawResource(context, R.raw.mrz19, folderName, "19.xml");
        FileUtils.readRawResource(context, R.raw.mrz20, folderName, "20.xml");
        FileUtils.readRawResource(context, R.raw.mrz21, folderName, "21.xml");
        FileUtils.readRawResource(context, R.raw.mrz22, folderName, "22.xml");
        FileUtils.readRawResource(context, R.raw.mrz23, folderName, "23.xml");
        FileUtils.readRawResource(context, R.raw.mrz24, folderName, "24.xml");
        FileUtils.readRawResource(context, R.raw.mrz25, folderName, "25.xml");
        FileUtils.readRawResource(context, R.raw.mrz26, folderName, "26.xml");
        FileUtils.readRawResource(context, R.raw.mrz27, folderName, "27.xml");
        FileUtils.readRawResource(context, R.raw.mrz28, folderName, "28.xml");
        FileUtils.readRawResource(context, R.raw.mrz29, folderName, "29.xml");
        FileUtils.readRawResource(context, R.raw.mrz30, folderName, "30.xml");
        FileUtils.readRawResource(context, R.raw.mrz31, folderName, "31.xml");
        FileUtils.readRawResource(context, R.raw.mrz32, folderName, "32.xml");
        FileUtils.readRawResource(context, R.raw.mrz33, folderName, "33.xml");
        FileUtils.readRawResource(context, R.raw.mrz34, folderName, "34.xml");
        FileUtils.readRawResource(context, R.raw.mrz35, folderName, "35.xml");
        FileUtils.readRawResource(context, R.raw.mrz36, folderName, "36.xml");
        return result;
    }

    public static String readOCRPanRawResources(Context context, String folderName) throws Throwable {
        String result = "";
        result = FileUtils.readRawResource(context, R.raw.pan0, folderName, "0.xml");
        result = result.substring(0, result.indexOf("0.xml"));
        FileUtils.readRawResource(context, R.raw.pan0, folderName, "0.xml");
        FileUtils.readRawResource(context, R.raw.pan1, folderName, "1.xml");
        FileUtils.readRawResource(context, R.raw.pan2, folderName, "2.xml");
        FileUtils.readRawResource(context, R.raw.pan3, folderName, "3.xml");
        FileUtils.readRawResource(context, R.raw.pan4, folderName, "4.xml");
        FileUtils.readRawResource(context, R.raw.pan5, folderName, "5.xml");
        FileUtils.readRawResource(context, R.raw.pan6, folderName, "6.xml");
        FileUtils.readRawResource(context, R.raw.pan7, folderName, "7.xml");
        FileUtils.readRawResource(context, R.raw.pan8, folderName, "8.xml");
        FileUtils.readRawResource(context, R.raw.pan9, folderName, "9.xml");
        FileUtils.readRawResource(context, R.raw.pan10, folderName, "10.xml");
        FileUtils.readRawResource(context, R.raw.pan11, folderName, "11.xml");
        FileUtils.readRawResource(context, R.raw.pan12, folderName, "12.xml");
        FileUtils.readRawResource(context, R.raw.pan13, folderName, "13.xml");
        FileUtils.readRawResource(context, R.raw.pan14, folderName, "14.xml");
        FileUtils.readRawResource(context, R.raw.pan15, folderName, "15.xml");
        FileUtils.readRawResource(context, R.raw.pan16, folderName, "16.xml");
        FileUtils.readRawResource(context, R.raw.pan17, folderName, "17.xml");
        FileUtils.readRawResource(context, R.raw.pan18, folderName, "18.xml");
        FileUtils.readRawResource(context, R.raw.pan19, folderName, "19.xml");
        FileUtils.readRawResource(context, R.raw.pan20, folderName, "20.xml");
        FileUtils.readRawResource(context, R.raw.pan21, folderName, "21.xml");
        FileUtils.readRawResource(context, R.raw.pan22, folderName, "22.xml");
        FileUtils.readRawResource(context, R.raw.pan23, folderName, "23.xml");
        FileUtils.readRawResource(context, R.raw.pan24, folderName, "24.xml");
        FileUtils.readRawResource(context, R.raw.pan25, folderName, "25.xml");
        FileUtils.readRawResource(context, R.raw.pan26, folderName, "26.xml");
        FileUtils.readRawResource(context, R.raw.pan27, folderName, "27.xml");
        FileUtils.readRawResource(context, R.raw.pan28, folderName, "28.xml");
        FileUtils.readRawResource(context, R.raw.pan29, folderName, "29.xml");
        FileUtils.readRawResource(context, R.raw.pan30, folderName, "30.xml");
        FileUtils.readRawResource(context, R.raw.pan31, folderName, "31.xml");
        FileUtils.readRawResource(context, R.raw.pan32, folderName, "32.xml");
        FileUtils.readRawResource(context, R.raw.pan33, folderName, "33.xml");
        FileUtils.readRawResource(context, R.raw.pan34, folderName, "34.xml");
        FileUtils.readRawResource(context, R.raw.pan35, folderName, "35.xml");
        FileUtils.readRawResource(context, R.raw.pan36, folderName, "36.xml");
        return result;
    }

    public static String storeBitmapInTempFolder(Context context, Bitmap bitmap) {
        String filePath = FileUtils.getTempImageFileName(context);
        return FileUtils.storeBitmap(bitmap, filePath);
    }

    public static String storeBitmapInDebugFolder(Context context, Bitmap bitmap, Rect rect, String fileName) {
        String filePath = FileUtils.getDebugFilePath(context, fileName);
        String result = "";
        if (bitmap != null && rect != null) {
            result = FileUtils.storeBitmap(bitmap, filePath);
            bitmap = FileUtils.drawRectOnBitmap(bitmap, rect);
            int lastIndexOfDot = filePath.lastIndexOf(".");
            StringBuilder builder = new StringBuilder();
            builder.append(filePath.substring(0, lastIndexOfDot)).append("_border.").append(filePath.substring(lastIndexOfDot + 1, filePath.length()));
            filePath = builder.toString();
            FileUtils.storeBitmap(bitmap, filePath);
        } else if (bitmap != null) {
            result = FileUtils.storeBitmap(bitmap, filePath);
        }
        return result;
    }

    private static Bitmap drawRectOnBitmap(Bitmap srcBitmap, Rect rect) {
        RectF targetRect = new RectF((float)rect.x, (float)rect.y, (float)(rect.x + rect.width), (float)(rect.y + rect.height));
        Canvas canvas = new Canvas(srcBitmap);
        Paint paint = new Paint();
        paint.setColor(-65536);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(3.0f);
        canvas.drawRect(targetRect, paint);
        return srcBitmap;
    }

    private static String getDebugFilePath(Context context, String fileName) {
        File folder = FileUtils.getFolder(context, tempDebugPath);
        if (!fileName.endsWith(".jpeg") && !fileName.endsWith(".jpg")) {
            fileName = String.valueOf(fileName) + ".jpg";
        }
        String filePath = folder + File.separator + fileName;
        return filePath;
    }

    public static String storeVideoFrame(Context context, Bitmap bitmap, String fileName, boolean isValid) {
        if (!fileName.endsWith(".jpeg") && !fileName.endsWith(".jpg")) {
            fileName = String.valueOf(fileName) + ".jpg";
        }
        String filePath = (isValid ? FileUtils.getRootDirForTempValidVideo(context) : FileUtils.getRootDirForTempInValidVideo(context)) + File.separator + fileName;
        return FileUtils.storeBitmap(bitmap, filePath);
    }

    public static String storeBitmapInTempFolder(Context context, Bitmap bitmap, String name) {
        if (!name.endsWith(".jpeg") && !name.endsWith(".jpg")) {
            name = String.valueOf(name) + ".jpg";
        }
        String filePath = String.valueOf(FileUtils.getTempFilePath(context)) + name;
        return FileUtils.storeBitmap(bitmap, filePath);
    }

    public static Bitmap getBitmap(Context context, String filePath) {
        if (!FileUtils.whiteListFiles(filePath)) {
            Logger.e(tag, "Invalid file name" + filePath);
            return null;
        }
        Bitmap bitmap = FileUtils.decodeFile(new File(filePath), -1, -1);
        return bitmap;
    }

    public static Bitmap decodeFile(File f, int maxWidthResolution, int maxHeightResolution) {
        FileInputStream fileInputStream = null;
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            fileInputStream = new FileInputStream(f);
            BitmapFactory.decodeStream((InputStream)fileInputStream, null, (BitmapFactory.Options)o);
            fileInputStream = null;
            int width_tmp = o.outWidth;
            int height_tmp = o.outHeight;
            int scale = 1;
            if (maxWidthResolution > -1 && maxHeightResolution > -1) {
                while (width_tmp / 2 >= maxWidthResolution && height_tmp / 2 >= maxHeightResolution) {
                    width_tmp /= 2;
                    height_tmp /= 2;
                    scale *= 2;
                }
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            o2.inPreferredConfig = Bitmap.Config.RGB_565;
            fileInputStream = new FileInputStream(f);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream, null, (BitmapFactory.Options)o2);
            FileUtils.close(fileInputStream);
            return bitmap;
        }
        catch (Exception e) {
            Logger.e(tag, "FileUtils.decodeFile", e);
        }
        finally {
            FileUtils.close(fileInputStream);
        }
        return null;
    }

    private static void close(InputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getTempImageFileName(Context context) {
        return String.valueOf(FileUtils.getTempFilePath(context)) + "temp.jpg";
    }

    public static File getRootDirForTempImage(Context context) {
        return FileUtils.getFolder(context, tempPath);
    }

    public static File getRootDirForTempValidVideo(Context context) {
        return FileUtils.getFolder(context, tempVideoValidPath);
    }

    public static File getRootDirForTempInValidVideo(Context context) {
        return FileUtils.getFolder(context, tempVideoInValidPath);
    }

    public static File getFolder(Context context, String path) {
        File cacheDir = new File(context.getFilesDir(), path);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir;
    }

    public static void createFolder(Context context, String path) {
        File internalDir = context.getDir(path, 0);
        if (!internalDir.exists()) {
            internalDir.mkdirs();
        }
    }

    public static byte[] getByteArrayImage(Context context, String filePath) {
        byte[] data;
        block9: {
            if (filePath == null) {
                return null;
            }
            if (!FileUtils.whiteListFiles(filePath)) {
                Logger.i(tag, "Invalid file name" + filePath);
                return null;
            }
            data = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(filePath);
                data = new byte[fis.available()];
                while (fis.read(data) > -1) {
                }
                fis.close();
            }
            catch (FileNotFoundException e) {
                Logger.i(tag, "File not found: " + e.getMessage());
                FileUtils.closeInputStream(fis);
                break block9;
            }
            catch (IOException e) {
                try {
                    Logger.i(tag, "Error accessing file: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    FileUtils.closeInputStream(fis);
                    throw throwable;
                }
                FileUtils.closeInputStream(fis);
                break block9;
            }
            FileUtils.closeInputStream(fis);
        }
        return data;
    }

    public static String getTempFilePath(Context context) {
        return FileUtils.getRootDirForTempImage(context) + File.separator;
    }

    public static String getTempImagePath(Context context, String imageName) {
        return String.valueOf(FileUtils.getTempFilePath(context)) + imageName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String storeBitmap(Bitmap bitmap, String filePath) {
        String string2;
        FileOutputStream out = null;
        try {
            File file = new File(filePath);
            out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out);
            string2 = file.getAbsolutePath();
        }
        catch (Exception e) {
            try {
                Logger.e(tag, "Error storing a bitmap: " + e.getMessage());
            }
            catch (Throwable throwable) {
                FileUtils.closeOutputStream(out);
                throw throwable;
            }
            FileUtils.closeOutputStream(out);
            return null;
        }
        FileUtils.closeOutputStream(out);
        return string2;
    }

    public static String storeByteArrayImageInTempFolder(Context context, byte[] data, String fileName, boolean isDebug) {
        if (fileName == null) {
            return null;
        }
        FileOutputStream fos = null;
        String filePath = String.valueOf(FileUtils.getTempFilePath(context)) + fileName + ".jpg";
        File fileDir = FileUtils.getFolder(context, tempDebugPath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        try {
            try {
                fos = new FileOutputStream(filePath);
                if (fos != null && data.length > 0) {
                    fos.write(data);
                }
                if (isDebug && fos != null && data.length > 0) {
                    fos.write(data);
                }
            }
            catch (FileNotFoundException e) {
                Logger.i(tag, "File not found: " + e.getMessage());
                try {
                    fos.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                Logger.i(tag, "Error accessing file: " + e.getMessage());
                try {
                    fos.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return filePath;
    }

    public static Mat rotateMat(Mat image, int angle) {
        Core.transpose((Mat)image, (Mat)image);
        Core.flip((Mat)image, (Mat)image, (int)1);
        return image;
    }

    public static Mat rotateMatInAngle(Mat src, int angle) {
        if (angle == 270 || angle == -90) {
            Core.transpose((Mat)src, (Mat)src);
            Core.flip((Mat)src, (Mat)src, (int)0);
        } else if (angle == 180 || angle == -180) {
            Core.flip((Mat)src, (Mat)src, (int)-1);
        } else if (angle == 90 || angle == -270) {
            Core.transpose((Mat)src, (Mat)src);
            Core.flip((Mat)src, (Mat)src, (int)1);
        } else if (angle != 360) {
            // empty if block
        }
        return src;
    }

    public static byte[] rotateImage(Context c, String imagePath, int angle, Mat image) {
        try {
            if (image == null) {
                image = Imgcodecs.imread((String)imagePath, (int)-1);
            }
            int flipSide = (angle = angle / 90 % 4 * 90) > 0 ? 1 : 0;
            int number = Math.abs(angle / 90);
            Core.transpose((Mat)image, (Mat)image);
            Core.flip((Mat)image, (Mat)image, (int)flipSide);
            String extension = ".jpg";
            if (imagePath != null) {
                extension = imagePath.substring(imagePath.lastIndexOf("."), imagePath.length()).toLowerCase(Locale.US);
            }
            if (extension.equals(".tiff")) {
                Imgcodecs.imwrite((String)imagePath, (Mat)image);
                byte[] bytes = FileUtils.getByteArray(imagePath);
                return bytes;
            }
            MatOfByte buffer = new MatOfByte();
            Imgcodecs.imencode((String)extension, (Mat)image, (MatOfByte)buffer);
            byte[] bytes = buffer.toArray();
            return bytes;
        }
        catch (Exception e) {
            Logger.e(tag, "failed to rotate image");
            return null;
        }
    }

    public static byte[] getByteArray(String filePath) {
        byte[] data;
        block9: {
            if (filePath == null) {
                return null;
            }
            if (!FileUtils.whiteListFiles(filePath)) {
                Logger.e(tag, "Invalid file name" + filePath);
                return null;
            }
            data = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(filePath);
                data = new byte[fis.available()];
                while (fis.read(data) > -1) {
                }
                fis.close();
            }
            catch (FileNotFoundException e) {
                Logger.e(tag, "File not found: " + e.getMessage());
                FileUtils.closeInputStream(fis);
                break block9;
            }
            catch (IOException e) {
                try {
                    Logger.e(tag, "Error accessing file: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    FileUtils.closeInputStream(fis);
                    throw throwable;
                }
                FileUtils.closeInputStream(fis);
                break block9;
            }
            FileUtils.closeInputStream(fis);
        }
        return data;
    }

    public static boolean deleteFile(String imagePath) {
        if (StringUtils.isEmptyOrNull(imagePath)) {
            return false;
        }
        if (!FileUtils.whiteListFiles(imagePath)) {
            Logger.e(tag, "Invalid file name" + imagePath);
            return false;
        }
        try {
            File file = new File(imagePath);
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                Logger.e(tag, "Error closing a stream: " + e.getMessage());
            }
        }
        is = null;
    }

    public static void addToLogFile(String value, Context c) {
        FileUtils.addToLogFile(null, value, c);
    }

    public static void addToLogFile(String tag, String value, Context c) {
        FileUtils.addToLogFile(tag, value, c, logFilePath);
        RawImagesFlowManager.handleLog(tag == null ? FileUtils.tag : tag, value);
    }

    public static void addToLogFile(String tag, String value, Context c, String path) {
        block10: {
            BufferedWriter fos = null;
            if (c == null || value == null || path == null) {
                return;
            }
            try {
                File f = new File(path);
                if (!f.exists()) {
                    f.createNewFile();
                    Logger.i(tag == null ? FileUtils.tag : tag, "creating new File " + path);
                }
                if ((fos = new BufferedWriter(new FileWriter(path, true))) != null && value != null) {
                    fos.write(String.valueOf(tag == null ? FileUtils.tag : String.valueOf(new Date().getTime()) + " " + tag) + " " + value);
                    fos.newLine();
                }
            }
            catch (FileNotFoundException e) {
                Logger.e(FileUtils.tag, Log.getStackTraceString((Throwable)e));
                FileUtils.close(fos);
                break block10;
            }
            catch (IOException e) {
                try {
                    Logger.e(FileUtils.tag, Log.getStackTraceString((Throwable)e));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    FileUtils.close(fos);
                }
            }
            FileUtils.close(fos);
        }
    }

    /*
     * Loose catch block
     */
    public static void createTestLogFile(String tag, String value, String fileLocation, Context c) {
        block9: {
            BufferedWriter fos = null;
            if (c == null || value == null && tag != null) {
                return;
            }
            try {
                File f = new File(fileLocation);
                if (!f.exists()) {
                    Logger.i(tag, "creating new Test File " + fileLocation);
                    f.createNewFile();
                }
                if ((fos = new BufferedWriter(new FileWriter(fileLocation, true))) != null && value != null && tag != null) {
                    fos.write(String.valueOf(new Date().getTime()) + " " + tag + " " + value);
                    fos.newLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                FileUtils.close(fos);
                break block9;
            }
            catch (IOException iOException) {
                FileUtils.close(fos);
                break block9;
                catch (Throwable throwable) {
                    FileUtils.close(fos);
                    throw throwable;
                }
            }
            FileUtils.close(fos);
        }
    }

    public static void modifySingleImgeLogFile(String tag, String value, String fileName, Context c) {
        if (c == null || fileName == null || tag == null) {
            return;
        }
        Writer fos = null;
        try {
            try {
                if (fileName != null) {
                    String newFilePath;
                    File f;
                    int suffixLocation = 0;
                    if ((fileName = fileName.toLowerCase(Locale.US)).endsWith("jpg")) {
                        suffixLocation = fileName.indexOf(".jpg");
                    }
                    if (fileName.endsWith("jpeg")) {
                        suffixLocation = fileName.indexOf(".jpeg");
                    }
                    if (!(f = new File(newFilePath = String.valueOf(fileName.substring(fileName.lastIndexOf("/") + 1, suffixLocation)) + "_result" + ".txt")).exists()) {
                        Logger.i(tag, "creating single Test File " + fileName);
                        fileName = fileName.substring(0, fileName.lastIndexOf("/") + 1);
                        fos = new BufferedWriter(new FileWriter(String.valueOf(fileName) + newFilePath, true));
                    }
                }
                if (fos != null && value != null) {
                    fos.write(value);
                    ((BufferedWriter)fos).newLine();
                }
            }
            catch (FileNotFoundException suffixLocation) {
                FileUtils.close(fos);
            }
            catch (IOException e) {
                e.printStackTrace();
                FileUtils.close(fos);
            }
        }
        finally {
            FileUtils.close(fos);
        }
    }

    private static void close(BufferedWriter os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                Logger.e(tag, "Error closing a stream: " + e.getMessage());
            }
        }
        os = null;
    }

    private static void closeOutputStream(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                Logger.e(tag, "Error closing a stream: " + e.getMessage());
            }
        }
        os = null;
    }

    public static int[] rectToIntArray(Rect rect) {
        if (rect == null) {
            return null;
        }
        int[] arrayRect = new int[]{rect.x, rect.y, rect.width, rect.height};
        return arrayRect;
    }

    public static Rect arrayToRect(int[] arr) {
        Rect rectResult = new Rect(arr[0], arr[1], arr[2], arr[3]);
        return rectResult;
    }

    public static Mat convertByteImageToMat(byte[] imageData) {
        Mat imageMat = new Mat(1, imageData.length, 2);
        imageMat.put(0, 0, imageData);
        return imageMat;
    }

    public static Mat convertByteImageToMat(byte[] imageData, int cvType) {
        Mat imageMat = new Mat(1, imageData.length, cvType);
        imageMat.put(0, 0, imageData);
        return imageMat;
    }

    public static byte[] convertJpgMatToByte(Mat result_mat) {
        MatOfByte buffer = new MatOfByte();
        Imgcodecs.imencode((String)".jpg", (Mat)result_mat, (MatOfByte)buffer);
        byte[] bytes = buffer.toArray();
        return bytes;
    }

    public static byte[] convertJpgMatToByte(Mat result_mat, float compression) {
        MatOfByte buffer = new MatOfByte();
        MatOfInt params = new MatOfInt(new int[]{1, (int)(compression * 100.0f)});
        Imgcodecs.imencode((String)".jpg", (Mat)result_mat, (MatOfByte)buffer, (MatOfInt)params);
        byte[] bytes = buffer.toArray();
        return bytes;
    }

    public static File lastFileModified(String dir, String after) {
        File fl = new File(dir);
        File[] files = fl.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        long lastMod = Long.MIN_VALUE;
        File choise = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!(file.lastModified() <= lastMod || after != null && file.getPath().contains(after))) {
                choise = file;
                lastMod = file.lastModified();
            }
            ++n2;
        }
        return choise;
    }

    private static void checkStorage(Context c) {
        String state = Environment.getExternalStorageState();
        if (state.equals("mounted") && FileUtils.checkWriteExternalPermission(c)) {
            externalStorageWriteable = true;
            externalStorageAvailable = true;
        } else if (state.equals("mounted_ro")) {
            externalStorageAvailable = true;
            externalStorageWriteable = false;
        } else {
            externalStorageWriteable = false;
            externalStorageAvailable = false;
        }
    }

    private static boolean checkWriteExternalPermission(Context c) {
        String permission = "android.permission.WRITE_EXTERNAL_STORAGE";
        int res = c.checkCallingPermission(permission);
        c.getPackageManager();
        return res == 0;
    }

    public boolean isExternalStorageAvailable(Context c) {
        FileUtils.checkStorage(c);
        return externalStorageAvailable;
    }

    public boolean isExternalStorageWriteable(Context c) {
        FileUtils.checkStorage(c);
        return externalStorageWriteable;
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileInputStream input = new FileInputStream(source);
        FileOutputStream output = new FileOutputStream(destination);
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)input).read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
        }
        finally {
            FileUtils.closeInputStream(input);
            FileUtils.closeOutputStream(output);
        }
    }
}

