/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import java.util.ArrayList;
import java.util.List;

public class CameraTypes {
    public static final int MESSAGE_PROCESS_DATA = 1;
    public static final int MESSAGE_QUIT = 2;
    public static final int MESSAGE_AUTO_FOCUS = 3;
    public static final int MESSAGE_RESTART_PREVIEW = 4;
    public static final int MESSAGE_PROCESS_NOT_VALID = 6;
    public static final int MESSAGE_CAPTURE_STILL_IMAGE = 7;
    public static final int MESSAGE_PROCESS_CAPTURED_IMAGE = 8;
    public static final int MESSAGE_PROCESS_PRE_CAPTURED_IMAGE = 9;
    public static final int MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT = 10;
    public static final int MESSAGE_SHOW_COUNTER = 11;
    public static final int MESSAGE_SHOW_PROCESSING_LABEL = 12;
    public static final int MESSAGE_HIDE_HINT_INDICATOR = 13;
    public static final int MESSAGE_HIDE_BOUNDARIES_RECT = 14;
    public static final int MESSAGE_HIDE_ERROR_MESSAGE = 15;
    public static final int MESSAGE_TOGGLE_TORCH = 16;
    public static final int MESSAGE_INFO = 17;
    public static final int MESSAGE_ERROR = 18;
    public static final int MESSAGE_CONTINUE_ANYWAY = 19;
    public static final int MESSAGE_BARCODE_DETECTED = 20;
    public static final int MESSAGE_BARCODE_ANIMATION_FINISHED = 21;
    public static final int PASSPORT_RESULT = 22;
    public static final int PAN_CARD_RESULT = 23;
    public static final int CHECK_MICR_RESULT = 24;
    public static final int ID_CARD_RESULT = 25;
    public static final int MESSAGE_CREDIT_CARD_RESULT = 26;
    public static final int MESSAGE_DISPLAY_CROPPING_CONTROLLER = 27;
    public static final int MESSAGE_FINISH_CROPPING_CONTROLLER = 28;
    public static final int MESSAGE_PROCESS_VALID = 29;

    public static enum CaptureMode {
        FRONT,
        BACK;

    }

    public static enum HintIndicator {
        CheckToTop(0, CameraManagerController.indicatorString[0]),
        CheckToBottom(1, CameraManagerController.indicatorString[1]),
        CheckToLeft(2, CameraManagerController.indicatorString[2]),
        CheckToRight(3, CameraManagerController.indicatorString[3]),
        Hold(4, CameraManagerController.indicatorString[4]),
        Align(5, CameraManagerController.indicatorString[5]),
        RotateLeft(6, CameraManagerController.indicatorString[6]),
        RotateRight(7, CameraManagerController.indicatorString[7]),
        ZoomIn(8, CameraManagerController.indicatorString[8]),
        ZoomOut(9, CameraManagerController.indicatorString[9]),
        NoLight(10, CameraManagerController.indicatorString[10]),
        Blur(11, CameraManagerController.indicatorString[11]),
        None(12, ""),
        HoldFlat(13, CameraManagerController.indicatorString[12]),
        MoveToBARCODE(14, CameraManagerController.indicatorString[13]),
        AspectRatioFailed(15, CameraManagerController.indicatorString[14]),
        AlignCreditBoundaries(16, CameraManagerController.indicatorString[15]),
        invalidRotation(17, CameraManagerController.indicatorString[16]);

        int id;
        String text;

        private HintIndicator(int id2, String text) {
            this.id = id2;
            this.text = text;
        }

        public int getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }
    }

    public static enum NEXT_ACTION {
        CAPTURE_FRONT,
        CAPTURE_BACK,
        PROCESS_IMAGE_FOR_SERVER;

    }

    public static enum OCRAnalyzeErrorCode {
        NONE,
        FAILED_READING_OCR_GENERAL,
        FAILED_PREPARING_IMAGE,
        FAILED_PREPARING_IMAGE_GENERAL,
        ERROR_MICR_LENGTH,
        TISFlowErrorReadingCheckContrast,
        TISFlowErrorMaxRetries,
        TISFlowErrorMicrInterrupted,
        TISFlowErrorMicrOnBack;

    }

    public static enum TISBarcodeType {
        UPCE_CODE(1),
        CODE_39_CODE(2),
        CODE_39_MOD_43_CODE(3),
        EAN_13_CODE(4),
        EAN_8_CODE(5),
        CODE_93_CODE(6),
        CODE_128_CODE(7),
        PDF_417_CODE(8),
        QR_CODE(9),
        AZTEC_CODE(10),
        INTERLEAVED_2_OF_5_CODE(11),
        ITF_14_CODE(12),
        DATA_MATRIX_CODE(13);

        private int value;

        private TISBarcodeType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ArrayList<TISBarcodeType> getEnumArrayListFromIntegerList(List<Integer> list) {
            if (list == null) {
                return null;
            }
            ArrayList<TISBarcodeType> enumList = new ArrayList<TISBarcodeType>();
            for (int item : list) {
                enumList.add(TISBarcodeType.getEnum(item));
            }
            return enumList;
        }

        public static ArrayList<Integer> getIntegerArrayListFromEnumList(List<TISBarcodeType> list) {
            if (list == null) {
                return null;
            }
            ArrayList<Integer> integerList = new ArrayList<Integer>();
            for (TISBarcodeType item : list) {
                integerList.add(item.getValue());
            }
            return integerList;
        }

        public static TISBarcodeType getEnum(int value) {
            switch (value) {
                case 1: {
                    return UPCE_CODE;
                }
                case 2: {
                    return CODE_39_CODE;
                }
                case 3: {
                    return CODE_39_MOD_43_CODE;
                }
                case 4: {
                    return EAN_13_CODE;
                }
                case 5: {
                    return EAN_8_CODE;
                }
                case 6: {
                    return CODE_93_CODE;
                }
                case 7: {
                    return CODE_128_CODE;
                }
                case 8: {
                    return PDF_417_CODE;
                }
                case 9: {
                    return QR_CODE;
                }
                case 10: {
                    return AZTEC_CODE;
                }
                case 11: {
                    return INTERLEAVED_2_OF_5_CODE;
                }
                case 12: {
                    return ITF_14_CODE;
                }
                case 13: {
                    return DATA_MATRIX_CODE;
                }
            }
            return null;
        }
    }

    public static enum TISFlowErrorMessage {
        ERROR_GENERAL_FAIL,
        ERROR_MAX_RETRIES,
        ERROR_MICR_READING_CHECK,
        ERROR_IMAGE_CONTRAST,
        ERROR_NO_VALID_BOUNDING_BOX,
        ERROR_IQA_CORNER_DATA,
        ERROR_IQA_EDGE_DATA,
        ERROR_IQA_SKEW,
        ERROR_IQA_DARKNESS,
        ERROR_IQA_NUM_SPOTS,
        ERROR_IQA_PIGGY_BACK,
        ERROR_IQA_HORIZONTAL_STREAK,
        ERROR_IQA_CARBON_STRIP,
        ERROR_BLUR_DETECTED,
        ERROR_MICR_LENGHT,
        UNSUPPORTED_CAMERA,
        UNSPORTTED_AUTO_FOCUS,
        UNSPORTTED_CPU,
        ERROR_OCR_READING,
        ERROR_MICR_INTERUPPTED,
        ERROR_MICR_ON_BACK,
        ERROR_IQA_IMAGE_DIMENTIONS;

    }

    public static enum TISFlowGeneralMessages {
        CAPTURE_BACK,
        MULTI_CAPTURE,
        BACK_PRESSED,
        PAN_CARD_OCR_RESULT,
        PASSPORT_OCR_RESULT,
        CHECK_OCR_RESULT,
        ID_CARD_OCR_RESULT,
        CREDIT_CARD_OCR_RESULT;

    }

    public static enum TISFlowInputMessages {
        CANCEL_SESSION,
        CONTINUE_MOBI_FLOW,
        CONTINUE_MOBI_FLOW_CUSTOM_UI,
        OCR_RESULT_FAILED,
        CONTINUE_CURRENT_SESSION,
        OCR_RESULT_OK;

    }

    public static enum TISFlowUIMessages {
        INIT_LAYOUT,
        BEFORE_PROCESSING,
        AFTER_PROCESSING,
        HINT_CHANGED,
        INSTRUCTION_CHANGED;

    }

    public static enum UpdateUiAction {
        SHOW_ERROR_MESSAGE(1),
        SHOW_COUNTER(2),
        SHOW_ORIENTATION_LABEL(4),
        CAPTURE_STILL_IMAGE(8),
        PROCESS_CAPTURED_IMAGE(25),
        SHOW_HINT_INDICATOR(32),
        SHOW_BOUNDARIES_RECT(64),
        SHOW_BOUNDARIES(128);

        int value;

        private UpdateUiAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

