package com.topimagesystems.util;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.TextView;

public class AccessibilityUtils {
	
	private static AccessibilityManager accessibilityManager;

	public static void sendAnnouncement(Context context, TextView textView, String className){
		
		if (accessibilityManager == null)
			accessibilityManager = (AccessibilityManager) context.getSystemService(Context.ACCESSIBILITY_SERVICE);
		if (accessibilityManager.isEnabled()) {
			int ae = AccessibilityEvent.TYPE_ANNOUNCEMENT;
			if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN)
				ae = AccessibilityEvent.TYPE_NOTIFICATION_STATE_CHANGED;

			AccessibilityEvent e = AccessibilityEvent.obtain(ae);
		    e.setEventType(ae);
		    e.setClassName(className);
		    e.setPackageName(context.getPackageName());
		    e.setEnabled(true);
			if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
				
			    e.getText().add(textView.getContentDescription());
			    accessibilityManager.sendAccessibilityEvent(e);
			}
			else {
				textView.setImportantForAccessibility(View.IMPORTANT_FOR_ACCESSIBILITY_YES);
				textView.announceForAccessibility(textView.getContentDescription());
				/*AccessibilityRecord ar = AccessibilityRecord.obtain();
				ar.setContentDescription(textView.getContentDescription());
				e.appendRecord(ar);*/
			}
			
	    }
	}
	
	
	public static boolean isAccessibilityEnabled(Context context){
		if (accessibilityManager == null)
			accessibilityManager = (AccessibilityManager) context.getSystemService(Context.ACCESSIBILITY_SERVICE);
		return accessibilityManager.isEnabled();
	}
}
