/*
 * 
 */
package com.topimagesystems.ui;

import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.TextView;

import com.topimagesystems.R;
import com.topimagesystems.data.Preferences;
import com.topimagesystems.util.AccessibilityUtils;
import com.topimagesystems.util.StringUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class InfoScreenActivity.
 */
public class InfoScreenActivity extends Activity {
	
	/** The engine. */
	private TextView engine;

	private TextView neverShowAgainText;
	
	/** The close screen. */
	private Button closeScreen;
	
	/** The never show again check. */
	private CheckBox neverShowAgainCheck;
	
	/** The preferences. */
	private Preferences preferences;

	public static boolean isInfoScreenShown = false;

	/* (non-Javadoc)
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		overridePendingTransition(R.anim.slide_in_up, R.anim.slide_stay);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		setContentView(R.layout.info_screen);
		engine = (TextView) findViewById(R.id.infoScreenDetails);
		String txt = StringUtils.dynamicString(this, "TISInfoScreenText");
		engine.setText(txt);
		closeScreen = (Button) findViewById(R.id.closeInfoScreen);
		closeScreen.setText(StringUtils.dynamicString(this, "TISFlowInfoScreenButtonCaption"));
		neverShowAgainText = (TextView) findViewById(R.id.txtIntroductionContent);
		neverShowAgainText.setText(StringUtils.dynamicString(this, "TISFlowInfoScreenCheckBoxCaption"));
		preferences =  Preferences.getInstance(this);
		neverShowAgainCheck = (CheckBox) findViewById(R.id.dontShowAgainCheck);		
		closeScreen.setOnClickListener(new OnClickListener() {			
			@Override
			public void onClick(View v) {
				if (neverShowAgainCheck.isChecked()){
					preferences.setIsDontShowInfoChecked(true);										
				}
				onBackPressed();
			}
		});


		engine.post(new Runnable() {
			@Override
			public void run() {
				if (StringUtils.isEmptyOrNull((String) engine.getContentDescription()))
					engine.setContentDescription(engine.getText());
				AccessibilityUtils.sendAnnouncement(InfoScreenActivity.this, engine, getClass().getName());
			}
		});
	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.		
		return true;
	}
	
	/* (non-Javadoc)
	 * @see android.app.Activity#onBackPressed()
	 */
	@Override
	public void onBackPressed() {
		super.onBackPressed();
		overridePendingTransition(R.anim.slide_stay, R.anim.slide_out_up);
	}

}
