/*
 * 
 */
package com.topimagesystems.ui;

import org.opencv.core.Rect;

import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

// TODO: Auto-generated Javadoc
/**
 * The Class DebugRectView.
 */
public class DebugRectView extends View {

    /** The rect. */
    private Rect rect;
    
    /** The rect paint. */
    private Paint rectPaint;

    /**
     * Instantiates a new debug rect view.
     *
     * @param context the context
     */
    public DebugRectView(Context context) {
	super(context);
	init();
    }

    /**
     * Instantiates a new debug rect view.
     *
     * @param arg0 the arg0
     * @param arg1 the arg1
     */
    public DebugRectView(Context arg0, AttributeSet arg1) {
	super(arg0, arg1);	
	TypedArray a = arg0.obtainStyledAttributes(arg1, R.styleable.captureOverlay);
	CameraController.drawFoundedRectangle = a.getBoolean(R.styleable.captureOverlay_showCurrentRectangleFound, false);
	a.recycle();			
	init();
	
    }

    /**
     * Instantiates a new debug rect view.
     *
     * @param arg0 the arg0
     * @param arg1 the arg1
     * @param arg2 the arg2
     */
    public DebugRectView(Context arg0, AttributeSet arg1, int arg2) {
	super(arg0, arg1, arg2);
	init();
    }

    /**
     * Inits the.
     */
    private void init() {
	if (isInEditMode()) {
	    return;
	}
	rectPaint = new Paint();
	rectPaint.setColor(Color.GRAY);
	rectPaint.setStyle(Paint.Style.STROKE);
	rectPaint.setStrokeWidth(3.0f);
	if (CameraController.drawFoundedRectangle && !CameraManagerController.isDebug){
	    rectPaint.setColor(Color.RED);
	    CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY = 200L;
	    rectPaint.setStrokeWidth(4.0f);
	}
	
    }

    /**
     * Sets the rect.
     *
     * @param rect the new rect
     */
    @Deprecated
    public void setRect(Rect rect) {
	drawCheckRect(rect);
    }
    public Rect getRect(){
    	return rect;
    }

    /**
     * Draw check rect.
     *
     * @param rect the rect
     */
    public void drawCheckRect(Rect rect) {
	this.rect = rect;
	invalidate();
    }

    /**
     * Clear check rect.
     */
    public void clearCheckRect() {
	this.rect = null;
	invalidate();
    }

    /* (non-Javadoc)
     * @see android.view.View#onDraw(android.graphics.Canvas)
     */
    @Override
    protected void onDraw(Canvas canvas) {
	super.onDraw(canvas);
	if (rect != null) {
	 /*   if (CameraManagerController.imageType == documentType.FULL_PAGE) {
		int tmp = rect.width;
		rect.width = rect.height;
		rect.height = tmp;
	    }*/
	    canvas.drawRect(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, rectPaint);
	}
    }
}
