package com.topimagesystems.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;

/**
 * Created by ruthlosser on 29/05/2017.
 */

public class CustomCanvasView extends View {

    private ICustomCanvasPainter mPainter;

    public CustomCanvasView(Context context) {
        super(context);
    }

    public CustomCanvasView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CustomCanvasView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public CustomCanvasView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setPainter(ICustomCanvasPainter painter) {
        mPainter = painter;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (mPainter != null)
            mPainter.drawOnCanvas(canvas);
    }

    public interface ICustomCanvasPainter {
        void drawOnCanvas(Canvas canvas);
    }
}
