package com.topimagesystems.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;

//import com.topimagesystems.payment.CreditCard;

//import java.lang.ref.WeakReference;

/**
 * Created by ruthlosser on 17/11/2016.
 */

public class CreditCardBoundariesView extends CheckBounderiesView {

    private static final int GUIDE_STROKE_WIDTH = 15;

    public boolean complete;
    public boolean topEdge;
    public boolean bottomEdge;
    public boolean leftEdge;
    public boolean rightEdge;
    public boolean infoAvailable;

    private int guideColor = Color.GREEN;

    private final boolean useRegularBoundaries = true;

    // Keep paint objects around for high frequency methods to avoid re-allocating them.
    private final Paint mGuidePaint = new Paint(Paint.ANTI_ALIAS_FLAG);;

    private int mRotationFlip;
    private float mScale = 1;

    public CreditCardBoundariesView(Context context) {
        super(context);
    }

    public CreditCardBoundariesView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CreditCardBoundariesView(Context arg0, AttributeSet arg1, int arg2) {
        super(arg0, arg1, arg2);
    }

    int numVisibleEdges() {
        return (topEdge ? 1 : 0) + (bottomEdge ? 1 : 0) + (leftEdge ? 1 : 0) + (rightEdge ? 1 : 0);
    }

    @Override
    protected void drawDocumentBoundaries(Canvas canvas){
        if (useRegularBoundaries) {
            showBounderies(numVisibleEdges() == 4, true);
            super.drawDocumentBoundaries(canvas);
            return;
        }

//        canvas.save();
        int tickLength = Math.min(validationBoundariesRect.height, validationBoundariesRect.width) / 4;

        if (infoAvailable && numVisibleEdges() == 4) {
            // draw lock shadow. //valid

        }

        mGuidePaint.clearShadowLayer();
        mGuidePaint.setStyle(Paint.Style.FILL);
        mGuidePaint.setColor(guideColor);

        canvas.drawRect(
                guideStrokeRect(validationBoundariesRect.x, validationBoundariesRect.y, validationBoundariesRect.x + tickLength, validationBoundariesRect.y),
                mGuidePaint);
        canvas.drawRect(
                guideStrokeRect(validationBoundariesRect.x, validationBoundariesRect.y, validationBoundariesRect.x, validationBoundariesRect.y + tickLength),
                mGuidePaint);

        canvas.drawRect(
                guideStrokeRect((int)validationBoundariesRect.br().x, validationBoundariesRect.y, (int)validationBoundariesRect.br().x - tickLength, validationBoundariesRect.y),
                mGuidePaint);
        canvas.drawRect(
                guideStrokeRect((int)validationBoundariesRect.br().x, validationBoundariesRect.y, (int)validationBoundariesRect.br().x, validationBoundariesRect.y + tickLength),
                mGuidePaint);

        canvas.drawRect(
                guideStrokeRect(validationBoundariesRect.x, (int)validationBoundariesRect.br().y, validationBoundariesRect.x + tickLength, (int)validationBoundariesRect.br().y),
                mGuidePaint);
        canvas.drawRect(
                guideStrokeRect(validationBoundariesRect.x, (int)validationBoundariesRect.br().y, validationBoundariesRect.x, (int)validationBoundariesRect.br().y - tickLength),
                mGuidePaint);

        canvas.drawRect(
                guideStrokeRect((int)validationBoundariesRect.br().x, (int)validationBoundariesRect.br().y, (int)validationBoundariesRect.br().x - tickLength,
                        (int)validationBoundariesRect.br().y), mGuidePaint);
        canvas.drawRect(
                guideStrokeRect((int)validationBoundariesRect.br().x, (int)validationBoundariesRect.br().y, (int)validationBoundariesRect.br().x, (int)validationBoundariesRect.br().y
                        - tickLength), mGuidePaint);

        if (infoAvailable) {
            if (topEdge) {
                canvas.drawRect(guideStrokeRect(validationBoundariesRect.x, validationBoundariesRect.y, (int)validationBoundariesRect.br().x, validationBoundariesRect.y),
                        mGuidePaint);
            }
            if (bottomEdge) {
                canvas.drawRect(
                        guideStrokeRect(validationBoundariesRect.x, (int)validationBoundariesRect.br().y, (int)validationBoundariesRect.br().x, (int)validationBoundariesRect.br().y),
                        mGuidePaint);
            }
            if (leftEdge) {
                canvas.drawRect(
                        guideStrokeRect(validationBoundariesRect.x, validationBoundariesRect.y, validationBoundariesRect.x, (int)validationBoundariesRect.br().y),
                        mGuidePaint);
            }
            if (rightEdge) {
                canvas.drawRect(
                        guideStrokeRect((int)validationBoundariesRect.br().x, validationBoundariesRect.y, (int)validationBoundariesRect.br().x, (int)validationBoundariesRect.br().y),
                        mGuidePaint);
            }

            if (numVisibleEdges() < 3) {
                ///show not valid
            }
        }
//        canvas.restore();

    }

    private Rect guideStrokeRect(int x1, int y1, int x2, int y2) {
        Rect r;
        int t2 = (int) (GUIDE_STROKE_WIDTH / 2 * mScale);
        r = new Rect();

        r.left = Math.min(x1, x2) - t2;
        r.right = Math.max(x1, x2) + t2;

        r.top = Math.min(y1, y2) - t2;
        r.bottom = Math.max(y1, y2) + t2;

        return r;
    }

    public void updatedEdges(boolean[] edges) {
        infoAvailable = true;
        leftEdge = edges[0];
        topEdge = edges[1];
        rightEdge = edges[2];
        bottomEdge = edges[3];
    }
}
