/*
 * 
 */
package com.topimagesystems.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

// TODO: Auto-generated Javadoc
/**
 * The Class ActionBar.
 */
public class ActionBar extends RelativeLayout {

	/**
	 * The Enum ActionBarContext.
	 */
	public enum ActionBarContext {
		
		/** The none. */
		NONE, 
 /** The default. */
 DEFAULT, 
 /** The camera manager. */
 CAMERA_MANAGER
	}

	/** The btn left. */
	private Button btnLeft;
	
	/** The btn right. */
	private Button btnRight;
	
	/** The txt action bar title. */
	private TextView txtActionBarTitle;
	
	/** The img action bar icon. */
	private ImageView imgActionBarIcon;
	
	/** The action bar button click listener. */
	private ActionBarButtonClickListener actionBarButtonClickListener;

	/**
	 * Instantiates a new action bar.
	 *
	 * @param context the context
	 */
	public ActionBar(Context context) {
		super(context);
	}

	/**
	 * Instantiates a new action bar.
	 *
	 * @param context the context
	 * @param attrs the attrs
	 */
	public ActionBar(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	/**
	 * Instantiates a new action bar.
	 *
	 * @param context the context
	 * @param attrs the attrs
	 * @param defStyle the def style
	 */
	public ActionBar(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);

	}

	/* (non-Javadoc)
	 * @see android.view.View#onFinishInflate()
	 */
	@Override
	protected void onFinishInflate() {
		super.onFinishInflate();
		init();
	}

	/**
	 * Inits the.
	 */
	private void init() {
	}

	/**
	 * Ensure ui.
	 *
	 * @param actionBarContext the action bar context
	 */
	public void ensureUI(ActionBarContext actionBarContext) {

		switch (actionBarContext) {
			case NONE:
			case DEFAULT:
				btnRight.setVisibility(View.GONE);
				btnLeft.setVisibility(View.GONE);
				break;
			case CAMERA_MANAGER:
				btnRight.setVisibility(View.GONE);
				btnLeft.setVisibility(View.GONE);
				txtActionBarTitle.setText("");
				imgActionBarIcon.setVisibility(GONE);
				break;
				
			default:
				break;
		}
	}

	/**
	 * Sets the right btn text.
	 *
	 * @param string the new right btn text
	 */
	public void setRightBtnText(String string) {
		if (btnRight != null) {
			btnRight.setText(string);
		}
	}

	/**
	 * Sets the action bar button click listener.
	 *
	 * @param actionBarButtonClickListener the new action bar button click listener
	 */
	public void setActionBarButtonClickListener(ActionBarButtonClickListener actionBarButtonClickListener) {
		this.actionBarButtonClickListener = actionBarButtonClickListener;
	}

	/**
	 * The listener interface for receiving actionBar events.
	 * The class that is interested in processing a actionBar
	 * event implements this interface, and the object created
	 * with that class is registered with a component using the
	 * component's <code>addActionBarListener<code> method. When
	 * the actionBar event occurs, that object's appropriate
	 * method is invoked.
	 *
	 * @see ActionBarEvent
	 */
	class ActionBarListener implements OnClickListener {
		
		/* (non-Javadoc)
		 * @see android.view.View.OnClickListener#onClick(android.view.View)
		 */
		@Override
		public void onClick(View v) {
			if (actionBarButtonClickListener == null)
				return;

			if (v == btnLeft) {
				actionBarButtonClickListener.onBtnLeftClick();
			}
			else if (v == btnRight) {
				actionBarButtonClickListener.onBtnRightClick();
			}
		}
	}

	/**
	 * The listener interface for receiving actionBarButtonClick events.
	 * The class that is interested in processing a actionBarButtonClick
	 * event implements this interface, and the object created
	 * with that class is registered with a component using the
	 * component's <code>addActionBarButtonClickListener<code> method. When
	 * the actionBarButtonClick event occurs, that object's appropriate
	 * method is invoked.
	 *
	 * @see ActionBarButtonClickEvent
	 */
	public interface ActionBarButtonClickListener {
		
		/**
		 * On btn left click.
		 */
		public void onBtnLeftClick();

		/**
		 * On btn right click.
		 */
		public void onBtnRightClick();
	}

}