package com.topimagesystems.micr;

import com.topimagesystems.credit.CardType;

public class TISCreditCardProcessingResults extends OCRResult {

	/**
	 * 15 or 16 digit card number. All numbers, no spaces.
	 */
	public String cardNumber;

	/**
	 * Month in two digit natural form. {January=1, ..., December=12}
	 */
	public int expiryMonth = 0;

	/**
	 * Four digit year
	 */
	public int expiryYear = 0;

	/**
	 * The card number string consisting of all but the last four digits replaced with
	 * bullet ('&#8226;').
	 */
	public String redactedCardNumber;

	/**
	 * A string suitable for display, with spaces inserted for readability.
	 */
	public String formattedCardNumber;

	/**
	 * A string suitable for display, with spaces inserted for readability.
	 */
	public boolean isExpiryValid;



	public String getResultString() {
		return formattedCardNumber + (isExpiryValid? "\nExpiry Month:" + expiryMonth + "\nExpiry Year:" + expiryYear : "");
	}


	/**
	 * @return The last four digits of the card number
	 */
	public String getLastFourDigitsOfCardNumber() {
		if (cardNumber != null) {
			int available = Math.min(4, cardNumber.length());
			return cardNumber.substring(cardNumber.length() - available);
		} else {
			return "";
		}
	}

	/**
	 * @return The type of card, detected from the number
	 */
	public CardType getCardType() {
		return CardType.fromCardNumber(cardNumber);
	}


}
