/*
 * 
 */
package com.topimagesystems.micr;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;

import com.topimagesystems.Common;
import com.topimagesystems.Common.OCRType;
import com.topimagesystems.Config;
import com.topimagesystems.Constants;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraController.CameraActivityHandler;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.OCRHelper;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.intent.CaptureIntent.SessionType;
import com.topimagesystems.intent.CaptureIntent.TISDocumentType;
import com.topimagesystems.intent.IQASettingsIntent;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.UserInterfaceUtils;

import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;


// TODO: Auto-generated Javadoc
/**
 * The Class MobiCHECKOCR.
 */
public class MobiCHECKOCR {

	private static String tag = Logger.makeLogTag("MobiCHECKOCR");
	//

	//private static String mLoggerPathExternal = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separatorChar + ".debugmobiflow" + File.separatorChar;


	/** The m native obj. */
	private long mNativeObj = 0;

	/** The context. */
	private Context context;

	/** The digits file e13 b path. */
	private String digitsFileE13BPath;

	/** The signs file e13 b path. */
	private String signsFileE13BPath;

	/** The digits file cm c7 path. */
	private String digitsFileCMC7Path;

	/** The signs file cm c7 path. */
	private String signsFileCMC7Path;

	/** The ocr mask numbers path. */
	private String ocrMaskNumbersPath;

	/** The blur resources. */
	private String blurResources;

	private String passportDigits;
	private String panCardDigits;
	private String ocrADigits;
	private String passportABC;

	private String passportDigitsABC;

	/** The handler. */
	private CameraActivityHandler handler;

	/** The java notifier. */
	private JavaNotifier javaNotifier;

	/** The asset manager. */
	private  AssetManager assetManager;


	/**
	 * Instantiates a new mobi checkocr.
	 *
	 * @param context the context
	 * @param isDebug the is debug
	 * @param minRatioHW the min ratio hw
	 * @param maxRatioHW the max ratio hw
	 * @param micrType the micr type
	 * @param isUseCustomAlgorithmOnBack the is use custom algorithm on back
	 * @param isBinarizeBakSameAsFront the is binarize bak same as front
	 * @param outputHeightInInch the output height in inch
	 * @param outputWidthInInch the output width in inch
	 * @param minRatioHWBack the min ratio hw back
	 * @param maxRatioHWBack the max ratio hw back
	 * @param isIQAEnabled the is iqa enabled
	 * @param iqaSettings the iqa settings
	 * @param isBlurEnabled the is blur enabled
	 * @throws Throwable
	 */
	public MobiCHECKOCR(Context context, boolean isDebug, float minRatioHW, float maxRatioHW, int micrType, boolean isUseCustomAlgorithmOnBack, boolean isBinarizeBakSameAsFront, float outputHeightInInch, float outputWidthInInch, float minRatioHWBack, float maxRatioHWBack, boolean isIQAEnabled, IQASettingsIntent iqaSettings, boolean isBlurEnabled) throws Throwable {
		try {
			this.context = context;
			//  if (micrType != OCRType.OFF.getId() && micrType != OCRType.UNKNOWN.getId()){
			digitsFileE13BPath = FileUtils.readRawResource(context, R.raw.digits_masks, "digits_masks.csv");
			signsFileE13BPath = FileUtils.readRawResource(context, R.raw.signs_masks, "signs_masks.csv");
			digitsFileCMC7Path = FileUtils.readRawResource(context, R.raw.barcode_digits_masks, "barcode_digits_masks.csv");
			signsFileCMC7Path = FileUtils.readRawResource(context, R.raw.barcode_signs_masks, "barcode_signs_masks.csv");
			ocrMaskNumbersPath = FileUtils.readOCRMaskRawResources(context, "ocrMaskNumbers");
			passportDigits = FileUtils.readOCRMRZRawResources(context, "ocrMrzNumbers");
			panCardDigits =  FileUtils.readOCRPanRawResources(context, "ocrPanLetters");
			ocrADigits  = FileUtils.readRawResource(context, R.raw.ocra_masks, "ocra_digits_masks.csv");

			//    }
			if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE){
				blurResources = FileUtils.readRawResource(context,R.raw.blur_detect,"blur_detect_full.yml");
			}
			else{
				blurResources = FileUtils.readRawResource(context,R.raw.blur_detect,"blur_detect.yml");
			}
			//   File yourFile = new File("/data/data/com.topimagesystems.sample/app_micr/pan_data.xml");
//	    Logger.e("is valid file to read %d",String.valueOf(yourFile.canRead()));
//	    FileOutputStream outputStream = null;
//	    try {
//	    	FileOutputStream fos = new FileOutputStream(yourFile);
//			PrintWriter pw = new PrintWriter(fos);
//			pw.flush();
//			pw.close();
//	    } catch (Exception e) {
//	        e.printStackTrace();
//	    }


			//passportDigits = FileUtils.readRawResource(context,R.raw.big_img_mrz_digit,"big_img_mrz_digit.jpg");
			//    passportABC = FileUtils.readRawResource(context,R.raw.big_img_mrz_abc,"big_img_mrz_abc.jpg");
			//   passportDigitsABC = FileUtils.readRawResource(context,R.raw.img_digit_and_abc,"img_digit_and_abc.jpg");

			float maxImageWidth = Config.MAX_IMAGE_WIDTH_IN_INCH;
			float minImageWidth = Config.MIN_IMAGE_WIDTH_IN_INCH;
			float maxImageHeight = Config.MAX_IMAGE_HEIGHT_IN_INCH;
			float minImageHeight = Config.MIN_IMAGE_HEIGHT_IN_INCH;

			// IQADataItem

			String digitalRowDelimiter = "-";
			// we will run SVM blur only on bills.
			if (CameraManagerController.imageType != TISDocumentType.PAYMENT){
				isBlurEnabled = false;
			}


			String loggerPath = FileUtils.internalStorageLocation+"/.mobiflow/";
			Rect ResultRect = convertRectToCorrectAspectRatio(CameraSessionManager.getInstance().getCheckBoundariesRect().getValidationRect(),3);
			maxRatioHW = (float) (((float)ResultRect.height/(float)ResultRect.width )* 1.1);
			minRatioHW = (float) (((float)ResultRect.height/(float)ResultRect.width )* 0.9);
			//maxRatioHW *= 3;
			//minRatioHW *=0.3;
			mNativeObj = nativeCreateObject(isDebug, CameraManagerController.ocrType.getId(), digitsFileE13BPath, signsFileE13BPath, digitsFileCMC7Path, signsFileCMC7Path, ocrMaskNumbersPath,
					digitalRowDelimiter, blurResources,minRatioHW, maxRatioHW, maxImageWidth, minImageWidth, maxImageHeight, minImageHeight, isUseCustomAlgorithmOnBack,
					isBinarizeBakSameAsFront, outputHeightInInch, outputWidthInInch, minRatioHWBack, maxRatioHWBack, isIQAEnabled, iqaSettings, isBlurEnabled,
					CameraManagerController.getDocumentAsInt(CameraManagerController.imageType), loggerPath);



		} catch (Throwable e) {
			e.printStackTrace();
			throw new NoSuchFieldException();
		}
	}

	/**
	 * Sets the handler.
	 *
	 * @param handler the new handler
	 */
	public void setHandler(CameraActivityHandler handler) {
		this.handler = handler;
		this.javaNotifier = new JavaNotifier(handler, context);
		initOcrManager(CameraManagerController.ocrType.getId());
		//createAssetAudioPlayer(assetManager,"background.mp3");

	}

	/**
	 * Sets the validation check rect.
	 *
	 * @param validCheckBoundaries the valid check boundaries
	 * @param minCheckBoundaries the min check boundaries
	 * @param validCheckBoundariesBack the valid check boundaries back
	 * @param minCheckBoundariesBack the min check boundaries back
	 */
	public void setValidationCheckRect(Rect validCheckBoundaries, Rect minCheckBoundaries, Rect validCheckBoundariesBack, Rect minCheckBoundariesBack){
		int[] validCheckBoundariesArray = { 0, 0, CameraConfigurationManager.videoResolutionHeight, CameraConfigurationManager.videoResolutionWidth };
		int[] minCheckBoundariesArray = { 120, 157, 480, 765 };
		int[] validCheckBoundariesBackArray = { 0, 0, CameraConfigurationManager.videoResolutionHeight, CameraConfigurationManager.videoResolutionWidth };
		int[] minCheckBoundariesBackArray = { 120, 157, 480, 765 };


		if (CameraManagerController.sessionType == SessionType.PORTRAIT){
			Point screenResolution = UserInterfaceUtils.getDisplayDimensions(context);
			double heightInPixels = (double)screenResolution.x > screenResolution.y ? screenResolution.x : screenResolution.y;
			double aspectRatio = (double)CameraConfigurationManager.videoResolutionWidth / heightInPixels;
			int[] portraitRect = {(int)((double)validCheckBoundaries.x*aspectRatio),(int)((double)validCheckBoundaries.y*aspectRatio) , (int)((double)validCheckBoundaries.width*aspectRatio), (int)((double)validCheckBoundaries.height*aspectRatio) };
			validCheckBoundariesArray = portraitRect;
			Rect validationRect = new Rect(portraitRect[0],portraitRect[1],portraitRect[2],portraitRect[3]);
			CameraSessionManager.getInstance().setCheckBoundariesRect(validationRect);
////
//    	    		int[] minPortraitRect = {(int)((double)minCheckBoundaries.x*aspectRatio),(int)((double)minCheckBoundaries.y*aspectRatio) , (int)((double)minCheckBoundaries.width*aspectRatio), (int)((double)minCheckBoundaries.height*aspectRatio) };
//    	    		minCheckBoundaries.x = minPortraitRect[0];
//    	    		minCheckBoundaries.y = minPortraitRect[1];
//    	    		minCheckBoundaries.width = minPortraitRect[2];
//    	    		minCheckBoundaries.height = minPortraitRect[3];
		}


//		if (CameraManagerController.imageType == TISDocumentType.CUSTOM && CameraManagerController.sessionType != SessionType.PORTRAIT){
//			Point screenResolution = UserInterfaceUtils.getDisplayDimensions(context);
//			double heightInPixels = (double)screenResolution.x > screenResolution.y ? screenResolution.x : screenResolution.y;
//			double aspectRatio = (double)CameraConfigurationManager.videoResolutionWidth / heightInPixels;
//			int[] landscapeRect = {(int)((double)validCheckBoundaries.x*aspectRatio),(int)((double)validCheckBoundaries.y*aspectRatio) , (int)((double)validCheckBoundaries.width*aspectRatio), (int)((double)validCheckBoundaries.height*aspectRatio) };
//			validCheckBoundariesArray = landscapeRect;
//			Rect validationRect = new Rect(landscapeRect[0],landscapeRect[1],landscapeRect[2],landscapeRect[3]);
//			CameraSessionManager.getInstance().setCheckBoundariesRect(validationRect);
//
//		}

	//	validCheckBoundaries = convertRectToCorrectAspectRatio(validCheckBoundaries,3);
	//	minCheckBoundaries = convertRectToCorrectAspectRatio(minCheckBoundaries,3);

		if (CameraManagerController.imageType != TISDocumentType.FULL_PAGE && CameraManagerController.sessionType != SessionType.PORTRAIT){
			if (validCheckBoundaries != null) {
				validCheckBoundariesArray = rectToArray(validCheckBoundaries);
			}

			if (minCheckBoundaries != null) {
//						org.opencv.core.Rect res = convertRectToCorrectAspectRatio(minCheckBoundaries,false);
//						minCheckBoundaries.x = res.x;
//						minCheckBoundaries.y = res.y;
//						minCheckBoundaries.width = res.width;
//						minCheckBoundaries.height = res.height;
				minCheckBoundariesArray = rectToArray(minCheckBoundaries);
			}

			if (validCheckBoundariesBack != null)
				validCheckBoundariesBackArray = rectToArray(validCheckBoundariesBack);

			if (minCheckBoundariesBack != null)
				minCheckBoundariesBackArray = rectToArray(minCheckBoundariesBack);

		}


		setValidationCheckRect(mNativeObj, validCheckBoundariesArray, minCheckBoundariesArray, validCheckBoundariesBackArray, minCheckBoundariesBackArray);

	}

	public static org.opencv.core.Rect convertRectToCorrectAspectRatio(org.opencv.core.Rect rectToValidate,int convertFromScreenToVideo){
		Matrix scaleMatrix = new Matrix();
		//if (scaleMatrix == null){
		scaleMatrix = new Matrix();
		RectF screenResolution;
		RectF videoResolution;
		RectF stillsResolution;
		int videoBigRes;
		int videoSmallRes;
		int stillsBigRes;
		int stillsSmallRes;
		int screenBigRes;
		int screenSmallRes;
//		CameraConfigurationManager.videoResolutionWidth = 864;
//    	CameraConfigurationManager.videoResolutionHeight = 480;

		if (CameraConfigurationManager.videoResolutionWidth > CameraConfigurationManager.videoResolutionHeight){
			videoBigRes = CameraConfigurationManager.videoResolutionWidth;
			videoSmallRes = CameraConfigurationManager.videoResolutionHeight;
			stillsBigRes = CameraConfigurationManager.captureResolutionWidth;
			stillsSmallRes = CameraConfigurationManager.captureResolutionHeight;
		}
		else{
			videoSmallRes = CameraConfigurationManager.videoResolutionWidth;
			videoBigRes = CameraConfigurationManager.videoResolutionHeight;
			stillsSmallRes = CameraConfigurationManager.captureResolutionWidth;
			stillsBigRes = CameraConfigurationManager.captureResolutionHeight;
		}
		if ( CameraConfigurationManager.screenResolution.x > CameraConfigurationManager.screenResolution.y){
			screenBigRes  = CameraConfigurationManager.screenResolution.x;
			screenSmallRes = CameraConfigurationManager.screenResolution.y;
		}
		else{
			screenBigRes  = CameraConfigurationManager.screenResolution.y;
			screenSmallRes = CameraConfigurationManager.screenResolution.x;
		}
		if (CameraManagerController.sessionType != CaptureIntent.SessionType.PORTRAIT){
			screenResolution = new RectF(0, 0, screenBigRes,screenSmallRes);
			videoResolution = new RectF(0, 0,
					videoBigRes, videoSmallRes);
			stillsResolution = new RectF(0, 0, stillsBigRes,stillsSmallRes);
		}
		else{
			screenResolution = new RectF(0, 0, screenSmallRes,screenBigRes);
			videoResolution = new RectF(0, 0,
					videoSmallRes, videoBigRes);
			stillsResolution = new RectF(0, 0, stillsSmallRes,stillsBigRes);

		}
//					else {
//						previewRect= new RectF(0, 0, CameraConfigurationManager.screenResolution.y, CameraConfigurationManager.screenResolution.x);
//						nativeResRect = new RectF(0, 0,
//								CameraConfigurationManager.videoResolutionHeight, CameraConfigurationManager.videoResolutionWidth);
//					}


		// create a matrix which scales coordinates of preview size rectangle
		// into the
		// camera's native resolution.
		if (convertFromScreenToVideo == 1) {
			scaleMatrix.setRectToRect(videoResolution, screenResolution, Matrix.ScaleToFit.FILL);
		}
		else if (convertFromScreenToVideo == 2){
			scaleMatrix.setRectToRect(videoResolution, stillsResolution, Matrix.ScaleToFit.FILL);
		}
		else{
			scaleMatrix.setRectToRect(screenResolution, videoResolution, Matrix.ScaleToFit.FILL);
		}
		float[] rectValues = new float[4];
		float[] srcValues = new float[4];
		srcValues[0] = rectToValidate.x;
		srcValues[1] = rectToValidate.y;
		srcValues[2] = rectToValidate.width;
		srcValues[3] = rectToValidate.height;
		scaleMatrix.mapPoints(rectValues,srcValues);
		org.opencv.core.Rect resultRect = new org.opencv.core.Rect();
		resultRect.x = (int)rectValues[0];
		resultRect.y = (int)rectValues[1];
		resultRect.width = (int)rectValues[2];
		resultRect.height = (int)rectValues[3];

		return resultRect;


	}
	public boolean initOcrManager(int micrType){
		if (micrType!= OCRType.OFF.getId() && micrType!= OCRType.UNKNOWN.getId()){
			return initReadManager(ocrMaskNumbersPath, digitsFileE13BPath, signsFileE13BPath, digitsFileCMC7Path, signsFileCMC7Path, ocrADigits,passportDigits,panCardDigits,micrType);
		}
		return false;
	}
	public boolean initOcrManager(String ocrMaskNumbersPath,String digitsFileE13BPath, String signsFileE13BPath,String digitsFileCMC7Path,String signsFileCMC7Path,String ocrADigits, String mrzFilesLocation, String panDigits,int micrType){
		if (micrType!= OCRType.OFF.getId() && micrType!= OCRType.UNKNOWN.getId()){
			return initReadManager(ocrMaskNumbersPath, digitsFileE13BPath, signsFileE13BPath, digitsFileCMC7Path, signsFileCMC7Path,ocrADigits, mrzFilesLocation,panDigits, micrType);
		}
		return false;
	}



	/**
	 * Read ocr data.
	 *
	 * @param img the img
	 * @param binImg the bin img
	 * @param checkBounds the check bounds
	 * @param videoRect the video rect
	 * @param BoundingBoxVideo the bounding box video
	 * @param micr the micr
	 * @param readOcrFromFullImage the read ocr from full image
	 * @return the OCR result
	 */

	static public int counter_r = 0;

	public OCRResult readOCRData(Mat img,Mat binImg, Rect checkBounds, Rect videoRect,Rect BoundingBoxVideo,int micr,boolean readOcrFromFullImage) {
		try{
			int[] checkBoundsArray = {};
			int[] videoRectArray = {};
			int[] BoundingBoxVideoArray = {};
			long binImage;
			if (checkBounds != null)
				checkBoundsArray = rectToArray(checkBounds);

			if (videoRect != null)
				videoRectArray = rectToArray(videoRect);

			if(BoundingBoxVideo != null){
				BoundingBoxVideoArray = rectToArray(BoundingBoxVideo);

			}
			if (binImg == null){
				binImage = -1;
			}
			else{
				binImage = binImg.getNativeObjAddr();
			}
			if (CameraManagerController.imageType == TISDocumentType.CARD && CameraManagerController.ocrType == OCRType.PAN){
				img =  new Mat(img,checkBounds);
				return readPanCard(mNativeObj, javaNotifier, img.getNativeObjAddr(), binImage, BoundingBoxVideoArray, videoRectArray, micr);

			}
			if (CameraManagerController.imageType == TISDocumentType.CARD && CameraManagerController.ocrType == OCRType.MRZ){
				img =  new Mat(img,checkBounds);
				Mat croppedGray = new Mat();
				Imgproc.cvtColor(img, croppedGray, Imgproc.COLOR_RGB2GRAY);
				Rect MrzStripRect;
				MrzStripRect= new Rect(0, (int) (img.rows() * 0.6), img.cols(), (int) (img.rows() * 0.35));
				croppedGray = new Mat(croppedGray,MrzStripRect);
				return readMRZ(img, croppedGray);
			}

			if (!readOcrFromFullImage)
				try {
					if (img!= null && !img.empty()) {
						return readOCRData(mNativeObj, javaNotifier, img.getNativeObjAddr(), binImage, BoundingBoxVideoArray, videoRectArray, micr);
					}
				}catch (Exception e){
					Logger.e(tag, "OCR data read failed ");
					return  null;
				}
			else
				return readOCRDataFromFullImage(mNativeObj, javaNotifier, img.getNativeObjAddr(), checkBoundsArray, videoRectArray);
		}catch(Exception e){
			Logger.e(tag, "OCR data read failed ");
			return null;
		}
		return null;
	}


	/**
	 * Find check bounding box.
	 *
	 * @param img the img
	 * @param isFront the is front
	 * @param scaleImageToMinimumSize the scale image to minimum size
	 * @return the bounding box result
	 */
	public BoundingBoxResult findCheckBoundingBox(Mat img, boolean isFront, boolean scaleImageToMinimumSize) {
			return findCheckBoundingBox(mNativeObj, javaNotifier, isFront, img.getNativeObjAddr(), scaleImageToMinimumSize);
	}


	public GenericBoundingBoxResult findGenericBoundingBox(Mat img, Mat croppedImageResult) {
		return findGenericBoundingBox(mNativeObj, javaNotifier, img.getNativeObjAddr(), croppedImageResult.getNativeObjAddr(), Imgproc.INTER_NEAREST);

	}





	public OCRResult readPassport(Mat colorImg) {
		return readPassport(mNativeObj, javaNotifier, colorImg.getNativeObjAddr());
	}

	public OCRResult readMRZ(Mat colorImg, Mat grayStrip) {
		return readMRZ(mNativeObj, javaNotifier, colorImg.getNativeObjAddr(), grayStrip.getNativeObjAddr());
	}

	public boolean initReadManager(String ocrMaskNumbersPath,String digitsFileE13B,String signsFileE13B,String digitsFileCMC7,String signsFileCMC7,String OCRADigits, String mrzFilesLocation,String panCardFileLocation,int micr){
		return initReadManager(mNativeObj, javaNotifier, ocrMaskNumbersPath, digitsFileE13B, signsFileE13B, digitsFileCMC7, signsFileCMC7, OCRADigits,mrzFilesLocation,panCardFileLocation, micr);
	}


	/**
	 * Detect blur.
	 *
	 * @param croppedImg the cropped img
	 * @param isDebug the is debug
	 * @param imageType the image type
	 * @param pixelsNumber the pixels number
	 * @param isFront the is front
	 * @return true, if successful
	 */
	public boolean detectBlur(Mat croppedImg,boolean isDebug,int imageType,int pixelsNumber,boolean isFront){
		return detectBlur(mNativeObj, croppedImg.getNativeObjAddr(),isDebug,!CameraManagerController.isStillMode,isFront,imageType,pixelsNumber);
	}

	/**
	 * Bredly binarization.
	 *
	 * @param croppedImg the cropped img
	 * @param outputImg the output img
	 * @param inputPath the input path
	 * @param outputPath the output path
	 * @return true, if successful
	 */
	public boolean BredlyBinarization(Mat croppedImg,Mat outputImg,String inputPath,String outputPath, String model, String make){
		return BredlyBinarization(mNativeObj,javaNotifier, croppedImg.getNativeObjAddr(),outputImg.getNativeObjAddr(),inputPath,outputPath, model, make);
	}


//    (JNIEnv *jenv, jclass,jlong thiz, jobject jNotifier,
//    		jlong incomingImage,jlong grayImage,jlong binResultImg,jstring jOutputPath,jintArray imageCroppedRect ,jboolean isFront)

	public void binarizeWithoutSearchingBoundingBox(Mat incomingImage, Mat grayImage, Mat binResultImg, String pathToSave, String outputTiffPath, int[] array, boolean isFront, String model, String make){
		binarizeWithoutSearchingBoundingBox(mNativeObj,javaNotifier, incomingImage.getNativeObjAddr(),grayImage.getNativeObjAddr(),binResultImg.getNativeObjAddr(),pathToSave,outputTiffPath,array,isFront,model,make);

	}


	/**
	 * Find check bounding box high res image.
	 *
	 * @param img the img
	 * @param aspectRatio the aspect ratio
	 * @param videoRect the video rect
	 * @param checkRect the check rect
	 * @param frontImageRect the front image rect
	 * @param VideoStillAspectW the video still aspect w
	 * @param VideoStillAspectH the video still aspect h
	 * @return the bounding box result
	 */
	public BoundingBoxResult findCheckBoundingBoxHighResImage(Mat img, long aspectRatio, Rect videoRect, Rect checkRect, Rect frontImageRect,double VideoStillAspectW,double VideoStillAspectH) {
		int[] videoArray = rectToArray(videoRect);
		int[] checkArray = rectToArray(checkRect);
		int[] frontImageArray = rectToArray(frontImageRect);
		return findCheckBoundingBoxHighResImage(mNativeObj, javaNotifier, img.getNativeObjAddr(), aspectRatio, videoArray, checkArray, frontImageArray,VideoStillAspectW,VideoStillAspectH);
	}

	/**
	 * Find check bounding box continue anyway.
	 *
	 * @param img the img
	 * @param aspectRatio the aspect ratio
	 * @return the bounding box result
	 */
	public BoundingBoxResult findCheckBoundingBoxContinueAnyway(Mat img, long aspectRatio) {
		return findCheckBoundingBoxAnyway(mNativeObj, javaNotifier, img.getNativeObjAddr(), aspectRatio);
	}


	/**
	 * Creates the asset audio player.
	 *
	 * @param assetManager the asset manager
	 * @param filename the filename
	 * @return true, if successful
	 */
//	public boolean createAssetAudioPlayer(AssetManager assetManager, String filename){
//		return createAssetAudioPlayer(mNativeObj, assetManager, filename);
//	}


	/**
	 * Checks if is valid contrast.
	 *
	 * @param img the img
	 * @return true, if is valid contrast
	 */
	public boolean isValidContrast(Mat img) {
		return isValidContrast(mNativeObj, img.getNativeObjAddr());
	}

	/**
	 * Prepare current image for sending.
	 *
	 * @param img the img
	 * @param timestamp the timestamp
	 * @param inputImagePath the input image path
	 * @param videoRect the video rect
	 * @param checkRect the check rect
	 * @param orientation the orientation
	 * @param isFront the is front
	 * @param frontImageSize the front image size
	 * @param isSendImageAsIs the is send image as is
	 * @param meanDigitHeight the mean digit height
	 * @param doOcr the do ocr
	 * @param imageType the image type
	 * @param originalImageSize the original image size
	 * @param imageAligment the image aligment
	 * @param make
	 * @return the image session result
	 */
	public ImageSessionResult prepareCurrentImageForSending(Mat img, Mat outputCroppedImg, int timestamp, String inputImagePath, Rect videoRect, Rect checkRect, double orientation, boolean isFront,
															Rect frontImageSize, boolean isSendImageAsIs, int meanDigitHeight, boolean doOcr, int imageType, int originalImageSize, boolean imageAligment, boolean filterByAspect,
															float[] cropCoordinates, String model, String make) {
		//Calendar c = Calendar.getInstance();
		int[] videoArray = rectToArray(videoRect);
		int[] checkArray = rectToArray(checkRect);
		int[] frontImageArray = rectToArray(frontImageSize);

		CameraController.processStart = true;

		if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE){
			if (CameraConfigurationManager.videoResolutionWidth
					>  CameraConfigurationManager.videoResolutionHeight){
				int tmp = CameraConfigurationManager.videoResolutionWidth;
				CameraConfigurationManager.videoResolutionWidth = CameraConfigurationManager.videoResolutionHeight;
				CameraConfigurationManager.videoResolutionHeight = tmp;
			}
			if (CameraConfigurationManager.captureResolutionWidth >  CameraConfigurationManager.captureResolutionHeight){
				int tmp = (int) CameraConfigurationManager.captureResolutionWidth;
				CameraConfigurationManager.captureResolutionWidth = CameraConfigurationManager.captureResolutionHeight;
				CameraConfigurationManager.captureResolutionHeight = tmp;
			}

		}
		OCRHelper.scaleWidth = (float)CameraConfigurationManager.captureResolutionWidth/(float)CameraConfigurationManager.videoResolutionWidth;
		if (!CameraManagerController.isStillMode){
			OCRHelper.scaleWidth  = OCRHelper.scaleHeight = 1;
		}

		if (!isFront){
			CameraManagerController.binarizationType = Constants.TIS_GENERAL_BINARIZATION;
		}


		final String outputImagePath = inputImagePath.replace(".jpg", ".tiff");
		Imgproc.cvtColor(img, img, Imgproc.COLOR_BGR2RGBA);
		//org.opencv.core.Rect scaledImageRect = MobiCHECKOCR.convertRectToCorrectAspectRatio(CameraManagerController.getOcrAnalyzeSession(CameraController.getInstance()).checkRect,2);
		ImageSessionResult result = prepareCurrentImageForSending(mNativeObj, javaNotifier, img.getNativeObjAddr(), outputCroppedImg.getNativeObjAddr(), timestamp, inputImagePath, outputImagePath, videoArray, checkArray,
				orientation, isFront, frontImageArray, isSendImageAsIs, meanDigitHeight,OCRHelper.scaleWidth,OCRHelper.scaleHeight,doOcr,imageType,originalImageSize,imageAligment,filterByAspect,CameraManagerController.binarizationType,CameraManagerController.binarizationThreshold, cropCoordinates,CameraController.getInstance().captureButtonPressed,!CameraManagerController.isStillMode,model, make);

		if (result.width == 0){
			Logger.e(tag, "result.width == 0");
		}
		if (isFront) {
			SessionResultParams.tiffFront = FileUtils.getByteArray(outputImagePath);
			SessionResultParams.jpegBWFront = FileUtils.getByteArray(inputImagePath);

		}
		else {
			SessionResultParams.tiffBack = FileUtils.getByteArray(outputImagePath);
			SessionResultParams.jpegBWBack = FileUtils.getByteArray(inputImagePath);
		}
		FileUtils.deleteFile(outputImagePath); // delete Tiff Black and white
		FileUtils.deleteFile(inputImagePath);

		if (result != null) {
			result.errorCodeId = result.errorCodeId;
			result.errorMessage = result.errorMessage;
		}
		result.mat = img;

		Logger.d(tag, "end time" +  "_" +  FileUtils.getCurrentTime());
		return result;


	}




	/**
	 * Jpeg to tiff.
	 *
	 * @param inputPath the input path
	 * @return the TIFF result
	 */
	public String jpegToTiff(String inputPath, String model, String make) {
		String outputPath = inputPath.replace(".jpg", ".tiff");
		// String outputPath = FileUtils.getTempImagePath(context,
		// "temp_tiff_result.tiff");
		boolean success = jpegToTiff(mNativeObj, javaNotifier, inputPath, outputPath, model, make);
//		JNIResultBase result = jpegToTiff(mNativeObj, javaNotifier, inputPath, outputPath);
//		TIFFResult imageResult = new TIFFResult();
//		if (result != null) {
//			imageResult.errorCodeId = result.errorCodeId;
//			imageResult.errorMessage = result.errorMessage;
//		}
//		imageResult.data = FileUtils.getByteArray(outputPath);
//		// FileUtils.deleteFile(outputPath);
//		imageResult.filePath = outputPath;
//		return imageResult;

		if (success)
			return outputPath;

		return null;

	}

	/**
	 * Tiff to jpeg.
	 *
	 * @param data the data
	 * @return the string
	 */
	public String tiffToJpeg(byte[] data) {

		String result = tiffToJpeg(mNativeObj, data);
		return result;
	}

	/**
	 * Rect to array.
	 *
	 * @param rect the rect
	 * @return the int[]
	 */
	private int[] rectToArray(Rect rect) {
		if (rect == null) {
			return new int[] {};
		} else {
			return new int[] { rect.x, rect.y, rect.width, rect.height };
		}
	}

	/**
	 * Replace width and height.
	 *
	 * @param rect the rect
	 * @return the int[]
	 */
	private int[] replaceWidthAndHeight(Rect rect){

		if (rect == null) {
			return new int[] {};
		} else {
			return new int[]  { rect.y, rect.x, rect.height, rect.width };
		}
	}


	/**
	 * Release.
	 */
	public void release() {
		try {
			nativeDestroyObject(mNativeObj);
		} catch (Exception e) {
			Logger.e(tag, e.getMessage());
		}
		mNativeObj = 0;
	}

	/**
	 * Abort.
	 */
	public void abort() {
		Logger.e(tag, "abort is called !");
	}

	/**
	 * Native crashed.
	 */
	void nativeCrashed() {
		new RuntimeException("crashed here (native trace should follow after the Java trace)").printStackTrace();
	}

	/**
	 * Gets the stack trace.
	 *
	 * @param t the t
	 * @return the stack trace
	 */
	String getStackTrace(Throwable t) {
		ByteArrayOutputStream b = new ByteArrayOutputStream();
		t.printStackTrace(new PrintStream(b, true));
		return b.toString();
	}

	/**
	 * Prepare images.
	 */
	public void prepareImages() {

	}

	/**
	 * Crash me harder.
	 */
	native void crashMeHarder();

	/**
	 * Native create object.
	 *
	 * @param isDebug the is debug
	 * @param micrType the micr type
	 * @param digitsFileE13B the digits file e13 b
	 * @param signsFileE13B the signs file e13 b
	 * @param digitsFileCMC7 the digits file cm c7
	 * @param signsFileCMC7 the signs file cm c7
	 * @param ocrMaskNumbersPath the ocr mask numbers path
	 * @param digitalRowDelimiter the digital row delimiter
	 * @param blurResources the blur resources
	 * @param minRatioHW the min ratio hw
	 * @param maxRatioHW the max ratio hw
	 * @param maxImageWidth the max image width
	 * @param minImageWidth the min image width
	 * @param maxImageHeight the max image height
	 * @param minImageHeight the min image height
	 * @param isUseCustomAlgorithm the is use custom algorithm
	 * @param isBinarizeBakSameAsFront the is binarize bak same as front
	 * @param outputHeightInInch the output height in inch
	 * @param outputWidthInInch the output width in inch
	 * @param minRatioHWBack the min ratio hw back
	 * @param maxRatioHWBack the max ratio hw back
	 * @param isIQAEnabled the is iqa enabled
	 * @param iqaSettings the iqa settings
	 * @param isBlurEnabled the is blur enabled
	 * @return the long
	 */
	private static native long nativeCreateObject(boolean isDebug, int micrType, String digitsFileE13B, String signsFileE13B, String digitsFileCMC7, String signsFileCMC7,
												  String ocrMaskNumbersPath, String digitalRowDelimiter,String blurResources, float minRatioHW, float maxRatioHW, float maxImageWidth, float minImageWidth, float maxImageHeight,
												  float minImageHeight, boolean isUseCustomAlgorithm, boolean isBinarizeBakSameAsFront, float outputHeightInInch, float outputWidthInInch, float minRatioHWBack,
												  float maxRatioHWBack, boolean isIQAEnabled, IQASettingsIntent iqaSettings, boolean isBlurEnabled,int documentType, String loggerPath);

	/**
	 * Native destroy object.
	 *
	 * @param thiz the thiz
	 * @return true, if successful
	 */
	private static native boolean nativeDestroyObject(long thiz);

	/**
	 * Sets the validation check rect.
	 *
	 * @param mNativeObj the m native obj
	 * @param validCheckBoundariesRectArray the valid check boundaries rect array
	 * @param minCheckBoundariesRectArray the min check boundaries rect array
	 * @param validCheckBoundariesRectBackArray the valid check boundaries rect back array
	 * @param minCheckBoundariesRectBackArray the min check boundaries rect back array
	 */
	private static native void setValidationCheckRect(long mNativeObj, int[] validCheckBoundariesRectArray, int[] minCheckBoundariesRectArray,
													  int[] validCheckBoundariesRectBackArray, int[] minCheckBoundariesRectBackArray);

	/**
	 * Find check bounding box.
	 *
	 * @param thiz the thiz
	 * @param javaNotifier the java notifier
	 * @param isFront the is front
	 * @param iputImage the iput image
	 * @param scaleImageToMinimumSize the scale image to minimum size
	 * @return the bounding box result
	 */
	private static native BoundingBoxResult findCheckBoundingBox(long thiz, JavaNotifier javaNotifier, boolean isFront, long iputImage, boolean scaleImageToMinimumSize);

	/**
	 * Find check bounding box high res image.
	 *
	 * @param thiz the thiz
	 * @param javaNotifier the java notifier
	 * @param iputImage the iput image
	 * @param ratio the ratio
	 * @param videoRect the video rect
	 * @param checkRect the check rect
	 * @param frontImageSize the front image size
	 * @param scaleWidth the scale width
	 * @param scaleHeight the scale height
	 * @return the bounding box result
	 */

	private static native GenericBoundingBoxResult findGenericBoundingBox(long thiz, JavaNotifier javaNotifier, long iputImage,long outputImage,int interpolationFunc);


	private static native BoundingBoxResult findCheckBoundingBoxHighResImage(long thiz, JavaNotifier javaNotifier, long iputImage, long ratio, int[] videoRect, int[] checkRect,
																			 int[] frontImageSize ,double scaleWidth, double scaleHeight);

	/**
	 * Find check bounding box anyway.
	 *
	 * @param thiz the thiz
	 * @param javaNotifier the java notifier
	 * @param iputImage the iput image
	 * @param ratio the ratio
	 * @return the bounding box result
	 */
	private static native BoundingBoxResult findCheckBoundingBoxAnyway(long thiz, JavaNotifier javaNotifier, long iputImage, long ratio);

	/**
	 * Creates the asset audio player.
	 *
	 * @param thiz the thiz
	 * @param assetManager the asset manager
	 * @param filename the filename
	 * @return true, if successful
	 */
//	private static native boolean createAssetAudioPlayer(long thiz, AssetManager assetManager, String filename);

	private static native OCRResult readPassport(long thiz, JavaNotifier javaNotifier, long coloredIputImage);
	private static native OCRResult readMRZ(long thiz, JavaNotifier javaNotifier, long coloredIputImage,long grayStripImg);
	private static native OCRResult readPanCard(long thiz, JavaNotifier javaNotifier, long inputImage,  long inputBinImage,int[] checkBounds, int[] videoBounds, int micr);

//  (JNIEnv *jenv, jclass, jlong thiz,
//	 jlong img_cropped,jboolean isDebug,jboolean isVideo,jboolean isFront,jint imageType,jint pixelNumber)


	/**
	 * Detect blur.
	 *
	 * @param thiz the thiz
	 * @param iputImage the iput image
	 * @param isDebug the is debug
	 * @param isVideo the is video
	 * @param isFront the is front
	 * @param imageType the image type
	 * @param pixelsNumber the pixels number
	 * @return true, if successful
	 */
	private static native boolean detectBlur(long thiz, long iputImage, boolean isDebug,boolean isVideo,boolean isFront,int imageType,int pixelsNumber);



	private static native boolean initReadManager(long thiz, JavaNotifier javaNotifier,String ocrMaskNumbersPath, String digitsFileE13B,String signsFileE13B,String digitsFileCMC7,String signsFileCMC7,String digitsOCRA,String mrzFilesLocation,String panFileLocation,int micr);

	/**
	 * Bredly binarization.
	 *
	 * @param thiz the thiz
	 * @param javaNotifier the java notifier
	 * @param inputImg the input img
	 * @param outputImg the output img
	 * @param inputPath the input path
	 * @param outputPath the output path
	 * @return true, if successful
	 */
	private static native boolean BredlyBinarization(long thiz, JavaNotifier javaNotifier, long inputImg,long outputImg,String inputPath,String outputPath, String model, String make);


	/**
	 * Read ocr data.
	 *
	 * @param thiz the thiz
	 * @param javaNotifier the java notifier
	 * @param inputImage the input image
	 * @param inputBinImage the input bin image
	 * @param checkBounds the check bounds
	 * @param videoBounds the video bounds
	 * @param micr the micr
	 * @return the OCR result
	 */
	private static native OCRResult readOCRData(long thiz, JavaNotifier javaNotifier, long inputImage,  long inputBinImage,int[] checkBounds, int[] videoBounds, int micr);

	/**
	 * Read ocr data from full image.
	 *
	 * @param thiz the thiz
	 * @param javaNotifier the java notifier
	 * @param inputImage the input image
	 * @param checkBounds the check bounds
	 * @param videoBounds the video bounds
	 * @return the OCR result
	 */
	private static native OCRResult readOCRDataFromFullImage(long thiz, JavaNotifier javaNotifier, long inputImage, int[] checkBounds, int[] videoBounds);


	private static native void binarizeWithoutSearchingBoundingBox(long thiz, JavaNotifier javaNotifier, long inputImage, long grayImage, long binResultImg, String path, String tiffPath, int[] rectArr, boolean isFront, String model, String make);

	/**
	 * Checks if is valid contrast.
	 *
	 * @param thiz the thiz
	 * @param inputImage the input image
	 * @return true, if is valid contrast
	 */
	private static native boolean isValidContrast(long thiz, long inputImage);

	/**
	 * Prepare current image for sending.
	 *
	 * @param thiz the thiz
	 * @param javaNotifier the java notifier
	 * @param inputImage the input image
	 * @param timestamp the timestamp
	 * @param inputImagePath the input image path
	 * @param outputImagePath the output image path
	 * @param videoRect the video rect
	 * @param checkRect the check rect
	 * @param orientation the orientation
	 * @param isFront the is front
	 * @param frontImageSize the front image size
	 * @param isSendImageAsIs the is send image as is
	 * @param meanDigitHeight the mean digit height
	 * @param scaleWidth the scale width
	 * @param scaleHeight the scale height
	 * @param doOcr the do ocr
	 * @param imageType the image type
	 * @param originalImageSize the original image size
	 * @param imageAligment the image aligment
	 * @param make
	 * @return the image session result
	 */
	private static native ImageSessionResult prepareCurrentImageForSending(long thiz, JavaNotifier javaNotifier, long inputImage, long outputCroppedImage, int timestamp, String inputImagePath,
																		   String outputImagePath, int[] videoRect, int[] checkRect, double orientation, boolean isFront, int[] frontImageSize, boolean isSendImageAsIs, int meanDigitHeight, double scaleWidth, double scaleHeight, boolean doOcr, int imageType, int originalImageSize, boolean imageAligment,
																		   boolean filterByAspect, int binariztionType, float binarizationTrashold, float[] coords,boolean manualCapturePressed,boolean isVideoProcessing, String modelName, String make);

	/**
	 * Jpeg to tiff.
	 *
	 * @param thiz the thiz
	 * @param inputPath the input path
	 * @param outputPath the output path
	 * @return the TIFF result
	 */
	private static native boolean jpegToTiff(long thiz, JavaNotifier javaNotifier, String inputPath, String outputPath, String model, String make);


	/**
	 * Tiff to jpeg.
	 *
	 * @param thiz the thiz
	 * @param data the data
	 * @return the string
	 */
	private static native String tiffToJpeg(long thiz, byte[] data);



}