/*
 * 
 */
package com.topimagesystems.micr;

import android.os.Parcel;
import android.os.Parcelable;

import org.opencv.core.Rect;

// TODO: Auto-generated Javadoc
/**
 * BoundingBoxResult.java
 * 
 * Created by Elad Mobile on 01/08/2012
 * 
 * @author Danny Polonsky
 * 
 */
public class GenericBoundingBoxResult extends JNIResultBase implements Parcelable{
	
	/** The height. */
	public int x, y, width, height;
	public float topLeftX, topLeftY, topRightX, topRightY,bottomLeftX, bottomLeftY, bottomRightX, bottomRightY;
	/** The orientation. */
	public double orientation;

	/** The size indicator. */
	public int sizeIndicator;
	
	/**
	 * Instantiates a new bounding box result.
	 */
	public GenericBoundingBoxResult() {
		super();
	}

	protected GenericBoundingBoxResult(Parcel in) {
		x = in.readInt();
		y = in.readInt();
		width = in.readInt();
		height = in.readInt();
		topLeftX = in.readFloat();
		topLeftY = in.readFloat();
		topRightX = in.readFloat();
		topRightY = in.readFloat();
		bottomLeftX = in.readFloat();
		bottomLeftY = in.readFloat();
		bottomRightX = in.readFloat();
		bottomRightY = in.readFloat();
		orientation = in.readDouble();
		sizeIndicator = in.readInt();
	}

	public GenericBoundingBoxResult clone(){
		GenericBoundingBoxResult gbbr = new GenericBoundingBoxResult();
		gbbr.x = x;
		gbbr.y = y;
		gbbr.width = width;
		gbbr.height = height;
		gbbr.topLeftX = topLeftX;
		gbbr.topLeftY = topLeftY;
		gbbr.topRightX = topRightX;
		gbbr.topRightY = topRightY;
		gbbr.bottomLeftX = bottomLeftX;
		gbbr.bottomLeftY = bottomLeftY;
		gbbr.bottomRightX = bottomRightX;
		gbbr.bottomRightY = bottomRightY;
		gbbr.orientation = orientation;
		gbbr.sizeIndicator = sizeIndicator;

		return gbbr;
	}
	/**
	 * Gets the rect.
	 *
	 * @return the rect
	 */
	public Rect getRect() {
		return new Rect(x, y, width, height);
	}
	
	/**
	 * Sets the rect.
	 *
	 * @param x the x
	 * @param y the y
	 * @param width the width
	 * @param height the height
	 */
	public void setRect(int x, int y,int width,int height) {
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}
	

	/* (non-Javadoc)
	 * @see com.topimagesystems.micr.JNIResultBase#toString()
	 */
	@Override
	public String toString() {
		return "GenericBoundingBoxResult [" + super.toString() +
				" [x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + "]" +
				" [topLeft=" + topLeftX + "," + topLeftY + " topRight=" + topRightX + "," + topRightY +
				" bottomLeft=" + bottomLeftX + "," + bottomLeftY + " bottomRight=" + bottomRightX + "," + bottomRightY + "]]";
	}

	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(x);
		dest.writeInt(y);
		dest.writeInt(width);
		dest.writeInt(height);
		dest.writeFloat(topLeftX);
		dest.writeFloat(topLeftY);
		dest.writeFloat(topRightX);
		dest.writeFloat(topRightY);
		dest.writeFloat(bottomLeftX);
		dest.writeFloat(bottomLeftY);
		dest.writeFloat(bottomRightX);
		dest.writeFloat(bottomRightY);
		dest.writeDouble(orientation);
		dest.writeInt(sizeIndicator);
	}

	public class quadPoint{
		
		int x;
		int y;		
	}




	public static final Creator<GenericBoundingBoxResult> CREATOR = new Creator<GenericBoundingBoxResult>() {
		@Override
		public GenericBoundingBoxResult createFromParcel(Parcel in) {
			return new GenericBoundingBoxResult(in);
		}

		@Override
		public GenericBoundingBoxResult[] newArray(int size) {
			return new GenericBoundingBoxResult[size];
		}
	};


}