/*
 * 
 */
package com.topimagesystems.data;

import com.topimagesystems.Common.OCRType;

import android.os.Parcel;
import android.os.Parcelable;




// TODO: Auto-generated Javadoc
/**
 * The Class SessionInputParams.
 */
public class SessionInputParams implements Parcelable {

	/** The micr type. */
	public OCRType micrType = OCRType.E_138B;
	
	/** The max number of retires. */
	public int maxNumberOfRetires = 5;
	
	/** The min ratio hw. */
	public float minRatioHW = 0.35f;
	
	/** The max ratio hw. */
	public float maxRatioHW = 0.65f;
	
	/** The is iqa enabled. */
	public boolean isIQAEnabled = false;
	
	/** The is debug. */
	public boolean isDebug = false;
	
	/** The scan front only. */
	public boolean scanFrontOnly = false;
	
	/** The info screen enable. */
	public boolean infoScreenEnable = true;
	
	/** The is manual capture. */
	public boolean isManualCapture = false;
	
	/** The is use custom algorithm on back. */
	public boolean isUseCustomAlgorithmOnBack = false;
	
	/** The is back binarization as front. */
	public boolean isBackBinarizationAsFront = false;
	
	/** The output height in inch. */
	public float outputHeightInInch = -1f;
	
	/** The output width in inch. */
	public float outputWidthInInch = -1f;
	
	/** The min ratio hw back. */
	public float minRatioHWBack = -1f;
	
	/** The max ratio hw back. */
	public float maxRatioHWBack = -1f;
	
	/** The txt valid from. */
	public int txtValidFrom = 10;
	
	/** The txt valid to. */
	public int txtValidTo = 50;

	/** The info screen interval. */
	public long infoScreenInterval = 10000;
	
	/** The boolean inupts array. */
	private boolean[] booleanInuptsArray;
	
	/**
	 * Instantiates a new session input params.
	 */
	public SessionInputParams(){
		booleanInuptsArray = new boolean[7];
		booleanInuptsArray[0] = isIQAEnabled;
		booleanInuptsArray[1] = isDebug;
		booleanInuptsArray[2] = scanFrontOnly;
		booleanInuptsArray[3] = infoScreenEnable;
		booleanInuptsArray[4] = isManualCapture;
		booleanInuptsArray[5] = isUseCustomAlgorithmOnBack;
		booleanInuptsArray[6] = isBackBinarizationAsFront;
	}
	
	/* (non-Javadoc)
	 * @see android.os.Parcelable#writeToParcel(android.os.Parcel, int)
	 */
	@Override
	public void writeToParcel(Parcel dest, int flags) {
	//	dest.writeParcelable(micrType, flags);
		dest.writeInt(maxNumberOfRetires);
		dest.writeFloat(minRatioHW);
		dest.writeBooleanArray(booleanInuptsArray);
		dest.writeFloat(outputHeightInInch);
		dest.writeFloat(outputWidthInInch);
		dest.writeFloat(minRatioHWBack);
		dest.writeFloat(maxRatioHWBack);
		dest.writeInt(txtValidFrom);
		dest.writeInt(txtValidTo);
	}



	/**
	 * Instantiates a new session input params.
	 *
	 * @param in the in
	 */
	public SessionInputParams(Parcel in) {
		readFromParcel(in);
	}

	/**
	 * Read from parcel.
	 *
	 * @param in the in
	 */
	private void readFromParcel(Parcel in) {				
		this.micrType = in.readParcelable(OCRType.class.getClassLoader());
		this.maxNumberOfRetires = in.readInt();
		this.minRatioHW = in.readFloat();
		this.booleanInuptsArray = in.createBooleanArray();
		this.outputHeightInInch = in.readFloat();	
		this.outputWidthInInch = in.readFloat();
		this.minRatioHWBack = in.readFloat();
		this.maxRatioHWBack = in.readFloat();
		this.txtValidFrom = in.readInt();
		this.txtValidTo = in.readInt();	
	}

	/* (non-Javadoc)
	 * @see android.os.Parcelable#describeContents()
	 */
	@Override
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}
}
