/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import com.topimagesystems.Common;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.OCRAnalyzeErrorCode;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent.SessionType;
import com.topimagesystems.intent.CaptureIntent.TISDocumentType;
import com.topimagesystems.micr.BoundingBoxResult;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.micr.ImageSessionResult;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.micr.OCRCommon.ErrorCode;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.OcrValidationUtils;
import com.topimagesystems.util.StringUtils;
import com.topimagesystems.util.UserInterfaceUtils;

import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

import java.util.ArrayList;

import static com.topimagesystems.controllers.imageanalyze.CameraManagerController.enableCroppingController;
import static com.topimagesystems.controllers.imageanalyze.CameraManagerController.getOcrAnalyzeSession;
import static com.topimagesystems.controllers.imageanalyze.CameraManagerController.imageType;


//import android.hardware.camera2.CameraManager;

// TODO: Auto-generated Javadoc
/**
 * The Class ProcessStillImageThread.
 */
/**
 * @author Boaz.Garty
 *
 */
/** @author Boaz.Garty */
public class ProcessStillImageThread extends Thread {

	/** The Constant tag. */
	private final static String tag = Logger.makeLogTag("ProcessStillImageThread");
	//
	/** The camera session manager. */
	private CameraSessionManager cameraSessionManager;

	/** The mobi checkocr. */
	private MobiCHECKOCR mobiCHECKOCR;

	/** The handler. */
	private Handler handler;

	/** The context. */
	private Context context;

	/** The timestamp. */
	private int timestamp;

	/** The display width. */
	private int displayWidth;

	/** The ocr data. */
	private OCRResult ocrData;

	/** The rect. */
	private BoundingBoxResult rect;

	/** The video rect. */
	private Rect videoRect;

	/** The is front capture. */
	private boolean isFrontCapture;

	/** The is micr type off. */
	private boolean foundMicrOnBackSide;
	private long lastFocusRequestTime;
	/** The image result. */
	private ImageSessionResult imageResult = null;
	private Rect adjustedCheckRect;
	private Mat[] images;
	private final int MAX_BLUR_RECTS_FRONT = 1;
	private final int MAX_BLUR_RECTS_BACK = 2;
	private  Mat currentMat = null;
	/**
	 * Instantiates a new process still image thread.
	 *
	 * @param context the context
	 * @param handler the handler
	 * @param mobiCHECKOCR the mobi checkocr
	 * @param isDebug the is debug
	 * @param timestamp the timestamp
	 */
	public ProcessStillImageThread(Context context, Handler handler, MobiCHECKOCR mobiCHECKOCR, boolean isDebug, int timestamp) {
		this.handler = handler;
		this.mobiCHECKOCR = mobiCHECKOCR;
		this.context = context;
		this.cameraSessionManager = CameraSessionManager.getInstance();
		this.timestamp = timestamp;
		images = new Mat[1];

	}

	/* (non-Javadoc)
	 * @see java.lang.Thread#run()
	 */
	@Override
	public void run() {
		try {
			if (PreviewCallback.processingVideo)
				return;
			PreviewCallback.processingVideo = true;
			foundMicrOnBackSide = false;

			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("process time starts ", FileUtils.getCurrentTime(), context);
			}
			String currentDateAndTime = FileUtils.getCurrentTime();
			Logger.d(tag, "starting time" + currentDateAndTime, null);
			// javaBinar( CameraManagerController.getOcrAnalyzeSession(context).getCurrentMat(context));
			if (CameraManagerController.sessionType != SessionType.TEST) {
				//displayWidth = CameraSessionManager.getInstance().getScreenResolution().x;
				displayWidth = UserInterfaceUtils.getDisplayDimensions(context).x;
			} else {
				displayWidth = 1280;
			}

			OCRResult result = new OCRResult();


			isFrontCapture = getOcrAnalyzeSession(context).captureMode == CaptureMode.FRONT && !CameraManagerController.scanBackOnly;
			if (cameraSessionManager.getVideoRect() == null || CameraController.doOcrOnly || CameraManagerController.sessionType == SessionType.TEST) {
				videoRect = CameraConfigurationManager.getVideoRect();
			} else {
				videoRect = cameraSessionManager.getVideoRect();
			}

			getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.NONE;
			try {
				try {
					currentMat = getOcrAnalyzeSession(context).getCurrentMat(context, false, !enableCroppingController);
					if (currentMat == null){
						final Message message = handler.obtainMessage(CameraTypes.MESSAGE_ERROR);
						handler.sendMessage(message);
						Logger.e(tag, "out of memory while intializing Mat");
					}
					RawImagesFlowManager.handleDebugMat(currentMat);
					//FileUtils.storeByteArrayImageInTempFolder(context, b, "saveMyStill", true);
					if (RawImagesFlowManager.isSaveMode())
						RawImagesFlowManager._instance.handleSave(currentMat, true);

					//currentMat = new Mat();

				} catch (OutOfMemoryError e) {
					final Message message = handler.obtainMessage(CameraTypes.MESSAGE_ERROR);
					handler.sendMessage(message);
					Logger.e(tag, "out of memory while intializing Mat", e);
					return;
				}

		//		adjustedCheckRect = MobiCHECKOCR.convertRectToCorrectAspectRatio(CameraManagerController.getOcrAnalyzeSession(context).getVideoBoundingBox(),2);

				if (getOcrAnalyzeSession(context).getStillsBoundingBox() != null)
					adjustedCheckRect = getOcrAnalyzeSession(context).getStillsBoundingBox().clone();
				/*else if (getOcrAnalyzeSession(context).isManualCapture)
					adjustedCheckRect = findRectOnStills(currentMat);*/
				else if (!CameraManagerController.invertedCamera)
					adjustedCheckRect = OCRHelper.calculateVideoStillMatRatio(getOcrAnalyzeSession(context).checkRect, currentMat, displayWidth,
							getOcrAnalyzeSession(context).getVideoMat());
				else if (getOcrAnalyzeSession(context).getVideoBoundingBox() != null && getOcrAnalyzeSession(context).getVideoBoundingBox().width > 0)
					adjustedCheckRect = MobiCHECKOCR.convertRectToCorrectAspectRatio(getOcrAnalyzeSession(context).getVideoBoundingBox(), 2);

				CameraController.processStart = true;
				CameraController.getInstance().cancelInfoScreen();
			// for bills we use SVM based Blur detection.

				switch (getOcrAnalyzeSession(context).captureMode) {

					case FRONT:
						if (CameraManagerController.isBlurEnabled && CameraManagerController.imageType != TISDocumentType.PAYMENT) {
							if(perfromBlurOnImage())
								break;
						}
						Logger.i(tag, "ocrResult:" + "ocr currentImage number is " + CameraController.currentImage);

						// don't do binarization flow read OCR only and create wanted images.
						if (!CameraManagerController.shouldOutputBWImage) { // flow with no bin image
							result = startNoBinarizationFlow(currentMat, adjustedCheckRect);
							break;
						}
						// need to change the condition later add variable to perform
						else if (!CameraManagerController.isStillMode && CameraManagerController.doOcrOnImage) { // don't do ocr before binarization
							// decide
							result = performOcrBeforeBinarization(currentMat, adjustedCheckRect); // do Ocr before binariztion

						} else { // normal flow get MICR result from the bin image
							result.isValidRead = prepareImageForServer(currentMat, timestamp, adjustedCheckRect, 0).imageResult;
						}
						if (!CameraManagerController.isStillMode && !result.isValidRead) { // got error add to error counter
							CameraManagerController.falseRecognitionVideoFrames++;
						}
						CameraController.processStart = false;
						break;
					case BACK:
						// ugly duplication change it later, can be dangerous changing here.
						if (CameraManagerController.isBlurOnBackEnabled) {
							if(perfromBlurOnImage())
								break;
						}
						OCRResult micrOnBack = null;

						boolean scanMicrOnBack = CameraManagerController.imageType == TISDocumentType.CHECK && CameraManagerController.doOcrOnImage;
						if (scanMicrOnBack && currentMat != null) {
							micrOnBack = mobiCHECKOCR.readOCRData(currentMat, null, adjustedCheckRect, cameraSessionManager.getVideoRect(),
									getOcrAnalyzeSession(context).checkRect, getOcrAnalyzeSession(context).currentMICRType.getId(), true);
							if (micrOnBack.digitalRowLength > 0 && micrOnBack.ocrRawResult.length() > 1) { // read MICR on back.
								getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.TISFlowErrorMicrOnBack;
								getOcrAnalyzeSession(context).ocrErrorCode = OCRCommon.ErrorCode.errorMICRDetectedOnCheckBack;
								result.isValidRead = false;
								foundMicrOnBackSide = true;
								break;
							}

						}

						if (CameraManagerController.shouldOutputBWImage) {
							result.isValidRead = prepareImageForServer(currentMat, timestamp, adjustedCheckRect, 0).imageResult;
						} else {
							result = startNoBinarizationFlow(currentMat, adjustedCheckRect);
						}
						if (!CameraManagerController.isStillMode && !result.isValidRead) { // got error add to error counter
							CameraManagerController.falseRecognitionVideoFrames++;
						}

						CameraController.processStart = false;
					default:
						break;

				}
			} catch (Exception e) {
				if (getOcrAnalyzeSession(context) != null) {
					getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE;
					if (e != null && e.getMessage() != null && e.getMessage().contains("readOCRData")) {
						getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.ERROR_MICR_LENGTH;
					}
					if (!CameraManagerController.isStillMode) {
						CameraManagerController.falseRecognitionVideoFrames++;
					}
					CameraController.processStart = false;
				}

				Logger.e(tag, "processCapturedImage:" + (e != null ? e.getMessage() : "null Exception"));
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("ProcessStillImageThread", "OCR read Exception!!!", context);
				}
			} finally {
				if (currentMat != null) {
					currentMat.release();
					currentMat = null;
				}
				CameraController.processStart = false;
				CameraController.getInstance().captureButtonPressed = false;
			}
			if (handler == null){
				handler = new CameraController.CameraActivityHandler(CameraController.getInstance(), true);
			}
			Message message = handler.obtainMessage(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT);
			if (result == null){
				message = handler.obtainMessage(CameraTypes.MESSAGE_PROCESS_NOT_VALID);
				message.obj = result;
				message.sendToTarget();
				return;

			}
			if (CameraManagerController.doOcrOnImage && result!= null && result.isValidRead) {
				switch (CameraManagerController.imageType) {
					case CHECK:
						if (isFrontCapture && checkOcrResult()) {
							message = handler.obtainMessage(CameraTypes.CHECK_MICR_RESULT);
						} else if (!foundMicrOnBackSide) {
							// MICR not found
							//s5 slow focus wait 3 sec
							if (FileUtils.isSamsungS5()) {
								long currentTime = System.currentTimeMillis();
								long estimatedTime = currentTime - lastFocusRequestTime;
								if (estimatedTime >= 5000) {
									if (handler == null){
										handler = new CameraController.CameraActivityHandler(CameraController.getInstance(), true);
									}
									CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, CameraTypes.MESSAGE_AUTO_FOCUS);
									lastFocusRequestTime = System.currentTimeMillis();
								}
							} else {
								CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, CameraTypes.MESSAGE_AUTO_FOCUS);
							}
						}
						break;
					case PASSPORT:
						message = handler.obtainMessage(CameraTypes.PASSPORT_RESULT);
						break;
					case CARD:
						if (isFrontCapture) {
							if(CameraManagerController.ocrType == Common.OCRType.PAN) {
								message = handler.obtainMessage(CameraTypes.PAN_CARD_RESULT);
							}
							else if(CameraManagerController.ocrType == Common.OCRType.MRZ) {
								message = handler.obtainMessage(CameraTypes.ID_CARD_RESULT);
							}
							break;
						}
					default:
						break;

				}

			}
			if (!result.isValidRead && CameraManagerController.sessionType != SessionType.TEST && !CameraController.backPressed) {
				CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, CameraTypes.MESSAGE_AUTO_FOCUS);
			}

			if (!result.isValidRead) {
					String errorString = "analyzeErrorCode("+CameraManagerController.getOcrAnalyzeSession(context).analyzeErrorCode.toString()+")";
					if (CameraManagerController.getOcrAnalyzeSession(context).ocrErrorMessage != null)
						errorString += " ocrErrorMessage("+CameraManagerController.getOcrAnalyzeSession(context).ocrErrorMessage+")";
					if (CameraManagerController.getOcrAnalyzeSession(context).ocrErrorCode != null)
						errorString += " ocrErrorCode("+CameraManagerController.getOcrAnalyzeSession(context).ocrErrorCode+")";


					FileUtils.addToLogFile("FAIL_IMAGE_SESSION_RESULT", errorString, context);
			}
			if (CameraController.doOcrOnly) {
				message = handler.obtainMessage(CameraTypes.MESSAGE_CONTINUE_ANYWAY);
			}

			if (result.isValidRead && !CameraManagerController.isStillMode) {
				CameraController.videoImageTaken = true;
			}
			message.obj = result;
			message.sendToTarget();
		}finally{
			PreviewCallback.processingVideo = false;
		}
	}

	/**
	 * Parses the image result.
	 *
	 * @param imageResult the image result
	 * @return true, if successful
	 */



	private boolean parseImageResult(ImageSessionResult imageResult) {
		try {
			boolean result = false;
			getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.NONE;
			if (imageResult == null) {
				getOcrAnalyzeSession(context).ocrErrorCode = null;
				getOcrAnalyzeSession(context).ocrErrorMessage = null;
				getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE_GENERAL;
			} else if (imageResult.errorCodeId > -1) {
				Logger.i(tag, "error message:" + imageResult.errorMessage);
				getOcrAnalyzeSession(context).ocrErrorCode = imageResult.getErrorCode();
				getOcrAnalyzeSession(context).ocrErrorMessage = imageResult.errorMessage;
				// hack implement a better solution for c++ errors
				if (imageResult.errorCodeId == 18 || imageResult.errorCodeId == 19) {
					getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL;
				} else {
					getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE;
				}
			} else if (imageResult.mat == null) {
				getOcrAnalyzeSession(context).ocrErrorCode = null;
				getOcrAnalyzeSession(context).ocrErrorMessage = null;
				getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE;
			} else {
				if (isFrontCapture) {
					getOcrAnalyzeSession(context).frontImageRect = new Rect(0, 0, imageResult.tiffWidth, imageResult.tiffHeight);

				} else {
					getOcrAnalyzeSession(context).setBackImageTIFFPath(imageResult.filePath);
				}
				result = true;
			}
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("process time end ", FileUtils.getCurrentTime(), context);
			}

			Logger.i(tag, "parseImageResult | result:" + true + " analyzeErrorCode:" + getOcrAnalyzeSession(context).analyzeErrorCode);

			return result;
		}catch (Exception e){
			Logger.e(tag, Log.getStackTraceString(e));
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile(tag, "check OCR string " + ocrData.ocrRawResult + "OCR With delimeter " + ocrData.ocrResultWithDelimiter + "OCR score "+ ocrData.scoreResult, context);
			}
			return false;
		}
	}

	/**
	 * Perform ocr before binarization.
	 *
	 * @param currentMat the current mat
	 * @param adjustedCheckRect the adjusted check rect
	 * @return true, if successful
	 */
	private OCRResult performOcrBeforeBinarization(Mat currentMat, Rect adjustedCheckRect) {
		OCRResult result = new OCRResult();
		try {
			ocrData = mobiCHECKOCR.readOCRData(currentMat, null, adjustedCheckRect, cameraSessionManager.getVideoRect(), getOcrAnalyzeSession(context)
					.getVideoBoundingBox(), getOcrAnalyzeSession(context).currentMICRType.getId(), false);
			getOcrAnalyzeSession(context).setOcrResult(ocrData);
		}catch(Exception e){
			Logger.e(tag, Log.getStackTraceString(e));
			return null;
		}
		//	Logger.e(tag,"Raw Result "+ocrData.ocrResultWithDelimiter);
		result = ocrData;
		if (ocrData == null || ocrData.ocrRawResult == null || ocrData.ocrRawResult.length() < 1) {
			//check if for CMC7 only
				getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL;
				getOcrAnalyzeSession(context).ocrErrorCode = ErrorCode.errorOcrReading;

			//CameraManagerController.falseRecognitionVideoFrames++; // add to error counter on OCR failure.
			if (CameraManagerController.sessionType == SessionType.TEST) {
				result.isValidRead = prepareImageForServer(currentMat, timestamp, adjustedCheckRect, 0).imageResult;
			}
		} else {
			if (checkOcrResult()) { // ocr pass
				ImageSessionResult sessionResult = prepareImageForServer(currentMat, timestamp, adjustedCheckRect, ocrData.meanDigitHeight);

				result.isValidRead = sessionResult.imageResult;
			} else {
				//CameraManagerController.falseRecognitionVideoFrames++; // add to error counter on OCR failure.
				if (CameraManagerController.sessionType == SessionType.TEST && !result.isValidRead) {
					result.isValidRead = prepareImageForServer(currentMat, timestamp, adjustedCheckRect, 0).imageResult;
				}

			}

		}

		Logger.i(tag, "ocrResult:" + getOcrAnalyzeSession(context).getOcrResult());
		CameraController.processStart = false;
		return result;

	}

	/**
	 * Check ocr result.
	 *
	 * @return true, if successful
	 */
	private boolean checkOcrResult() {



		if (ocrData.signatureOverMicrDetected == 1 && CameraManagerController.showErrorSignatureOverMICR && CameraManagerController.ocrType == Common.OCRType.CMC7){
			{
				getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.TISFlowErrorMicrInterrupted;
				getOcrAnalyzeSession(context).ocrErrorCode = ErrorCode.errorMicrInterrupted;
				getOcrAnalyzeSession(context).getOcrResult().errorCodeId = ErrorCode.errorMicrInterrupted.getId();
			}
		}
		else if ( getOcrAnalyzeSession(context).getOcrResult() == null || getOcrAnalyzeSession(context).getOcrResult().digitalRowLength < 1) {
			getOcrAnalyzeSession(context).ocrErrorCode = null;
			getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL;
			getOcrAnalyzeSession(context).ocrErrorMessage = null;
			return false;
		}

		else if (CameraManagerController.imageType == TISDocumentType.CHECK && (ocrData.digitalRowLength < getOcrAnalyzeSession(context).txtValidFrom) | // if the micr number not between the range
				// session failed.
				(ocrData.digitalRowLength > getOcrAnalyzeSession(context).txtValidTo)) {
			getOcrAnalyzeSession(context).ocrErrorCode = ErrorCode.errorMicrLength;
			 getOcrAnalyzeSession(context).getOcrResult().errorCodeId = ErrorCode.errorMicrLength.getId();

		}

		final int errorCodeId = getOcrAnalyzeSession(context).getOcrResult().errorCodeId;
		if (errorCodeId > -1) {
			// translate error code
			final ErrorCode errorCode = ErrorCode.instanceOf(errorCodeId);
			switch (errorCode) {
				case errorMicrInterrupted:
					getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.TISFlowErrorMicrInterrupted;
					break;
				case errorMICRDetectedOnCheckBack:
					getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.TISFlowErrorMicrOnBack;
					break;
				case errorMicrLength:
					getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.ERROR_MICR_LENGTH;
					break;

				default:
					getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL;


			}

			getOcrAnalyzeSession(context).ocrErrorCode = errorCode;
			getOcrAnalyzeSession(context).ocrErrorMessage = getOcrAnalyzeSession(context).getOcrResult().errorMessage;
			return false;
		} else if (ocrData.ocrResultWithDelimiter.length() < 1 && ocrData.digitalRowLength == 0) {
			getOcrAnalyzeSession(context).ocrErrorCode = ErrorCode.errorOcrReading;

			getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL;
			getOcrAnalyzeSession(context).ocrErrorMessage = null;
			return false;
		}
		else if(CameraManagerController.imageType == TISDocumentType.CARD && CameraManagerController.ocrType == Common.OCRType.MRZ){
			OCRResult MRZRes = getOcrAnalyzeSession(context).getOcrResult();
			boolean validRead = OcrValidationUtils.validateIDCard(MRZRes);
			if (!validRead){
				boolean candidateForAnotherValidation = OcrValidationUtils.correctMRZIDResults(MRZRes);
				if (candidateForAnotherValidation){
					validRead = OcrValidationUtils.validateIDCard(MRZRes);
				}

			}

			return validRead;
		}
		if (CameraManagerController.isDebug) {
			FileUtils.addToLogFile(tag, "check OCR string " + ocrData.ocrRawResult + "OCR With delimeter " + ocrData.ocrResultWithDelimiter + "OCR score "+ ocrData.scoreResult, context);
		}
		getOcrAnalyzeSession(context).setOcrResult(ocrData);
		return true;

	}

	/**
	 * Prepare image for server.
	 *
	 * @param currentMat the current mat
	 * @param timestamp the timestamp
	 * @param checkRect the check rect
	 * @param meanDigitHeight the mean digit height
	 * @return the image session result
	 */
	private ImageSessionResult prepareImageForServer(Mat currentMat, int timestamp, Rect checkRect, int meanDigitHeight) {
		final String text = StringUtils.dynamicString(context, "TISFlowPreparingImage");

		final Message message = handler.obtainMessage(CameraTypes.MESSAGE_SHOW_PROCESSING_LABEL);
		message.obj = text;
		message.sendToTarget();

		Logger.i(
				tag,
				"currentVideoRect:" + cameraSessionManager.getVideoRect() + " | currentCheckRect:" + checkRect + " |currentOrientation:"
						+ getOcrAnalyzeSession(context).orientation + " |frontImageRect:"
						+ getOcrAnalyzeSession(context).frontImageRect + " |isFront:" + isFrontCapture + " |isSendImageAsIs:");

		String imagePath = isFrontCapture ? getOcrAnalyzeSession(context).getFrontImagePath() : getOcrAnalyzeSession(context)
				.getBackImagePath();

		Rect checkRectInfo = checkRect;

		if (!isFrontCapture
				&& CameraManagerController.imageType == TISDocumentType.CHECK
				&& (getOcrAnalyzeSession(context).frontImageRect == null || getOcrAnalyzeSession(context).frontImageRect.width == 0)) {
			getOcrAnalyzeSession(context).frontImageRect = new Rect(0, 0, 1200, 600);
		}
		boolean alignImage = false;
		// conditions for image aligment to the algo. on dynamic capture the algo does already does it in wrap prespective inside c++.
		if (!CameraManagerController.isDynamicCapture && (CameraManagerController.imageType != TISDocumentType.CHECK || CameraManagerController.enableSoftCaptureAndImageAligment)) {
			alignImage = true;
		}
		if (CameraManagerController.sessionType == SessionType.TEST) { // we dont have camera open on video so tghe stills res is the mat size
			CameraConfigurationManager.captureResolutionHeight = currentMat.rows();
			CameraConfigurationManager.captureResolutionWidth = currentMat.cols();

		}

		String model = FileUtils.getDeviceName() + " Android version " + Build.VERSION.RELEASE;
		String make = context.getResources().getString(R.string.TISVersion);

		Mat outputCroppedImage = new Mat();

		// if cropping controller enable set the chosen rectangle from crop controller screen and the cropped image to the Algo.
		if (enableCroppingController){
			checkRectInfo = CameraManagerController.getOcrAnalyzeSession(CameraController.getInstance()).getStillsBoundingBox();
			if(isFrontCapture)
				outputCroppedImage = CameraManagerController.getOcrAnalyzeSession(CameraController.getInstance()).getFrontCroppedStillsMat();

			else
				outputCroppedImage = CameraManagerController.getOcrAnalyzeSession(CameraController.getInstance()).getBackCroppedStillsMat();
		}
		// if manual capture and auto capture is disable let the algo to find rectangle from scratch so incoming rect should be 0.
		imageResult = mobiCHECKOCR.prepareCurrentImageForSending(currentMat, outputCroppedImage,timestamp, imagePath, videoRect, checkRectInfo,
				getOcrAnalyzeSession(context).orientation, isFrontCapture, getOcrAnalyzeSession(context).frontImageRect, false,
				getOcrAnalyzeSession(context).getOCRAnalyzeResult().meanDigitHeight, doOcrOnBinImage(), CameraManagerController.imageType.ordinal(),
				(int) CameraConfigurationManager.captureResolutionHeight * (int) CameraConfigurationManager.captureResolutionWidth, alignImage,
				!CameraManagerController.isDynamicCapture,getOcrAnalyzeSession(context).getCroppingCoordinates(), model, make);
		if ((!CameraManagerController.isStillMode || CameraManagerController.sessionType == SessionType.PORTRAIT) && outputCroppedImage!= null && outputCroppedImage.cols() > 1) {
			Imgproc.cvtColor(outputCroppedImage, outputCroppedImage, Imgproc.COLOR_BGR2RGBA, 4);
		}

		CameraController.getInstance().captureButtonPressed = false;
		if (isFrontCapture) {
			getOcrAnalyzeSession(context).getOCRAnalyzeResult().meanDigitHeight = imageResult.meanDigitHeight;
		}
		//cameraSessionManager.calAngleBetweenPoints(new Float[imageResult.], second)

		try {
			// create cropped images.
			if (CameraManagerController.sessionType == SessionType.TEST || CameraManagerController.shouldOutputGrayscaleImage || CameraManagerController.shouldOutputColoredImage
					|| CameraManagerController.scanBackOnly) {
				rect = new BoundingBoxResult();
				if (imageResult != null && imageResult.width > 0 && imageResult.height > 0) {
					rect.setRect(imageResult.x, imageResult.y, imageResult.width, imageResult.height);

				}
				createCroppedImages(outputCroppedImage, rect.getRect(), isFrontCapture, CameraManagerController.grayScaleSize);
				if (!isFrontCapture && (CameraManagerController.sessionType == SessionType.TEST)) {
					checkRectInfo = rect.getRect();
				}
			}


		} catch (Exception e) {
			Logger.e(tag, "Failed to find rectangle");
		}
		if (doOcrOnBinImage()) { // init ocr results After Bin image
			ocrData = new OCRResult();
			ocrData.digitalRowLength = imageResult.digitalRowLength;
			ocrData.meanDigitHeight = imageResult.meanDigitHeight;
			ocrData.ocrRawResult = imageResult.ocrRawResult;
			ocrData.scoreResult = imageResult.scoreResult;
			ocrData.ocrResultWithDelimiter = imageResult.ocrResultWithDelimiter;
			ocrData.signatureOverMicrDetected = imageResult.signatureOverMicrDetected;
			ocrData.errorCodeId = imageResult.errorCodeId;
			ocrData.errorMessage = imageResult.errorMessage;
			getOcrAnalyzeSession(context).setOcrResult(ocrData);

		}


		imageResult.imageResult = parseImageResult(imageResult);
		if (imageResult.imageResult == true && CameraManagerController.doOcrOnImage && isFrontCapture) { // check that we have a matrix after the image result.
			imageResult.imageResult = checkOcrResult(); // check for OCR response.
		}
		return imageResult;
	}

	/**
	 * Recycle bitmap.
	 *
	 * @param bitmap the bitmap
	 */
	@SuppressWarnings("unused")
	private void recycleBitmap(Bitmap bitmap) {
		if (bitmap != null) {
			bitmap.recycle();
			bitmap = null;
		}
	}

	/**
	 * Gets the DP iin float.
	 *
	 * @param width the width
	 * @param height the height
	 * @return the DP iin float
	 */
	private long getDPIinFloat(int width, int height) {
		return (long) Math.sqrt(width * width + height * height) / 4;
	}

	/**
	 * Px.
	 *
	 * @param dips the dips
	 * @return the int
	 */
	private int px(float dips) {
		float DP = context.getResources().getDisplayMetrics().density;
		return Math.round(dips * DP);
	}

	/** The upload image data. */
	byte[] uploadImageData;

	/**
	 * Creates the cropped images.
	 *
	 * @param croppedMat the image mat
	 * @param rect the rect
	 * @param isFront the is front
	 * @param size the size
	 */
	private void createCroppedImages(Mat croppedMat, Rect rect, boolean isFront, int[] size) {
		if ( ( (rect.width == 0 || rect.height == 0)  && !enableCroppingController ) || croppedMat.empty() ) {
			return;
		}
		try {
			if (croppedMat.rows() == 1080 && croppedMat.cols() == 1920 && !CameraManagerController.shouldOutputBWImage){ // ugly when we dont have bin image!
				croppedMat = new Mat(croppedMat, rect);

			}


			if (size == null) {
				size = new int[2];
				size[0] = rect.height;
				size[1] = rect.width;
			}
			if (CameraManagerController.shouldOutputGrayscaleImage) {
				Mat grayImage = new Mat();
				Imgproc.cvtColor(croppedMat, grayImage, Imgproc.COLOR_RGB2GRAY);
				Mat resizeimage = grayImage.clone();

				if (CameraManagerController.imageType == TISDocumentType.CHECK && imageResult != null && imageResult.mat != null && imageResult.tiffHeight > 0) {
					Size sz = new Size(imageResult.tiffWidth, imageResult.tiffHeight);
					Imgproc.resize(grayImage, resizeimage, sz);
				}

				uploadImageData = FileUtils.convertJpgMatToByte(resizeimage, CameraManagerController.grayScaleImageCompression);
				// set to 200 DPI
				uploadImageData[13] = 1;
				uploadImageData[14] = (byte) 0x00;
				uploadImageData[15] = (byte) 0xc8;
				uploadImageData[16] = (byte) 0x00;
				uploadImageData[17] = (byte) 0xc8;

			}
			// cropped colorImage
			if (CameraManagerController.shouldOutputColoredImage) {
				try {
					if (isFrontCapture && croppedMat != null && !croppedMat.empty()) {
						SessionResultParams.colorFront = FileUtils.convertJpgMatToByte(croppedMat, CameraManagerController.colorImageCompression);
					} else {
						SessionResultParams.colorBack = FileUtils.convertJpgMatToByte(croppedMat, CameraManagerController.colorImageCompression);
					}
				} catch (Exception e) {
					Logger.e(tag, "processCapturedImage:" + e.getMessage());
				}

			}

			if (CameraManagerController.shouldOutputGrayscaleImage) {
				if (isFront)
					SessionResultParams.grayscaleFront = uploadImageData;
				else
					SessionResultParams.grayscaleBack = uploadImageData;
			}

		} catch (Exception e) {
			Logger.e(tag, "createCroppedImages" + Log.getStackTraceString(e));
			return;
		}

	}

	/**
	 * Do ocr on bin image.
	 *
	 * @return true, if successful
	 */
	private boolean doOcrOnBinImage() {
		if (CameraManagerController.isStillMode && isFrontCapture && CameraManagerController.doOcrOnImage) {
			return true;
		}
		return false;
	}

	private boolean detectBlurJava(Mat dst2) {
		long startTime = System.currentTimeMillis();
		int l = CvType.CV_8UC1; //8-bit grey scale image
		Mat laplacianImage = new Mat();
		dst2.convertTo(laplacianImage, l);
		Imgproc.Laplacian(dst2, laplacianImage, CvType.CV_8U);
		//Highgui.imwrite("/data/user/0/com.topimagesystems.sample/files/.mobiflow/laplaceImage.jpg",laplacianImage);
		Mat laplacianImage8bit = new Mat();
		laplacianImage.convertTo(laplacianImage8bit, l);

		Bitmap bmp = Bitmap.createBitmap(laplacianImage8bit.cols(),
				laplacianImage8bit.rows(), Bitmap.Config.ARGB_8888);
		Utils.matToBitmap(laplacianImage8bit, bmp);
		int[] pixels = new int[bmp.getHeight() * bmp.getWidth()];
		bmp.getPixels(pixels, 0, bmp.getWidth(), 0, 0, bmp.getWidth(),
				bmp.getHeight());
		if (bmp != null)
			if (!bmp.isRecycled()) {
				bmp.recycle();

			}

		int maxLap = -16777216;

		for (int i = 0; i < pixels.length; i++) {
			if (pixels[i] > maxLap)
				maxLap = pixels[i];
		}
//        int maxLap = -16777216;
//        for (int i = 0; i < laplacianImage8bit.rows(); i++)
//        {
//            for (int j = 0; j < laplacianImage8bit.cols(); j++)
//            {
//                if( (int)laplacianImage8bit.get(i, j)[0] > maxLap ){
//                    double[] res= laplacianImage8bit.get(i, j);
//                    maxLap = (int)laplacianImage8bit.get(i, j)[0];
//                }
//            }
//        }
		Logger.i(tag, "maxLap " + maxLap);
		if(CameraManagerController.isDebug){
			FileUtils.addToLogFile("Blur detection image  " + maxLap,context );
		}
		Double frontBlurTresh = Double.valueOf(context.getResources().getString(R.string.front_blur_treshold)); //front_blur_treshold
		Double backBlurTresh = Double.valueOf(context.getResources().getString(R.string.back_blur_treshold));
		// blur value for Custom mode and full page.
		int soglia =  -9020000;
		// for other doc type use less strict blur
		if (CameraManagerController.sessionType != SessionType.PORTRAIT){
			soglia *=1.2;
			// small doc type like card should be less strict than teh rest.
			if (imageType == TISDocumentType.CARD){
				soglia *=1.1;
			}
		}
		if (frontBlurTresh > 0 && isFrontCapture){
			 soglia *=	frontBlurTresh;
		}

		if (getOcrAnalyzeSession(CameraController.getInstance()).captureMode == CaptureMode.BACK || CameraManagerController.scanBackOnly){
			soglia =  -14000000;
			if (backBlurTresh >0){
				soglia *=	backBlurTresh;
			}
		}

		if (maxLap < soglia || maxLap == soglia) {

			return true;
			//Log.d(MIOTAG, "blur image");
		}
		return false;
	}


	private Rect findRectfindRectOnStillsOnStills(Mat originalMat) throws Exception {
		Mat boundingBoxMat = new Mat();
		GenericBoundingBoxResult genericBoundingBoxResult = mobiCHECKOCR.findGenericBoundingBox(originalMat, boundingBoxMat);

		if (genericBoundingBoxResult == null || genericBoundingBoxResult.width == 0 || genericBoundingBoxResult.height == 0) {
			CheckBoundaries cb = CameraManagerController.getOcrAnalyzeSession(CameraController.getInstance()).getCheckBoundaries();
			if (cb == null)
				throw new Exception("problem finding Check Boundaries on stills");
			Rect checkRect = cb.getValidationRect();
			checkRect = MobiCHECKOCR.convertRectToCorrectAspectRatio(checkRect, 2);
			if (checkRect == null)
				throw new Exception("problem finding validation rect on stills");
			genericBoundingBoxResult = new GenericBoundingBoxResult();
			genericBoundingBoxResult.topLeftX = genericBoundingBoxResult.bottomLeftX = genericBoundingBoxResult.x = checkRect.x;
			genericBoundingBoxResult.topLeftY = genericBoundingBoxResult.topRightY = genericBoundingBoxResult.y = checkRect.y;
			genericBoundingBoxResult.topRightX = genericBoundingBoxResult.bottomRightX = (float) checkRect.br().x;
			genericBoundingBoxResult.bottomLeftY = genericBoundingBoxResult.bottomRightY = (float) checkRect.br().y;
			genericBoundingBoxResult.width = checkRect.width;
			genericBoundingBoxResult.height = checkRect.height;
		}

		float[] coordinates = new float[8];
		UserInterfaceUtils.fillPointsArrayFromBoundingBox(coordinates, genericBoundingBoxResult);
		CameraManagerController.getOcrAnalyzeSession(context).setCroppingCoordinates(coordinates);
		CameraManagerController.getOcrAnalyzeSession(context).setStillsBoundingBox(genericBoundingBoxResult.getRect());
		return genericBoundingBoxResult.getRect();
	}




	/**
	 * Start no binarization flow.
	 *
	 * @param currentMat the current mat
	 * @param adjustedCheckRect the adjusted check rect
	 * @return true, if successful
	 */
	private OCRResult startNoBinarizationFlow(Mat currentMat, Rect adjustedCheckRect) {
		// reach here when binarization option not chosen.
		OCRResult result = new OCRResult();
		result.isValidRead = true;
		Rect highResImageRect = null;
		if (CameraManagerController.isStillMode) {
			highResImageRect = mobiCHECKOCR.findCheckBoundingBoxHighResImage(currentMat, 1, videoRect, adjustedCheckRect,
					getOcrAnalyzeSession(context).frontImageRect, OCRHelper.scaleWidth, OCRHelper.scaleHeight).getRect();
		}

		if (adjustedCheckRect == null || adjustedCheckRect.width <= 0 || adjustedCheckRect.height <= 0 && CameraManagerController.isStillMode) {

			getOcrAnalyzeSession(context).ocrErrorCode = null;
			getOcrAnalyzeSession(context).ocrErrorMessage = null;
			getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE;
			result.isValidRead = false;
		}

		if (CameraManagerController.doOcrOnImage && result.isValidRead && isFrontCapture) {
			ocrData = mobiCHECKOCR.readOCRData(currentMat, null, adjustedCheckRect, cameraSessionManager.getVideoRect(), getOcrAnalyzeSession(context)
					.getVideoBoundingBox(), getOcrAnalyzeSession(context).currentMICRType.getId(), false);
			getOcrAnalyzeSession(context).setOcrResult(ocrData);
			result.isValidRead = checkOcrResult();
		}
		if (result.isValidRead) {
			createCroppedImages(currentMat, CameraManagerController.isStillMode ? highResImageRect : adjustedCheckRect, isFrontCapture, CameraManagerController.grayScaleSize);
		} else if (!CameraManagerController.isStillMode) {
			CameraManagerController.falseRecognitionVideoFrames++;
		}
		return result;
	}

	private boolean perfromBlurOnImage(){
		Mat img;
		if (CameraManagerController.isStillMode){
			 img = currentMat;
		}
		else{
			img = CameraSessionManager.getInstance().currCroppedVideoMat;
			}
		if(doBlur(img)) {
			getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.TISFlowErrorMicrOnBack;
			getOcrAnalyzeSession(context).ocrErrorCode = ErrorCode.errorBlurDetectionFailed;
			Message message = handler.obtainMessage(CameraTypes.MESSAGE_PROCESS_NOT_VALID);
			//CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, CameraTypes.MESSAGE_AUTO_FOCUS);
			//message.obj = CameraTypes.MESSAGE_AUTO_FOCUS;
			message.sendToTarget();
			return true;
		}
		return false;
	}


	private boolean doBlur(Mat image) {
		try {
			long startTime = System.currentTimeMillis();
			int blurRectangles = 0;
			int whiteRectangleCount = 0;
			int validRectangleCount = 0;
			Mat croppedImg = image.clone();
			int imageBorderToRemove= 50;
			ArrayList<Mat> validImagesGrid = new ArrayList<Mat>();
			Rect highResImageRect = new Rect();
			Mat smallBinImage = new Mat();
			if (CameraManagerController.sessionType != SessionType.TEST) {
				if (OCRHelper.scaleWidth == 0) { // if we didn't init AR yet, do cropping before Blur Detection.
					if (CameraManagerController.sessionType == SessionType.PORTRAIT) {
						OCRHelper.scaleHeight = CameraConfigurationManager.captureResolutionWidth / CameraConfigurationManager.videoResolutionWidth;
						OCRHelper.scaleWidth = CameraConfigurationManager.captureResolutionHeight / CameraConfigurationManager.videoResolutionHeight;
					} else {
						OCRHelper.scaleWidth = CameraConfigurationManager.captureResolutionWidth / CameraConfigurationManager.videoResolutionWidth;
						OCRHelper.scaleHeight = CameraConfigurationManager.captureResolutionHeight / CameraConfigurationManager.videoResolutionHeight;
					}
				}
			}
			String imPath = FileUtils.getTestImagePath(context) + "/" + "beforecrop.jpg";
		//	Highgui.imwrite(imPath.replace(".jpg","bin.jpg"), croppedImg);
			long startTime2 = System.currentTimeMillis();
			if (CameraManagerController.isStillMode) {


				// here we need crop the stills image since it dosent cropped yet.
				if (CameraManagerController.isDynamicCapture) {
					croppedImg = new Mat(image,adjustedCheckRect);

				}else{
					highResImageRect = mobiCHECKOCR.findCheckBoundingBoxHighResImage(croppedImg, 1, videoRect, adjustedCheckRect,
							getOcrAnalyzeSession(context).frontImageRect, OCRHelper.scaleWidth, OCRHelper.scaleHeight).getRect();
					if (highResImageRect.width == 0){
						highResImageRect = adjustedCheckRect;
					}
				}
				}
			else{
				highResImageRect = new Rect(0,0,croppedImg.width(),croppedImg.height());
			}
			long endTime2 = System.currentTimeMillis();
			Logger.i(tag, "Blur crop total time " + (endTime2-startTime2));
			highResImageRect.x+=imageBorderToRemove;
			highResImageRect.y+=imageBorderToRemove;
			highResImageRect.width-=imageBorderToRemove;
			highResImageRect.height-=imageBorderToRemove;
			imPath = FileUtils.getTestImagePath(context) + "/" + "original.jpg";

			if (!CameraManagerController.isDynamicCapture) { // in dynamic capture the image already cropped as expected.
				croppedImg = new Mat(croppedImg, highResImageRect);
			}
			//Highgui.imwrite(imPath.replace(".jpg","cr.jpg"), croppedImg);

			Imgproc.cvtColor(croppedImg, croppedImg, Imgproc.COLOR_RGB2GRAY);

			Size smallSize = new Size( (croppedImg.width()) / 3, (croppedImg.height()) / 3); // split the image and create grid of 9 images.
			int count = 0; // start from 1- we dont want to count the image border
			int imgHeight = (int) smallSize.height;
			int imgWidth = (int) smallSize.width;
			for (int y = 0; y < croppedImg.rows()-imageBorderToRemove; y += imgHeight) {
				for (int x = 0; x < croppedImg.cols()-imageBorderToRemove; x += imgWidth) {
					try {
						Rect rect = new Rect(x, y, (int) smallSize.width, (int) smallSize.height);
						Mat m = new Mat(croppedImg, rect);
						Imgproc.threshold(m, smallBinImage, 0, 255, Imgproc.THRESH_OTSU); // otsu bin to count white and black pixels.
						int blackPixels = Core.countNonZero(smallBinImage);
						long numOfPixels = croppedImg.total();
						 imPath = FileUtils.getTestImagePath(context) + "/" + count + ".jpg";
                        //Highgui.imwrite(imPath.replace(".jpg","bin.jpg"), smallBinImage);
						if (!(blackPixels <= 0.08 * numOfPixels)) { // if over 10% from the image is black meaning we have text the Mat is Valid, only valid Mats will be send.
							validImagesGrid.add(m); // add to valid images Array
							count++;

						//	Highgui.imwrite(imPath,m);

							validRectangleCount++;
						} else {
							whiteRectangleCount++;

						}
						//Logger.i(tag, "validRectangleCount " + validRectangleCount + "whiteRectangleCount "+whiteRectangleCount );
						//String imPath = "/data/user/0/com.topimagesystems.sample/files/.mobiflow/gridImage"+ String.valueOf(smallImages.size())+".jpg";
//						Highgui.imwrite(imPath, smallBinImage);
					} catch (Exception e) {
						Logger.e(tag,Log.getStackTraceString(e));
					}				}
			}
			for (int i = 0; i < validImagesGrid.size(); i++) {
				if (detectBlurJava(validImagesGrid.get(i))) {
					blurRectangles++;

				}
			}
			long endTime = System.currentTimeMillis();
		//	Logger.i(tag, "Blur total time " + (System.currentTimeMillis() - startTime));

			int maxInvalidRects = isFrontCapture ? MAX_BLUR_RECTS_FRONT : MAX_BLUR_RECTS_BACK;
			if (blurRectangles > maxInvalidRects) {
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("Image Blurry!", context);
				}
				Logger.e(tag, "Image Blurry, Blur Rectangles " + blurRectangles);
				return true;
			}
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("Image Sharp", context);
			}
			Logger.i(tag, "Image Sharp");
			return false;

		} catch (Exception e) {
			//	Logger.e(tag,Log.getStackTraceString(e));
			return false;
		}
	}


/*	class doBlurTask implements Runnable {
		Mat image;

		doBlurTask(Mat image) {
			this.image = image;
		}

		public void run() {
			{
				 if(doBlur(image)) {
					 isBluredImage = true;
				getOcrAnalyzeSession(context).analyzeErrorCode = OCRAnalyzeErrorCode.TISFlowErrorMicrOnBack;
				getOcrAnalyzeSession(context).ocrErrorCode = ErrorCode.errorBlurDetectionFailed;
				Message message = handler.obtainMessage(CameraTypes.MESSAGE_PROCESS_NOT_VALID);
				//CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, CameraTypes.MESSAGE_AUTO_FOCUS);
				//message.obj = CameraTypes.MESSAGE_AUTO_FOCUS;
				message.sendToTarget();
			}

			}
		}
	}*/


}