/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;

import com.topimagesystems.util.Logger;

// TODO: Auto-generated Javadoc
/**
 * The Class PeriodicAutoFocusCallback.
 */
final class PeriodicAutoFocusCallback implements Camera.AutoFocusCallback {

	/** The Constant TAG. */
	private static final String TAG = Logger.makeLogTag("PeriodicAutoFocusCallback");

	/** The auto focus handler. */
	private Handler autoFocusHandler;
	
	/** The auto focus message. */
	private int autoFocusMessage;
	private static int periodicAutoFocusFaliureCounter = 0;

	/**
	 * Sets the handler.
	 *
	 * @param autoFocusHandler the auto focus handler
	 * @param autoFocusMessage the auto focus message
	 */
	void setHandler(Handler autoFocusHandler, int autoFocusMessage) {
		this.autoFocusHandler = autoFocusHandler;
		this.autoFocusMessage = autoFocusMessage;
		periodicAutoFocusFaliureCounter = 0;
	}

	public static int getLastAutoFocusResult() {
		return periodicAutoFocusFaliureCounter;
	}

	/* (non-Javadoc)
         * @see android.hardware.Camera.AutoFocusCallback#onAutoFocus(boolean, android.hardware.Camera)
         */
	public void onAutoFocus(boolean success, Camera camera) {
		CameraSessionManager.hasFocus = success;		
		if (autoFocusHandler != null) {
			Message message = autoFocusHandler.obtainMessage(autoFocusMessage, success);
			autoFocusHandler.sendMessageDelayed(message, CameraConfigurationManager.AUTOFOCUS_INTERVAL);
			if (!success){
				periodicAutoFocusFaliureCounter++;
			}
			else{
				periodicAutoFocusFaliureCounter = 0;
			}

			// when we dont want the Autofocus to run?
			//autoFocusHandler = null;
		}
		else {
			Logger.i(TAG, "but no handler for it");
		}
	}
	
	
	
}