/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import org.opencv.core.Mat;
import org.opencv.core.Rect;

import com.topimagesystems.Constants;
import com.topimagesystems.intent.CaptureIntent.SessionType;
import com.topimagesystems.intent.CaptureIntent.TISDocumentType;

import android.graphics.Matrix;
import android.graphics.Point;
import android.os.Bundle;

// TODO: Auto-generated Javadoc
/**
 * The Class OCRHelper.
 */
public class OCRHelper {
	private static final int VIRTUAL_WIDTH = 480;
	private static final int VIRTUAL_HEIGHT = 320;
	private static final float videoAR = (float) CameraConfigurationManager.videoResolutionWidth / (float) CameraConfigurationManager.videoResolutionHeight;

	/** The scale height. */
	public static float scaleWidth, scaleHeight;
	private static Matrix tranMatrix;

	/**
	 * Rect to bundle.
	 *
	 * @param rect
	 *            the rect
	 * @return the bundle
	 */

	public static Bundle rectToBundle(Rect rect, float[] bottomLeft, float[] bottomRight, float[] topLeft, float[] topRight) {
		if (rect == null)
			return null;
		Bundle bundle = new Bundle();
		bundle.putInt("x", rect.x *= CameraConfigurationManager.screenAndVideoRatioWidth);
		bundle.putInt("y", rect.y *= CameraConfigurationManager.screenAndVideoRatioHeight);
		bundle.putInt("width", rect.width *= CameraConfigurationManager.screenAndVideoRatioWidth);

		bundle.putFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_LEFT, bottomLeft);
		bundle.putFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_RIGHT, bottomRight);
		bundle.putFloatArray(Constants.INTENT_CHECK_QUADS_TOP_LEFT, topLeft);
		bundle.putFloatArray(Constants.INTENT_CHECK_QUADS_TOP_RIGHT, topRight);

		return bundle;
	}

	public static Point resizeImageForImageView() {

		int originalWidth = CameraConfigurationManager.videoResolutionWidth;
		int originalHeight = CameraConfigurationManager.videoResolutionHeight;
		int newWidth = -1;
		int newHeight = -1;
		float multFactor = -1.0F;
		if (originalHeight > originalWidth) {
			newHeight = CameraConfigurationManager.screenResolution.y *= CameraConfigurationManager.screenAndVideoRatioHeight;
			multFactor = (float) originalWidth / (float) originalHeight;
			newWidth = (int) (newHeight * multFactor);
		} else if (originalWidth > originalHeight) {
			newWidth = CameraConfigurationManager.screenResolution.x *= CameraConfigurationManager.screenAndVideoRatioWidth;
			multFactor = (float) originalHeight / (float) originalWidth;
			newHeight = (int) (newWidth * multFactor);
		} else if (originalHeight == originalWidth) {
			newHeight = CameraConfigurationManager.screenResolution.y;
			newWidth = CameraConfigurationManager.screenResolution.x;
		}
		return new Point(newWidth / CameraConfigurationManager.screenResolution.x, newHeight / CameraConfigurationManager.screenResolution.y);
	}

	/**
	 * Bundle to rect.
	 *
	 * @param bundle
	 *            the bundle
	 * @return the rect
	 */
	public static Rect bundleToRect(Bundle bundle) {
		if (bundle == null) {
			return null;
		} else {
			Rect rect = new Rect(bundle.getInt("x"), bundle.getInt("y"), bundle.getInt("width"), bundle.getInt("height"));
			return rect;
		}
	}

	public static Matrix getTransformationMatris() {
		return tranMatrix;
	}

	/**
	 * Calculate video still mat ratio.
	 *
	 * @param checkRect
	 *            the check rect
	 * @param currentMat
	 *            the current mat
	 * @param displayWidth
	 *            the display width
	 * @param videoMat
	 *            the video mat
	 * @return the rect
	 */
	public static Rect calculateVideoStillMatRatio(Rect checkRect, Mat currentMat, int displayWidth, Mat videoMat) {
		if (checkRect == null || currentMat == null)
			return null;
		Rect result = new Rect();

		if (CameraManagerController.sessionType == SessionType.TEST) { // scale
																		// video
																		// to
																		// still
																		// for
																		// Test
																		// mode
																		// only.
			if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == SessionType.PORTRAIT) {
				if (CameraConfigurationManager.videoResolutionWidth >CameraConfigurationManager.videoResolutionHeight  ){
					int tmp = CameraConfigurationManager.videoResolutionHeight;
					CameraConfigurationManager.videoResolutionHeight = CameraConfigurationManager.videoResolutionWidth;
					CameraConfigurationManager.videoResolutionWidth = tmp;
				}
				scaleHeight = currentMat.height() * 1.0f / CameraConfigurationManager.videoResolutionHeight * 1.0f;
				scaleWidth = currentMat.width() * 1.0f / CameraConfigurationManager.videoResolutionWidth * 1.0f;
				float scale = currentMat.width() / (displayWidth * 1.0f);
				result.x = (int) (checkRect.x * scale);
				result.y = (int) (checkRect.y * scale);
				result.width = (int) (checkRect.width * scale);
				result.height = (int) (checkRect.height * scale);
			} else { // if document need video resolution present as
						// width*height but the image is rotated so compare
						// width to height.
				scaleWidth = currentMat.width() / CameraConfigurationManager.videoResolutionHeight * 1.0f;
				scaleHeight = currentMat.height() / CameraConfigurationManager.videoResolutionWidth * 1.0f;
			}
		}
		// scale the video image to still image, so the algo will get the exact
		// boundries.
		else {
			scaleWidth = currentMat.width() / (videoMat.width() * 1.0f);
			scaleHeight = currentMat.height() / (videoMat.height() * 1.0f);

			return checkRect;
		}

		return result;

	}
}