/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import com.topimagesystems.micr.OCRResult;

import android.os.Bundle;

// TODO: Auto-generated Javadoc
/**
 * The Class OCRAnalyzeResult.
 */
public class OCRAnalyzeResult {
	
	/** The ocr result. */
	private OCRResult ocrResult;
	
	/** The mean digit height. */
	public int meanDigitHeight = 0;
	
	/**
	 * Gets the mean digit height.
	 *
	 * @return the mean digit height
	 */
	public int getMeanDigitHeight() {
		return meanDigitHeight;
	}

	/**
	 * Sets the mean digit height.
	 *
	 * @param meanDigitHeight the new mean digit height
	 */
	public void setMeanDigitHeight(int meanDigitHeight) {
		this.meanDigitHeight = meanDigitHeight;
	}

	/** The front image path. */
	private String frontImagePath;
	
	/** The back image path. */
	private String backImagePath;
	
	/** The front image path as tiff. */
	private String frontImagePathAsTiff;
	
	/** The back image path as tiff. */
	private String backImagePathAsTiff;

	/**
	 * Instantiates a new OCR analyze result.
	 */
	public OCRAnalyzeResult() {
	}

	/**
	 * Instantiates a new OCR analyze result.
	 *
	 * @param bundle the bundle
	 */
	public OCRAnalyzeResult(Bundle bundle) {
		if (bundle != null) {
			Bundle ocrResultBundle = bundle.getBundle("ocrResult");
			if (ocrResultBundle != null) {
				ocrResult = new OCRResult(ocrResultBundle);
			}
			frontImagePath = bundle.getString("frontImagePath");
			backImagePath = bundle.getString("backImagePath");
			frontImagePathAsTiff = bundle.getString("frontImagePathAsTiff");
			backImagePathAsTiff = bundle.getString("backImagePathAsTiff");
		}
	}

	/**
	 * Gets the ocr result.
	 *
	 * @return the ocr result
	 */
	public OCRResult getOcrResult() {
		return ocrResult;
	}

	/**
	 * Sets the ocr result.
	 *
	 * @param ocrResult the new ocr result
	 */
	public void setOcrResult(OCRResult ocrResult) {
		this.ocrResult = ocrResult;
	}

	/**
	 * Gets the front image path.
	 *
	 * @return the front image path
	 */
	public String getFrontImagePath() {
		return frontImagePath;
	}

	/**
	 * Sets the front image path.
	 *
	 * @param frontImagePath the new front image path
	 */
	public void setFrontImagePath(String frontImagePath) {
		this.frontImagePath = frontImagePath;
	}

	/**
	 * Gets the back image path.
	 *
	 * @return the back image path
	 */
	public String getBackImagePath() {
		return backImagePath;
	}

	/**
	 * Sets the back image path.
	 *
	 * @param backImagePath the new back image path
	 */
	public void setBackImagePath(String backImagePath) {
		this.backImagePath = backImagePath;
	}

	/**
	 * Gets the front image path as tiff.
	 *
	 * @return the front image path as tiff
	 */
	public String getFrontImagePathAsTiff() {
		return frontImagePathAsTiff;
	}

	/**
	 * Sets the front image path as tiff.
	 *
	 * @param frontImagePathAsTiff the new front image path as tiff
	 */
	public void setFrontImagePathAsTiff(String frontImagePathAsTiff) {
		this.frontImagePathAsTiff = frontImagePathAsTiff;
	}

	/**
	 * Gets the back image path as tiff.
	 *
	 * @return the back image path as tiff
	 */
	public String getBackImagePathAsTiff() {
		return backImagePathAsTiff;
	}

	/**
	 * Sets the back image path as tiff.
	 *
	 * @param backImagePathAsTiff the new back image path as tiff
	 */
	public void setBackImagePathAsTiff(String backImagePathAsTiff) {
		this.backImagePathAsTiff = backImagePathAsTiff;
	}

	/**
	 * To bundle.
	 *
	 * @return the bundle
	 */
	public Bundle toBundle() {
		Bundle bundle = new Bundle();
		if (ocrResult != null) {
			bundle.putBundle("ocrResult", ocrResult.toBundle());
		}
		bundle.putString("frontImagePath", frontImagePath);
		bundle.putString("backImagePath", backImagePath);
		bundle.putString("frontImagePathAsTiff", frontImagePathAsTiff);
		bundle.putString("backImagePathAsTiff", backImagePathAsTiff);
		return bundle;
	}
}