package com.topimagesystems.controllers.imageanalyze;

import java.io.IOException;
import java.util.Locale;

import org.opencv.core.Rect;

import com.topimagesystems.Constants;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager.State;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.HintIndicator;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.NEXT_ACTION;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.micr.OCRCommon.ErrorCode;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import com.topimagesystems.util.UserInterfaceUtils;

import android.content.Intent;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

public class DynamicCaptureCameraController extends CameraController implements CaptureIntent.callbackReturnMessage {
	static double M_PI =  3.14159265358979323846264338327950288;

	private DynamicCameraOverlayLayout dynamicCameraOverlayView;

	@Override
	protected void setOverlay() {
		OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
		activity = this;
		cameraOverlayView = dynamicCameraOverlayView = (DynamicCameraOverlayLayout) getLayoutInflater().inflate(R.layout.dynamic_capture_overlay, null);
		dynamicCameraOverlayView.setIsTorchOn(ocrAnalyzeSession.isTorchOn);


		dynamicCameraOverlayView.setIsManualCapture(ocrAnalyzeSession.isManualCapture);
		dynamicCameraOverlayView.setActionClickListener(new ActionClickListenerImpl());
		dynamicCameraOverlayView.setWillNotDraw(false);
		dynamicCameraOverlayView.invalidate();
	}

	@Override
	 protected void proceedSuccessfullFront(String dialogTitleMessage) {		
		showProceedingDialog(dialogTitleMessage, StringUtils.dynamicString(this, "TISFlowPleaseCaptureImageBack"), NEXT_ACTION.CAPTURE_BACK);
	}

	public static class DynamicCameraActivityHandler extends CameraActivityHandler {
		public DynamicCameraActivityHandler(CameraController cameraController, boolean startPreview) {
			super(cameraController, startPreview);
		}



		/** The next frame delay max interval. */
			
//		DynamicCameraActivityHandler(CameraController cameraController, boolean startPreview) {			
//			looperActivity = new WeakReference<CameraController>(cameraController);
//			initProceedingToNextFrameDelay();
//			if (startPreview)
//				startPreview();
//		}
				

		/*
		 * (non-Javadoc)
		 * 
		 * @see android.os.Handler#handleMessage(android.os.Message)
		 */
		final DynamicCaptureCameraController cameraController = (DynamicCaptureCameraController) looperActivity.get();
		@Override
		public void handleMessage(Message message) {
			// if (returnAfterMaxTry){
			// CameraManagerController.
			// }
			try {
				final Bundle messageData = message.getData();
				OCRResult result;

				if (cameraController == null) {
					Logger.e(TAG, "handleMessage cameraController reference is null");
					return;
				}
				Logger.i(TAG, "handler processing message:" + message.what);
				switch (message.what) {
					case CameraTypes.MESSAGE_PROCESS_VALID:
						final Bundle checkRectBundleValid = messageData.getBundle(Constants.INTENT_CHECK_RECT);

						final double orientationValid = messageData.getDouble(Constants.INTENT_ORIENTATION, 0);
						Logger.i("MESSAGE_PROCESS_VALID", "MESSAGE_PROCESS_VALID");
						if (checkRectBundleValid != null && checkRectBundleValid.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_LEFT )!= null){

							if (cameraController.dynamicCameraOverlayView != null) {
								cameraController.dynamicCameraOverlayView.isValidRect = true;
							}
							boolean drawRect = true;

							if (cameraController.dynamicCameraOverlayView != null) {
								cameraController.dynamicCameraOverlayView.isRectFound = drawRect;
								cameraController.dynamicCameraOverlayView.bottomLeft = checkRectBundleValid.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_LEFT);
								cameraController.dynamicCameraOverlayView.bottomRight = checkRectBundleValid.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_RIGHT);
								cameraController.dynamicCameraOverlayView.topRight = checkRectBundleValid.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_RIGHT);
								cameraController.dynamicCameraOverlayView.topLeft = checkRectBundleValid.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_LEFT);
								CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).setVideoQuads(checkRectBundleValid);
							}
							CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectBundleValid);
							if (cameraController.dynamicCameraOverlayView != null)
								cameraController.dynamicCameraOverlayView.invalidate();
						}
						else{
							if (cameraController.dynamicCameraOverlayView != null)
								cameraController.dynamicCameraOverlayView.isRectFound = false;

						}
						if (cameraController.dynamicCameraOverlayView != null)
							cameraController.dynamicCameraOverlayView.invalidate();

						if (cameraController.isDebug || drawFoundedRectangle) {
							if (checkRectBundleValid != null) {
								Rect rect = OCRHelper.bundleToRect(checkRectBundleValid);
								sendEmptyMessageDelayed(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT, CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY);
							}
						}

						if (cameraController.cameraSessionManager.getState() != State.CAPTURING_IMAGE)
							proceedWithProcessing();
						if (CameraManagerController.isDebug) {
							FileUtils.addToLogFile("MESSAGE_PROCESS_VALID", cameraController.getBaseContext());
						}
						break;

					case CameraTypes.MESSAGE_PROCESS_NOT_VALID:
						String hintName = messageData.getString(Constants.INTENT_HINT_NAME);
						final String errorCodeName = messageData.getString(Constants.INTENT_ERROR_CODE);
						final Bundle checkRectBundle = messageData.getBundle(Constants.INTENT_CHECK_RECT);

						final double orientation = messageData.getDouble(Constants.INTENT_ORIENTATION, 0);
						Log.i("MESSAGE_PROCESS_NOT_VALID", "MESSAGE_PROCESS_NOT_VALID");
						if (!StringUtils.isEmptyOrNull(hintName)) {
							HintIndicator hintIndicator = HintIndicator.valueOf(hintName);
							// in no light cell phone may be lying and not in use.
							// if these messages comes in certain frequency in a row we
							// need to update
							// delay the proceeding to next frame.
							checkNextFrameDelay(hintIndicator);
							if (cameraController.cameraOverlayView != null)
								cameraController.cameraOverlayView.showIndicator(hintIndicator, true);

							//cameraController.cameraOverlayView.showCheckBoundyRect(false, null);
						}
						HintIndicator hintIndicator = HintIndicator.None;
						if (checkRectBundle != null && checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_LEFT) != null) {
//					hintIndicator = HintIndicator.ZoomIn;
//					cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);					
							if (!StringUtils.isEmptyOrNull(hintName)) {
								hintIndicator = HintIndicator.valueOf(hintName);
							}

							if (cameraController.dynamicCameraOverlayView != null) {
								cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);

								Log.i("checkRectBundle != null", "checkRectBundle != null");
								cameraController.dynamicCameraOverlayView.isValidRect = false;
							}
							boolean drawRect = true;
							if (hintIndicator == HintIndicator.AspectRatioFailed) {
								hintIndicator = HintIndicator.None;// dont show hint when AR is not match, to be align with iOS.
								drawRect = false;
							}

							if (cameraController.cameraOverlayView != null) {
								cameraController.dynamicCameraOverlayView.isRectFound = drawRect;
								cameraController.dynamicCameraOverlayView.bottomLeft = checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_LEFT);
								cameraController.dynamicCameraOverlayView.bottomRight = checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_RIGHT);
								cameraController.dynamicCameraOverlayView.topRight = checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_RIGHT);
								cameraController.dynamicCameraOverlayView.topLeft = checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_LEFT);
								CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).setVideoQuads(checkRectBundle);
							}
							CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectBundle);
							if (cameraController.dynamicCameraOverlayView != null)
								cameraController.dynamicCameraOverlayView.invalidate();
						} else {
							if (cameraController.dynamicCameraOverlayView != null)
								cameraController.dynamicCameraOverlayView.isRectFound = false;


						}
						if (cameraController.dynamicCameraOverlayView != null)
							cameraController.dynamicCameraOverlayView.invalidate();
						if (!StringUtils.isEmptyOrNull(hintName)) {
							hintIndicator = HintIndicator.valueOf(hintName);
							// in no light cell phone may be lying and not in use.
							// if these messages comes in certain frequency in a row we
							// need to update
							// delay the proceeding to next frame.
							checkNextFrameDelay(hintIndicator);

						}
						if (!StringUtils.isEmptyOrNull(errorCodeName)) {
							final ErrorCode errorCode = ErrorCode.valueOf(errorCodeName);
							if (errorCode == ErrorCode.error_deviceMemory) {
								final String exception = messageData.getString(Constants.INTENT_EXCEPTION_ERROR);
								Intent data = new Intent();
								data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, exception);
								looperActivity.get().setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
								looperActivity.get().finish();
								return;
							}

						}

						if (cameraController.isDebug || drawFoundedRectangle) {
							if (checkRectBundle != null) {
								Rect rect = OCRHelper.bundleToRect(checkRectBundle);

								dispatchHintIndicator(messageData);
								sendEmptyMessageDelayed(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT, CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY);
							}
						}


						proceedWithProcessing();
						if (CameraManagerController.isDebug) {
							FileUtils.addToLogFile("MESSAGE_PROCESS_NOT_VALID", cameraController.getBaseContext());
						}
						break;

					case CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE:
						// cameraController.currentCallBack =
						// TISFlowActionCallback.START_PROCESSING_IMAGE;
						// cameraController.currentError = null;
						// listener.onMessageReceive(cameraController.currentCallBack,
						// cameraController.currentError,
						// null,looperActivity.get().cameraOverlayView.getContext());
						Logger.i(TAG, "MESSAGE_CAPTURE_STILL_IMAGE");

						initProceedingToNextFrameDelay();

						if (cameraController.isFinishing())
							return;

						Bundle bundleCaptureStillImage = messageData;
						if (cameraController.cameraSessionManager.getState() == State.PREVIEW) {
							// cameraSessionManager.update

							final Bundle checkRectCaptureBundle = bundleCaptureStillImage.getBundle(Constants.INTENT_CHECK_RECT);
							Rect rect = OCRHelper.bundleToRect(checkRectCaptureBundle);

							if (cameraController.dynamicCameraOverlayView != null) {
								cameraController.dynamicCameraOverlayView.bottomLeft = checkRectCaptureBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_LEFT);
								cameraController.dynamicCameraOverlayView.bottomRight = checkRectCaptureBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_RIGHT);
								cameraController.dynamicCameraOverlayView.topRight = checkRectCaptureBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_RIGHT);
								cameraController.dynamicCameraOverlayView.topLeft = checkRectCaptureBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_LEFT);

								cameraController.dynamicCameraOverlayView.isValidRect = true;
								cameraController.dynamicCameraOverlayView.isRectFound = true;
							}

							CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectCaptureBundle);
							if (cameraController.dynamicCameraOverlayView != null)
								cameraController.dynamicCameraOverlayView.invalidate();
							hintIndicator = HintIndicator.Hold;
							if (cameraController.dynamicCameraOverlayView != null) {
								cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);
								cameraController.dynamicCameraOverlayView.invalidate();
							}
							if (cameraController.cameraSessionManager.getMatchRectsCounter() >= CameraManagerController.identicalRectanglesToCapture) {
								CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).orientation = bundleCaptureStillImage
										.getDouble(Constants.INTENT_ORIENTATION);

								// to be sure remove all messages
								removeAllMessages();
								captureStillImage();
							} else {
								proceedWithProcessing();
							}
						}
						if (CameraManagerController.isDebug) {
							FileUtils.addToLogFile("MESSAGE_CAPTURE_STILL_IMAGE", cameraController.getBaseContext());
						}
						break;
					case CameraTypes.MESSAGE_BARCODE_DETECTED:
						Logger.i(TAG, "MESSAGE_BARCODE_DETECTED");
						if (cameraController.cameraSessionManager.getState() == State.PREVIEW) {

							OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext());

							String barcodeType = messageData.getString(Constants.BAR_CODE_TYPE);
							String barcodeData = messageData.getString(Constants.BAR_CODE_DATA);

							if (ocrAnalyzeSession.captureMode == CaptureMode.FRONT) {
								ocrAnalyzeSession.setFrontBarcodeType(barcodeType);
								ocrAnalyzeSession.setFrontBarcodeData(barcodeData);
							} else {
								ocrAnalyzeSession.setBackBarcodeType(barcodeType);
								ocrAnalyzeSession.setBackBarcodeData(barcodeData);
							}

							//	cameraController.dynamicCameraOverlayView.startFadeoutAnimationForBoundaries();
							Handler handler = new Handler(cameraController.getApplicationContext().getMainLooper());
							handler.postDelayed(new Runnable() {
								public void run() {
									if (cameraController.dynamicCameraOverlayView != null)
										cameraController.dynamicCameraOverlayView.clearBoundariesRect();
									proceedWithProcessing();
								}
							}, 1000);

							ocrAnalyzeSession.isBarcodeSession = false;
						} else
							proceedWithProcessing();

						break;
					case CameraTypes.MESSAGE_ERROR:
						Logger.i(TAG, "MESSAGE_ERROR");
						if (!CameraManagerController.isStillMode) {
							proceedWithProcessing();
						} else {
							String errorMessage = (String) message.obj;
							Intent data = new Intent();
							Logger.e(TAG, errorMessage);
							data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, errorMessage);
							activity.setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
							activity.finish();
							break;
						}
						if (CameraManagerController.isDebug) {
							FileUtils.addToLogFile("MESSAGE_ERROR", cameraController.getBaseContext());
						}
						break;
					// and the rest as in MESSAGE_PROCESS_CAPTURED_IMAGE
					case CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE:
						Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE");
						if (cameraController.dynamicCameraOverlayView != null) {
							cameraController.dynamicCameraOverlayView.isRectFound = false;
							cameraController.dynamicCameraOverlayView.invalidate();
						}
						if (CameraManagerController.isStillMode) {
							cameraController.cameraSessionManager.stopPreviewOnly();
						}
						if (cameraController.dynamicCameraOverlayView != null)
							cameraController.dynamicCameraOverlayView.showProcessImg();

						String imagePath = (String) message.obj;
						// to be sure, remove all messages
						if (CameraManagerController.isStillMode)
							removeAllMessages();

						if (CameraManagerController.scanBackOnly) { // only for back capture
							// cameraController.startBinarizationAfterFaliure(imagePath);
							cameraController.processCapturedImage(imagePath); // for front capture
							CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).frontImageRect = FileUtils.arrayToRect(getFrontImageArrayValues());
						} else {
							cameraController.processCapturedImage(imagePath); // for front capture
						}

						break;
					default:
						super.handleMessage(message);
				}
			}catch(Exception e){
			activity.setResult(CameraManagerController.RESULT_LIBRARY_ERROR);
			activity.finish();

		  }
		}

		double calAngleBetweenPoints(float[] first, float[] second){
			float heigth1 = (second[1] - first[1]);
			float width1 = (second[0] - first[0]);
			float rads = (float) Math.atan2(heigth1, width1);
			return (180.0 * rads / M_PI);
		}
	}

	@Override
	protected synchronized void prepareForManualCropping(String imagePath) {
		showCroppingController(CameraManagerController.getOcrAnalyzeSession(getInstance()).captureMode == CaptureMode.FRONT);
		new DynamicPrepareForManualCropping().execute(imagePath);
	}

	protected class DynamicPrepareForManualCropping extends PrepareForManualCropping {

		@Override
		protected void prepareHandlerAndProcessingView() {
			if (handler == null)
				handler = new DynamicCaptureCameraController.DynamicCameraActivityHandler(getInstance(), false);

			handler.stopPreview();
			if (dynamicCameraOverlayView != null) {
				dynamicCameraOverlayView.isRectFound = false;
				dynamicCameraOverlayView.invalidate();
				dynamicCameraOverlayView.showProcessImg();
			}

			handler.removeAllMessages();
		}

		@Override
		protected GenericBoundingBoxResult doInBackground(String... params) {
			CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).setImagePath(params[0]);

            // try find bounding box on stills image
			GenericBoundingBoxResult genericBoundingBoxResult = tryFindGenericBoundingBox();

			if (genericBoundingBoxResult == null || genericBoundingBoxResult.width == 0 || genericBoundingBoxResult.height == 0) {


				if (cameraSessionManager.previewCallback.genericBoundingBoxResult == null)
					return null;

                // if no bounding box on still image found, try take last bounding box from video
				genericBoundingBoxResult = cameraSessionManager.previewCallback.lastGenericBoundingBoxWithSize;
				if (genericBoundingBoxResult == null || genericBoundingBoxResult.width == 0 || genericBoundingBoxResult.height == 0)
					return null;

				float xRatio = CameraConfigurationManager.stillWidthRes / CameraConfigurationManager.videoResolutionWidth;
				float yRatio = CameraConfigurationManager.stillHeightRes / CameraConfigurationManager.videoResolutionHeight;

				float[] points = new float[8];
				UserInterfaceUtils.fillPointsArrayFromBoundingBox(points, genericBoundingBoxResult);
				UserInterfaceUtils.convertPointsToRatio(points, new PointF(xRatio, yRatio));
				UserInterfaceUtils.fillGenericBBUsingPointsArr(genericBoundingBoxResult, points);
            }

			return genericBoundingBoxResult;

		}

	}

	@Override
	protected synchronized void cancelAutoCapture() {

		if (handler != null)
			handler.removeAllMessages();

		if (dynamicCameraOverlayView != null) {
			dynamicCameraOverlayView.removeCaptureElements();
			restartInfoScreen();
		}
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
	}

}
