/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import org.opencv.core.Rect;

import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.util.UserInterfaceUtils;

import android.content.Context;
import android.os.Bundle;

// TODO: Auto-generated Javadoc
/**
 * The Class CheckBoundaries.
 */
public class CheckBoundaries {

	/** The Constant CHECK_SIZE_THRESHOLD_WIDTH. */
	private final static int CHECK_SIZE_THRESHOLD_WIDTH = 30;
	
	/** The Constant CHECK_SIZE_THRESHOLD_HEIGHT. */
	private final static int CHECK_SIZE_THRESHOLD_HEIGHT = 35;
	
	/** The Constant DEFAULT_REFERENCE_CHECK_BOUNDARY_SCREEN_WIDTH. */
	private final static int DEFAULT_REFERENCE_CHECK_BOUNDARY_SCREEN_WIDTH = 480;
	
	/** The Constant CHECK_SIZE_MIN_WIDTH. */
	private final static int CHECK_SIZE_MIN_WIDTH = 430;
	//
	/** The Constant defaultRect. */
	public final static Rect defaultRect = new Rect(10, 38, 460, 230);
	
	/** The Constant defaultA4Rect. */
	public final static Rect defaultA4Rect = new Rect(45, 10, 240, 650);
	
	/** The Constant defaultA4RectView. */
	public final static Rect defaultA4RectView = new Rect(10, 55, 150, 600);
	
	/** The min check rect. */
	private Rect minCheckRect;
	
	/** The validation rect. */
	private Rect validationRect;
	
	/** The portarit view rect. */
	private Rect portaritViewRect;
	
	/** The min check rect back. */
	private Rect minCheckRectBack;
	
	/** The validation rect back. */
	private Rect validationRectBack;

	/** The aspect ratio width. */
	private float aspectRatioWidth;
	
	/** The aspect ratio height. */
	private float aspectRatioHeight;
	
	/** The treshhold width. */
	public static float treshholdWidth;
	
	/** The treshhold height. */
	public static float treshholdHeight;
	
	/** The min check width. */
	private int minCheckWidth;
	
	/** The min check width back. */
	private int minCheckWidthBack;
	
	/** The validation rect width. */
	private static float validationRectWidth = 0;
	
	/** The validation rect height. */
	private static float validationRectHeight = 0;

	/** The capture mode. */
	private CaptureMode captureMode;

	/** The scale of the default rectangle. */
	private float defaultRectScale = 1.0f;

	/**
	 * Instantiates a new check boundaries.
	 *
	 * @param context the context
	 * @param captureMode the capture mode
	 * @param isUseCustomAlgorithmForBack the is use custom algorithm for back
	 * @param displayWidth the display width
	 * @param displayHeight the display height
	 * @param hwRatioMin the hw ratio min
	 * @param hwRatioMax the hw ratio max
	 * @param hwRatioMinBack the hw ratio min back
	 * @param hwRatioMaxBack the hw ratio max back
	 */
	public CheckBoundaries(Context context, CaptureMode captureMode, boolean isUseCustomAlgorithmForBack,
			int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack,
			float hwRatioMaxBack) {

		this(context, captureMode, isUseCustomAlgorithmForBack,
				displayWidth, displayHeight, hwRatioMin, hwRatioMax, hwRatioMinBack,
				hwRatioMaxBack, 1.0f);
	}
	
	
	/**
	 * Instantiates a new check boundaries.
	 *
	 * @param context the context
	 * @param captureMode the capture mode
	 * @param isUseCustomAlgorithmForBack the is use custom algorithm for back
	 * @param displayWidth the display width
	 * @param displayHeight the display height
	 * @param hwRatioMin the hw ratio min
	 * @param hwRatioMax the hw ratio max
	 * @param hwRatioMinBack the hw ratio min back
	 * @param hwRatioMaxBack the hw ratio max back
	 * @param scale for changing size of rectangle
	 */
	public CheckBoundaries(Context context, CaptureMode captureMode, boolean isUseCustomAlgorithmForBack,
			int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack,
			float hwRatioMaxBack, float scale) {

		defaultRectScale = scale;
		
		updateValidationRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax,
				hwRatioMinBack, hwRatioMaxBack);

		updateMinCheckRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax,
				hwRatioMinBack, hwRatioMaxBack);
		
		this.captureMode = captureMode;
		float ocrValidationRatio = (defaultRect.height * defaultRectScale) / (defaultRect.width * defaultRectScale);
		aspectRatioWidth = displayWidth / (DEFAULT_REFERENCE_CHECK_BOUNDARY_SCREEN_WIDTH * defaultRectScale);
		aspectRatioHeight = aspectRatioWidth * ocrValidationRatio;
		treshholdWidth = CHECK_SIZE_THRESHOLD_WIDTH * aspectRatioWidth;
		treshholdHeight = CHECK_SIZE_THRESHOLD_HEIGHT * aspectRatioWidth;

		// check rect
		updateValidationRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax,
				hwRatioMinBack, hwRatioMaxBack);

		updateMinCheckRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax,
				hwRatioMinBack, hwRatioMaxBack);
	}

	public void setValidationRect(Rect rect){
		validationRect = rect;
	}

	/**
	 * Update min check rect.
	 *
	 * @param isUseCustomAlgorithmForBack the is use custom algorithm for back
	 * @param displayWidth the display width
	 * @param displayHeight the display height
	 * @param hwRatioMin the hw ratio min
	 * @param hwRatioMax the hw ratio max
	 * @param hwRatioMinBack the hw ratio min back
	 * @param hwRatioMaxBack the hw ratio max back
	 */
	private void updateMinCheckRect(boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight,
			float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack) {
		minCheckRect = new Rect();

		// min check rect
		//float scaleFactor = (validationRect.width * 1.0f) / (defaultRect.width * 1.0f);
		float scaleFactor = (validationRect.width * defaultRectScale) / (defaultRect.width * defaultRectScale);
		float minWidth = CHECK_SIZE_MIN_WIDTH * scaleFactor;
		float minHeight = minWidth * hwRatioMin;

		updateRect(displayWidth, displayHeight, minWidth, minHeight, minCheckRect);

		minCheckRectBack = new Rect(minCheckRect.x, minCheckRect.y, minCheckRect.width, minCheckRect.height);
		if (isUseCustomAlgorithmForBack) {
			float hwRatioMidBack = (hwRatioMaxBack + hwRatioMinBack) / 2;
			float heightBack = minWidth * hwRatioMidBack;
			float widthBack = minWidth;

			if (heightBack > minHeight) {
				float scaleHRatio = heightBack / minHeight;
				heightBack = heightBack / scaleHRatio;
				widthBack = heightBack / hwRatioMaxBack;
			}

			updateRect(displayWidth, displayHeight, widthBack, heightBack, minCheckRectBack);
		}
	}

	/**
	 * Update validation rect.
	 *
	 * @param isUseCustomAlgorithmForBack the is use custom algorithm for back
	 * @param displayWidth the display width
	 * @param displayHeight the display height
	 * @param hwRatioMin the hw ratio min
	 * @param hwRatioMax the hw ratio max
	 * @param hwRatioMinBack the hw ratio min back
	 * @param hwRatioMaxBack the hw ratio max back
	 */
	private void updateValidationRect(boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight,
			float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack) {

//		if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE) {
//			hwRatioMin = 1.25f;
//			hwRatioMax = 1.3426f;
//		}

		validationRect = new Rect();
		validationRect.x = (int) ((defaultRect.x/defaultRectScale) * aspectRatioWidth);
		validationRect.y = (int) ((defaultRect.y/defaultRectScale) * aspectRatioHeight);
		float hwRatioMid = (hwRatioMax + hwRatioMin) / 2;
		// validation check rect
		validationRectWidth = displayWidth - (validationRect.x * 2);
		if (validationRectHeight == 0) {
			validationRectHeight = displayHeight - (validationRect.y * 2 + (int) (100 * aspectRatioHeight));
		} else if (CameraManagerController.deviceName != null) {
			validationRectHeight = displayHeight - (validationRect.y * 2 + (int) (100 * aspectRatioHeight));
		}
		float currentRatio = validationRectHeight / validationRectWidth;
		if (currentRatio > hwRatioMid) {
			validationRectHeight = hwRatioMid * validationRectWidth;
		} else {
			validationRectWidth = validationRectHeight / hwRatioMid;
		}
		updateRect(displayWidth, displayHeight, validationRectWidth, validationRectHeight, validationRect);

		// back
		validationRectBack = new Rect(validationRect.x, validationRect.y, validationRect.width, validationRect.height);
		if (isUseCustomAlgorithmForBack) {
			float hwRatioMidBack = (hwRatioMaxBack + hwRatioMinBack) / 2;
			float heightBack = validationRectWidth * hwRatioMidBack;
			float widthBack = validationRectWidth;

			if (heightBack > validationRectHeight) {
				float scaleHRatio = heightBack / validationRectHeight;
				heightBack = heightBack / scaleHRatio;
				widthBack = heightBack / hwRatioMidBack;
			}

			updateRect(displayWidth, displayHeight, widthBack, heightBack, validationRectBack);
		}
	}

	/**
	 * Instantiates a new check boundaries.
	 *
	 * @param bundle the bundle
	 */
	public CheckBoundaries(Bundle bundle) {
		validationRect = UserInterfaceUtils.bundleToRect(bundle.getBundle("validationRect"));
		minCheckRect = UserInterfaceUtils.bundleToRect(bundle.getBundle("minCheckRect"));
		validationRectBack = UserInterfaceUtils.bundleToRect(bundle.getBundle("validationRectBack"));
		minCheckRectBack = UserInterfaceUtils.bundleToRect(bundle.getBundle("minCheckRectBack"));

		aspectRatioWidth = bundle.getFloat("aspectRatioWidth");
		aspectRatioHeight = bundle.getFloat("aspectRatioHeight");
		treshholdWidth = bundle.getFloat("treshholdWidth");
		treshholdHeight = bundle.getFloat("treshholdHeight");
		minCheckWidth = bundle.getInt("minCheckWidth");
	}

	/**
	 * Sets the capture mode.
	 *
	 * @param captureMode the new capture mode
	 */
	public void setCaptureMode(CaptureMode captureMode) {
		this.captureMode = captureMode;
	}

	/**
	 * Update rect.
	 *
	 * @param displayWidth the display width
	 * @param displayHeight the display height
	 * @param width the width
	 * @param height the height
	 * @param rect the rect
	 */
	private void updateRect(int displayWidth, int displayHeight, float width, float height, Rect rect) {
		rect.width = (int) width;
		rect.height = (int) height;
		rect.x = (displayWidth - rect.width) / 2;
		rect.y = (int) ((displayHeight - rect.height) / 2.5);
	}

	/**
	 * Gets the validation boundaries rect by capture mode.
	 *
	 * @return the validation boundaries rect by capture mode
	 */
	public Rect getValidationBoundariesRectByCaptureMode() {
		return (captureMode == CaptureMode.FRONT) ? validationRect : validationRectBack;
	}

	/**
	 * Gets the portrait view rect.
	 *
	 * @return the portrait view rect
	 */
	public Rect getPortraitViewRect() {
		return portaritViewRect;
	}

	/**
	 * Gets the validation rect.
	 *
	 * @return the validation rect
	 */
	public Rect getValidationRect() {
		return validationRect;
	}
	/**
	 * Gets the validation rect back.
	 *
	 * @return the validation rect back
	 */
	public Rect getValidationRectBack() {
		return validationRectBack;
	}

	/**
	 * Gets the min check rect by capture mode.
	 *
	 * @return the min check rect by capture mode
	 */
	public Rect getMinCheckRectByCaptureMode() {
		return (captureMode == CaptureMode.FRONT) ? minCheckRect : minCheckRectBack;
	}

	/**
	 * Gets the min check rect.
	 *
	 * @return the min check rect
	 */
	public Rect getMinCheckRect() {
		return minCheckRect;
	}

	/**
	 * Gets the min check rect back.
	 *
	 * @return the min check rect back
	 */
	public Rect getMinCheckRectBack() {
		return minCheckRectBack;
	}

	/**
	 * Gets the aspect ratio.
	 *
	 * @return the aspect ratio
	 */
	public float getAspectRatio() {
		return aspectRatioWidth;
	}

	/**
	 * Gets the min check width.
	 *
	 * @return the min check width
	 */
	public int getMinCheckWidth() {
		return (captureMode == CaptureMode.FRONT) ? minCheckWidth : minCheckWidthBack;
	}

	/**
	 * Gets the min boundary x.
	 *
	 * @param isTreshhold the is treshhold
	 * @return the min boundary x
	 */
	public int getMinBoundaryX(boolean isTreshhold) {
		if (captureMode == CaptureMode.FRONT) {
			return (int) ((isTreshhold) ? validationRect.x - treshholdWidth : validationRect.x);
		} else {
			return (int) ((isTreshhold) ? validationRectBack.x - treshholdWidth : validationRectBack.x);
		}
	}

	/**
	 * Gets the max boundary x.
	 *
	 * @param isTreshhold the is treshhold
	 * @return the max boundary x
	 */
	public int getMaxBoundaryX(boolean isTreshhold) {
		if (captureMode == CaptureMode.FRONT) {
			return (int) ((isTreshhold) ? validationRect.x + validationRect.width + treshholdWidth : validationRect.x
					+ validationRect.width);
		} else {
			return (int) ((isTreshhold) ? validationRectBack.x + validationRectBack.width + treshholdWidth
					: validationRectBack.x + validationRectBack.width);
		}
	}

	/**
	 * Gets the min boundary y.
	 *
	 * @param isTreshhold the is treshhold
	 * @return the min boundary y
	 */
	public int getMinBoundaryY(boolean isTreshhold) {
		if (captureMode == CaptureMode.FRONT) {
			return (int) ((isTreshhold) ? validationRect.y - treshholdHeight : validationRect.y);
		} else {
			return (int) ((isTreshhold) ? validationRectBack.y - treshholdHeight : validationRectBack.y);
		}
	}

	/**
	 * Gets the max boundary y.
	 *
	 * @param isTreshhold the is treshhold
	 * @return the max boundary y
	 */
	public int getMaxBoundaryY(boolean isTreshhold) {
		if (captureMode == CaptureMode.FRONT) {
			return (int) ((isTreshhold) ? validationRect.y + validationRect.height + treshholdHeight : validationRect.y
					+ validationRect.height);
		} else {
			return (int) ((isTreshhold) ? validationRectBack.y + validationRectBack.height + treshholdHeight
					: validationRectBack.y + validationRectBack.height);
		}
	}

	/**
	 * To bundle.
	 *
	 * @return the bundle
	 */
	public Bundle toBundle() {
		Bundle bundle = new Bundle();
		bundle.putBundle("validationRect", UserInterfaceUtils.rectToBundle(validationRect));
		bundle.putBundle("minCheckRect", UserInterfaceUtils.rectToBundle(minCheckRect));
		bundle.putBundle("validationRectBack", UserInterfaceUtils.rectToBundle(validationRectBack));
		bundle.putBundle("minCheckRectBack", UserInterfaceUtils.rectToBundle(minCheckRectBack));
		// bundle.putBundle("maxCheckRect", UIUtils.rectToBundle(maxCheckRect));
		bundle.putFloat("aspectRatioWidth", aspectRatioWidth);
		bundle.putFloat("aspectRatioHeight", aspectRatioHeight);
		bundle.putFloat("treshholdWidth", treshholdWidth);
		bundle.putFloat("treshholdHeight", treshholdHeight);
		bundle.putInt("minCheckWidth", minCheckWidth);
		return bundle;
	}
}