/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import java.util.ArrayList;
import java.util.List;



// TODO: Auto-generated Javadoc
/**
 * The Class CameraTypes.
 */
public class CameraTypes {

	/**
	 * The Enum CaptureMode.
	 */
	public enum CaptureMode {

		/** The front. */
		FRONT,
		/** The back. */
		BACK;
	}

	public enum TISFlowGeneralMessages {

		/** The capture back. */
		CAPTURE_BACK,
		/** The multi capture. */
		MULTI_CAPTURE,
		/** The start processing image. */
		BACK_PRESSED,
		PAN_CARD_OCR_RESULT,
		PASSPORT_OCR_RESULT,
		CHECK_OCR_RESULT,
		ID_CARD_OCR_RESULT,
		CREDIT_CARD_OCR_RESULT
		}

	public enum TISFlowInputMessages {
		/** The cancel session. */
		CANCEL_SESSION,
		/** The continue mobi flow. */
		CONTINUE_MOBI_FLOW,
		/** The continue mobi flow custom ui. */
		CONTINUE_MOBI_FLOW_CUSTOM_UI,
		OCR_RESULT_FAILED,
		CONTINUE_CURRENT_SESSION,
		OCR_RESULT_OK
	}
	
	/**
	 * The Enum NEXT_ACTION.
	 */
	public enum NEXT_ACTION {

		/** The capture front. */
		CAPTURE_FRONT,
		/** The capture back. */
		CAPTURE_BACK,
		/** The process image for server. */
		PROCESS_IMAGE_FOR_SERVER,
	}
	
	
	public enum TISBarcodeType {
		UPCE_CODE(1),
		CODE_39_CODE(2),
		CODE_39_MOD_43_CODE(3),
		EAN_13_CODE(4),
		EAN_8_CODE(5),
		CODE_93_CODE(6),
		CODE_128_CODE(7),
		PDF_417_CODE(8),
		QR_CODE(9),
		AZTEC_CODE(10),
		INTERLEAVED_2_OF_5_CODE(11),
		ITF_14_CODE(12),
		DATA_MATRIX_CODE(13);
		
		/** The value. */
		private int value;

		/**
		 * Instantiates a new update ui action.
		 *
		 * @param value the value
		 */
		TISBarcodeType(int value) {
			this.value = value;
		}

		/**
		 * Gets the value.
		 *
		 * @return the value
		 */
		public int getValue() {
			return value;
		}
		
		/**
		 * converts integer ArrayList to Enum ArrayList.
		 *
		 * @return Enum ArrayList
		 */
		public static ArrayList<TISBarcodeType> getEnumArrayListFromIntegerList(List<Integer> list) {
			if (list == null)
				return null;
			
			ArrayList<TISBarcodeType> enumList = new ArrayList<CameraTypes.TISBarcodeType>();
			for (int item: list){
				enumList.add(getEnum(item));
			}
			
			return enumList;
			
		}
		
		/**
		 * converts enum ArrayList to integer ArrayList.
		 *
		 * @return integer ArrayList
		 */
		public static ArrayList<Integer> getIntegerArrayListFromEnumList(List<TISBarcodeType> list) {
			if (list == null)
				return null;
			
			ArrayList<Integer> integerList = new ArrayList<Integer>();
			for (TISBarcodeType item: list){
				integerList.add(item.getValue());
			}
			
			return integerList;
			
		}
		
		
		
		/**
		 * Gets enum.
		 *
		 * @return the enum
		 */
		public static TISBarcodeType getEnum(int value) {
			switch (value) {
			case 1:
				return UPCE_CODE;
			case 2:
				return CODE_39_CODE;
			case 3:
				return CODE_39_MOD_43_CODE;
			case 4:
				return EAN_13_CODE;
			case 5:
				return EAN_8_CODE;
			case 6:
				return CODE_93_CODE;
			case 7:
				return CODE_128_CODE;
			case 8:
				return PDF_417_CODE;
			case 9:
				return QR_CODE;
			case 10:
				return AZTEC_CODE;
			case 11:
				return INTERLEAVED_2_OF_5_CODE;
			case 12:
				return ITF_14_CODE;
			case 13:
				return DATA_MATRIX_CODE;
			}
			
			return null;
		}
		
		
	}
	

	/** The Constant MESSAGE_PROCESS_DATA. */
	final static public int MESSAGE_PROCESS_DATA = 1;

	/** The Constant MESSAGE_QUIT. */
	final static public int MESSAGE_QUIT = 2;

	/** The Constant MESSAGE_AUTO_FOCUS. */
	final static public int MESSAGE_AUTO_FOCUS = 3;

	/** The Constant MESSAGE_RESTART_PREVIEW. */
	final static public int MESSAGE_RESTART_PREVIEW = 4;

	/** The Constant MESSAGE_PROCESS_NOT_VALID. */
	final static public int MESSAGE_PROCESS_NOT_VALID = 6;

	/** The Constant MESSAGE_CAPTURE_STILL_IMAGE. */
	final static public int MESSAGE_CAPTURE_STILL_IMAGE = 7;

	/** The Constant MESSAGE_PROCESS_CAPTURED_IMAGE. */
	final static public int MESSAGE_PROCESS_CAPTURED_IMAGE = 8;

	/** The Constant MESSAGE_PROCESS_PRE_CAPTURED_IMAGE. */
	final static public int MESSAGE_PROCESS_PRE_CAPTURED_IMAGE = 9;

	/** The Constant MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT. */
	final static public int MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT = 10;

	/**  indicators. */
	final static public int MESSAGE_SHOW_COUNTER = 11;

	/** The Constant MESSAGE_SHOW_PROCESSING_LABEL. */
	final static public int MESSAGE_SHOW_PROCESSING_LABEL = 12;

	/** The Constant MESSAGE_HIDE_HINT_INDICATOR. */
	final static public int MESSAGE_HIDE_HINT_INDICATOR = 13;

	/** The Constant MESSAGE_HIDE_BOUNDARIES_RECT. */
	final static public int MESSAGE_HIDE_BOUNDARIES_RECT = 14;

	/** The Constant MESSAGE_HIDE_ERROR_MESSAGE. */
	final static public int MESSAGE_HIDE_ERROR_MESSAGE = 15;

	/** The Constant MESSAGE_TOGGLE_TORCH. */
	final static public int MESSAGE_TOGGLE_TORCH = 16;

	/** The Constant MESSAGE_INFO. */
	final static public int MESSAGE_INFO = 17;

	/** The Constant MESSAGE_ERROR. */
	final static public int MESSAGE_ERROR = 18;

	/** The Constant MESSAGE_CONTINUE_ANYWAY. */
	final static public int MESSAGE_CONTINUE_ANYWAY = 19;

	/** The Constant MESSAGE_BARCODE_DETECTED. */
	final static public int MESSAGE_BARCODE_DETECTED = 20;

	/** The Constant MESSAGE_BARCODE_ANIMATION_FINISHED. */
	final static public int MESSAGE_BARCODE_ANIMATION_FINISHED = 21;
	final static public int PASSPORT_RESULT = 22;
	final static public int PAN_CARD_RESULT = 23;
	final static public int CHECK_MICR_RESULT = 24;
	final static public int ID_CARD_RESULT = 25;
	final static public int MESSAGE_CREDIT_CARD_RESULT = 26;

	final static public int MESSAGE_DISPLAY_CROPPING_CONTROLLER = 27;
	final static public int MESSAGE_FINISH_CROPPING_CONTROLLER = 28;
	/** The Constant MESSAGE_PROCESS_NOT_VALID. */
	final static public int MESSAGE_PROCESS_VALID = 29;

	/**
	 * The Enum OCRAnalyzeErrorCode.
	 */
	public enum OCRAnalyzeErrorCode {

		/** The none. */
		NONE,
		/** The TIS flow error micr reading check. */				
		FAILED_READING_OCR_GENERAL,
		/** The failed preparing image. */
		FAILED_PREPARING_IMAGE,
		/** The failed preparing image general. */
		FAILED_PREPARING_IMAGE_GENERAL,
		/** The TIS flow error micr length. */
		ERROR_MICR_LENGTH,
		/** The TIS flow error reading check contrast. */
		TISFlowErrorReadingCheckContrast,
		/** The TIS flow error max retries. */
		TISFlowErrorMaxRetries,
		/** The TIS flow error micr interrupted. */
		TISFlowErrorMicrInterrupted,

		/** The TIS flow error micr on back. */
		TISFlowErrorMicrOnBack

	};

	/**
	 * The Enum TISFlowErrorCode.
	 */
	public enum TISFlowErrorMessage {

		/** The error general fail. */
		ERROR_GENERAL_FAIL,
		/** The error max retries. */
		ERROR_MAX_RETRIES,
		/** The error micr reading check. */
		ERROR_MICR_READING_CHECK,
		/** The error reading check contrast. */
		ERROR_IMAGE_CONTRAST,
		/** The error no valid bounding box. */
		ERROR_NO_VALID_BOUNDING_BOX,
		/** The error iqa corner data. */
		ERROR_IQA_CORNER_DATA,
		/** The error iqa edge data. */
		ERROR_IQA_EDGE_DATA,
		/** The error iqa skew. */
		ERROR_IQA_SKEW,
		/** The error iqa darkness. */
		ERROR_IQA_DARKNESS,
		/** The error iqa num spots. */
		ERROR_IQA_NUM_SPOTS,

		ERROR_IQA_PIGGY_BACK,

		ERROR_IQA_HORIZONTAL_STREAK,

		ERROR_IQA_CARBON_STRIP,

		/** The error blur detected. */
		ERROR_BLUR_DETECTED,
		/** The error micr lenght. */
		ERROR_MICR_LENGHT,
		/** The unsupported camera. */
		UNSUPPORTED_CAMERA,
		/** The unsportted auto focus. */
		UNSPORTTED_AUTO_FOCUS,
		/** The unsportted cpu. */
		UNSPORTTED_CPU,
		
		ERROR_OCR_READING,
		/** The error micr interuppted. */
		ERROR_MICR_INTERUPPTED,

		/** The error micr on back. */
		ERROR_MICR_ON_BACK,

		/** The error micr on back. */
		ERROR_IQA_IMAGE_DIMENTIONS;

	}



	/**
	 * The Enum CustomUICallbackMessage.
	 */
	public enum TISFlowUIMessages {

		/** The refresh layout. */
		INIT_LAYOUT,
		BEFORE_PROCESSING,
		AFTER_PROCESSING,
		/** The back pressed. */		
		HINT_CHANGED,
		INSTRUCTION_CHANGED;
	}

	/**
	 * The Enum UpdateUiAction.
	 */
	public enum UpdateUiAction {

		/** The show error message. */
		SHOW_ERROR_MESSAGE(1),
		/** The show counter. */
		SHOW_COUNTER(2),
		/** The show orientation label. */
		SHOW_ORIENTATION_LABEL(4),
		/** The capture still image. */
		CAPTURE_STILL_IMAGE(8),
		/** The process captured image. */
		PROCESS_CAPTURED_IMAGE(25),
		/** The show hint indicator. */
		SHOW_HINT_INDICATOR(32),
		/** The show boundaries rect. */
		SHOW_BOUNDARIES_RECT(64),
		/** The show boundaries. */
		SHOW_BOUNDARIES(128);

		/** The value. */
		int value;

		/**
		 * Instantiates a new update ui action.
		 *
		 * @param value the value
		 */
		UpdateUiAction(int value) {
			this.value = value;
		}

		/**
		 * Gets the value.
		 *
		 * @return the value
		 */
		public int getValue() {
			return value;
		}
	};

	/**
	 * The Enum HintIndicator.
	 */
	public enum HintIndicator {

		/** The Check to top. */
		CheckToTop(0, CameraManagerController.indicatorString[0]),
		/** The Check to bottom. */
		CheckToBottom(1, CameraManagerController.indicatorString[1]),
		/** The Check to left. */
		CheckToLeft(2, CameraManagerController.indicatorString[2]),
		/** The Check to right. */
		CheckToRight(3, CameraManagerController.indicatorString[3]),
		/** The Hold. */
		Hold(4, CameraManagerController.indicatorString[4]),
		/** The Align. */
		Align(5, CameraManagerController.indicatorString[5]),
		/** The Rotate left. */
		RotateLeft(6, CameraManagerController.indicatorString[6]),
		/** The Rotate right. */
		RotateRight(7, CameraManagerController.indicatorString[7]),
		/** The Zoom in. */
		ZoomIn(8, CameraManagerController.indicatorString[8]),
		/** The Zoom out. */
		ZoomOut(9, CameraManagerController.indicatorString[9]),
		/** The No light. */
		NoLight(10, CameraManagerController.indicatorString[10]),
		/** The Blur. */
		Blur(11, CameraManagerController.indicatorString[11]),
		/** The None. */
		None(12, ""),
		/** The Hold flat. */
		HoldFlat(13, CameraManagerController.indicatorString[12]),
		/** The Hold flat. */
		MoveToBARCODE(14, CameraManagerController.indicatorString[13]),
		AspectRatioFailed(15, CameraManagerController.indicatorString[14]),
		AlignCreditBoundaries(16, CameraManagerController.indicatorString[15]),
		invalidRotation(17, CameraManagerController.indicatorString[16]);

		/** The id. */
		int id;

		/** The text. */
		String text;

		/**
		 * Instantiates a new hint indicator.
		 *
		 * @param id the id
		 * @param text the text
		 */
		private HintIndicator(int id, String text) {
			this.id = id;

			this.text = text;
		}

		/**
		 * Gets the id.
		 *
		 * @return the id
		 */
		public int getId() {
			return id;
		}

		/**
		 * Gets the text.
		 *
		 * @return the text
		 */
		public String getText() {
			return text;
		}
	}
	
	
}
