/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.util;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptLib {
    Cipher _cx = Cipher.getInstance("AES/CBC/PKCS5Padding");
    public byte[] _key = new byte[32];
    public byte[] _iv = new byte[16];

    public static final String md5(String inputString) {
        String MD5 = "MD5";
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(inputString.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            byte[] byArray = messageDigest;
            int n = messageDigest.length;
            int n2 = 0;
            while (n2 < n) {
                byte aMessageDigest = byArray[n2];
                String h = Integer.toHexString(0xFF & aMessageDigest);
                while (h.length() < 2) {
                    h = "0" + h;
                }
                hexString.append(h);
                ++n2;
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public byte[] encryptDecryptImage(byte[] _inputImage, String _encryptionKey, EncryptMode _mode) throws UnsupportedEncodingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] _out = new byte[100000];
        int len = _encryptionKey.getBytes("ASCII").length;
        if (_encryptionKey.getBytes("ASCII").length > this._key.length) {
            len = this._key.length;
        }
        System.arraycopy(_encryptionKey.getBytes("ASCII"), 0, this._key, 0, len);
        SecretKeySpec keySpec = new SecretKeySpec(this._key, "AES");
        this._iv = new byte[16];
        Arrays.fill(this._iv, (byte)0);
        IvParameterSpec ivSpec = new IvParameterSpec(this._iv);
        if (_mode.equals((Object)EncryptMode.ENCRYPT)) {
            this._cx.init(1, (Key)keySpec, ivSpec);
            _out = this._cx.doFinal(_inputImage);
        }
        if (_mode.equals((Object)EncryptMode.DECRYPT)) {
            this._cx.init(2, (Key)keySpec, ivSpec);
            _out = this._cx.doFinal(_inputImage);
        }
        return _out;
    }

    private String encryptDecrypt(String _inputText, String _encryptionKey, EncryptMode _mode, String _initVector) throws UnsupportedEncodingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        String _out = "";
        int len = _encryptionKey.getBytes("ASCII").length;
        if (_encryptionKey.getBytes("ASCII").length > this._key.length) {
            len = this._key.length;
        }
        System.arraycopy(_encryptionKey.getBytes("ASCII"), 0, this._key, 0, len);
        SecretKeySpec keySpec = new SecretKeySpec(this._key, "AES");
        if (this._iv != null && this._iv.length < 1) {
            this._iv = new byte[16];
            Arrays.fill(this._iv, (byte)0);
        }
        IvParameterSpec ivSpec = new IvParameterSpec(this._iv);
        if (_mode.equals((Object)EncryptMode.ENCRYPT)) {
            this._cx.init(1, (Key)keySpec, ivSpec);
            byte[] results = this._cx.doFinal(_inputText.getBytes("UTF-8"));
            _out = Base64.encodeToString((byte[])results, (int)0);
        }
        if (_mode.equals((Object)EncryptMode.DECRYPT)) {
            this._cx.init(2, (Key)keySpec, ivSpec);
            byte[] decodedValue = Base64.decode((byte[])_inputText.getBytes(), (int)0);
            byte[] decryptedVal = this._cx.doFinal(decodedValue);
            _out = new String(decryptedVal, Charset.forName("UTF-8"));
        }
        return _out;
    }

    public static String SHA256(String text, int length) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(text.getBytes("UTF-8"));
        byte[] digest = md.digest();
        StringBuffer result = new StringBuffer();
        byte[] byArray = digest;
        int n = digest.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            result.append(String.format("%02x", b));
            ++n2;
        }
        String resultStr = length > result.toString().length() ? result.toString() : result.toString().substring(0, length);
        return resultStr;
    }

    public byte[] encryptImage(byte[] _image, String _key) throws InvalidKeyException, UnsupportedEncodingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.encryptDecryptImage(_image, _key, EncryptMode.ENCRYPT);
    }

    public byte[] decryptImage(byte[] _encryptedImage, String _key) throws InvalidKeyException, UnsupportedEncodingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.encryptDecryptImage(_encryptedImage, _key, EncryptMode.DECRYPT);
    }

    public String encrypt(String _plainText, String _key, String _iv) throws InvalidKeyException, UnsupportedEncodingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.encryptDecrypt(_plainText, _key, EncryptMode.ENCRYPT, _iv);
    }

    public String decrypt(String _encryptedText, String _key, String _iv) throws InvalidKeyException, UnsupportedEncodingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.encryptDecrypt(_encryptedText, _key, EncryptMode.DECRYPT, _iv);
    }

    public static String generateRandomIV(int length) {
        SecureRandom ranGen = new SecureRandom();
        byte[] aesKey = new byte[16];
        ranGen.nextBytes(aesKey);
        StringBuffer result = new StringBuffer();
        byte[] byArray = aesKey;
        int n = aesKey.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            result.append(String.format("%02x", b));
            ++n2;
        }
        if (length > result.toString().length()) {
            return result.toString();
        }
        return result.toString().substring(0, length);
    }

    public static enum EncryptMode {
        ENCRYPT,
        DECRYPT;

    }
}

