/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import com.topimagesystems.ui.CheckBounderiesView;

public class CreditCardBoundariesView
extends CheckBounderiesView {
    private static final int GUIDE_STROKE_WIDTH = 15;
    public boolean complete;
    public boolean topEdge;
    public boolean bottomEdge;
    public boolean leftEdge;
    public boolean rightEdge;
    public boolean infoAvailable;
    private int guideColor = -16711936;
    private final boolean useRegularBoundaries = true;
    private final Paint mGuidePaint = new Paint(1);
    private int mRotationFlip;
    private float mScale = 1.0f;

    public CreditCardBoundariesView(Context context) {
        super(context);
    }

    public CreditCardBoundariesView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CreditCardBoundariesView(Context arg0, AttributeSet arg1, int arg2) {
        super(arg0, arg1, arg2);
    }

    int numVisibleEdges() {
        return (this.topEdge ? 1 : 0) + (this.bottomEdge ? 1 : 0) + (this.leftEdge ? 1 : 0) + (this.rightEdge ? 1 : 0);
    }

    @Override
    protected void drawDocumentBoundaries(Canvas canvas) {
        this.showBounderies(this.numVisibleEdges() == 4, true);
        super.drawDocumentBoundaries(canvas);
    }

    private Rect guideStrokeRect(int x1, int y1, int x2, int y2) {
        int t2 = (int)(7.0f * this.mScale);
        Rect r = new Rect();
        r.left = Math.min(x1, x2) - t2;
        r.right = Math.max(x1, x2) + t2;
        r.top = Math.min(y1, y2) - t2;
        r.bottom = Math.max(y1, y2) + t2;
        return r;
    }

    public void updatedEdges(boolean[] edges) {
        this.infoAvailable = true;
        this.leftEdge = edges[0];
        this.topEdge = edges[1];
        this.rightEdge = edges[2];
        this.bottomEdge = edges[3];
    }
}

