/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.util.Logger;

final class PeriodicAutoFocusCallback
implements Camera.AutoFocusCallback {
    private static final String TAG = Logger.makeLogTag("PeriodicAutoFocusCallback");
    private Handler autoFocusHandler;
    private int autoFocusMessage;
    private static int periodicAutoFocusFaliureCounter = 0;

    PeriodicAutoFocusCallback() {
    }

    void setHandler(Handler autoFocusHandler, int autoFocusMessage) {
        this.autoFocusHandler = autoFocusHandler;
        this.autoFocusMessage = autoFocusMessage;
        periodicAutoFocusFaliureCounter = 0;
    }

    public static int getLastAutoFocusResult() {
        return periodicAutoFocusFaliureCounter;
    }

    public void onAutoFocus(boolean success, Camera camera) {
        CameraSessionManager.hasFocus = success;
        if (this.autoFocusHandler != null) {
            Message message = this.autoFocusHandler.obtainMessage(this.autoFocusMessage, (Object)success);
            this.autoFocusHandler.sendMessageDelayed(message, CameraConfigurationManager.AUTOFOCUS_INTERVAL);
            periodicAutoFocusFaliureCounter = !success ? ++periodicAutoFocusFaliureCounter : 0;
        } else {
            Logger.i(TAG, "but no handler for it");
        }
    }
}

