/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.content.Intent;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.DynamicCameraOverlayLayout;
import com.topimagesystems.controllers.imageanalyze.OCRAnalyzeSession;
import com.topimagesystems.controllers.imageanalyze.OCRHelper;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import com.topimagesystems.util.UserInterfaceUtils;
import org.opencv.core.Rect;

public class DynamicCaptureCameraController
extends CameraController
implements CaptureIntent.callbackReturnMessage {
    static double M_PI = Math.PI;
    private DynamicCameraOverlayLayout dynamicCameraOverlayView;

    @Override
    protected void setOverlay() {
        OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
        activity = this;
        this.dynamicCameraOverlayView = (DynamicCameraOverlayLayout)this.getLayoutInflater().inflate(R.layout.dynamic_capture_overlay, null);
        this.cameraOverlayView = this.dynamicCameraOverlayView;
        this.dynamicCameraOverlayView.setIsTorchOn(ocrAnalyzeSession.isTorchOn);
        this.dynamicCameraOverlayView.setIsManualCapture(ocrAnalyzeSession.isManualCapture);
        this.dynamicCameraOverlayView.setActionClickListener(new CameraController.ActionClickListenerImpl(this));
        this.dynamicCameraOverlayView.setWillNotDraw(false);
        this.dynamicCameraOverlayView.invalidate();
    }

    @Override
    protected void proceedSuccessfullFront(String dialogTitleMessage) {
        this.showProceedingDialog(dialogTitleMessage, StringUtils.dynamicString((Context)this, "TISFlowPleaseCaptureImageBack"), CameraTypes.NEXT_ACTION.CAPTURE_BACK);
    }

    @Override
    protected synchronized void prepareForManualCropping(String imagePath) {
        this.showCroppingController(CameraManagerController.getOcrAnalyzeSession((Context)DynamicCaptureCameraController.getInstance()).captureMode == CameraTypes.CaptureMode.FRONT);
        new DynamicPrepareForManualCropping().execute(new String[]{imagePath});
    }

    @Override
    protected synchronized void cancelAutoCapture() {
        if (this.handler != null) {
            this.handler.removeAllMessages();
        }
        if (this.dynamicCameraOverlayView != null) {
            this.dynamicCameraOverlayView.removeCaptureElements();
            this.restartInfoScreen();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    public static class DynamicCameraActivityHandler
    extends CameraController.CameraActivityHandler {
        final DynamicCaptureCameraController cameraController;

        public DynamicCameraActivityHandler(CameraController cameraController, boolean startPreview) {
            super(cameraController, startPreview);
            this.cameraController = (DynamicCaptureCameraController)this.looperActivity.get();
        }

        @Override
        public void handleMessage(Message message) {
            try {
                Bundle messageData = message.getData();
                if (this.cameraController == null) {
                    Logger.e(TAG, "handleMessage cameraController reference is null");
                    return;
                }
                Logger.i(TAG, "handler processing message:" + message.what);
                switch (message.what) {
                    case 29: {
                        Bundle checkRectBundleValid = messageData.getBundle("checkRect");
                        double orientationValid = messageData.getDouble("orientation", 0.0);
                        Logger.i("MESSAGE_PROCESS_VALID", "MESSAGE_PROCESS_VALID");
                        if (checkRectBundleValid != null && checkRectBundleValid.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_LEFT") != null) {
                            if (this.cameraController.dynamicCameraOverlayView != null) {
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.isValidRect = true;
                            }
                            boolean drawRect = true;
                            if (this.cameraController.dynamicCameraOverlayView != null) {
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.isRectFound = drawRect;
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.bottomLeft = checkRectBundleValid.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_LEFT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.bottomRight = checkRectBundleValid.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_RIGHT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.topRight = checkRectBundleValid.getFloatArray("INTENT_CHECK_QUADS_TOP_RIGHT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.topLeft = checkRectBundleValid.getFloatArray("INTENT_CHECK_QUADS_TOP_LEFT");
                                CameraManagerController.getOcrAnalyzeSession(this.cameraController.getApplicationContext()).setVideoQuads(checkRectBundleValid);
                            }
                            CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectBundleValid);
                            if (this.cameraController.dynamicCameraOverlayView != null) {
                                this.cameraController.dynamicCameraOverlayView.invalidate();
                            }
                        } else if (this.cameraController.dynamicCameraOverlayView != null) {
                            ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.isRectFound = false;
                        }
                        if (this.cameraController.dynamicCameraOverlayView != null) {
                            this.cameraController.dynamicCameraOverlayView.invalidate();
                        }
                        if ((this.cameraController.isDebug || drawFoundedRectangle) && checkRectBundleValid != null) {
                            Rect rect = OCRHelper.bundleToRect(checkRectBundleValid);
                            this.sendEmptyMessageDelayed(14, CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY);
                        }
                        if (this.cameraController.cameraSessionManager.getState() != CameraSessionManager.State.CAPTURING_IMAGE) {
                            this.proceedWithProcessing();
                        }
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_PROCESS_VALID", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 6: {
                        OCRCommon.ErrorCode errorCode;
                        CameraTypes.HintIndicator hintIndicator;
                        String hintName = messageData.getString("hintName");
                        String errorCodeName = messageData.getString("analyzeErrorCode");
                        Bundle checkRectBundle = messageData.getBundle("checkRect");
                        double orientation = messageData.getDouble("orientation", 0.0);
                        Log.i((String)"MESSAGE_PROCESS_NOT_VALID", (String)"MESSAGE_PROCESS_NOT_VALID");
                        if (!StringUtils.isEmptyOrNull(hintName)) {
                            hintIndicator = CameraTypes.HintIndicator.valueOf(hintName);
                            this.checkNextFrameDelay(hintIndicator);
                            if (this.cameraController.cameraOverlayView != null) {
                                this.cameraController.cameraOverlayView.showIndicator(hintIndicator, true);
                            }
                        }
                        hintIndicator = CameraTypes.HintIndicator.None;
                        if (checkRectBundle != null && checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_LEFT") != null) {
                            if (!StringUtils.isEmptyOrNull(hintName)) {
                                hintIndicator = CameraTypes.HintIndicator.valueOf(hintName);
                            }
                            if (this.cameraController.dynamicCameraOverlayView != null) {
                                this.cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);
                                Log.i((String)"checkRectBundle != null", (String)"checkRectBundle != null");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.isValidRect = false;
                            }
                            boolean drawRect = true;
                            if (hintIndicator == CameraTypes.HintIndicator.AspectRatioFailed) {
                                hintIndicator = CameraTypes.HintIndicator.None;
                                drawRect = false;
                            }
                            if (this.cameraController.cameraOverlayView != null) {
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.isRectFound = drawRect;
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.bottomLeft = checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_LEFT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.bottomRight = checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_RIGHT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.topRight = checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_TOP_RIGHT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.topLeft = checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_TOP_LEFT");
                                CameraManagerController.getOcrAnalyzeSession(this.cameraController.getApplicationContext()).setVideoQuads(checkRectBundle);
                            }
                            CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectBundle);
                            if (this.cameraController.dynamicCameraOverlayView != null) {
                                this.cameraController.dynamicCameraOverlayView.invalidate();
                            }
                        } else if (this.cameraController.dynamicCameraOverlayView != null) {
                            ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.isRectFound = false;
                        }
                        if (this.cameraController.dynamicCameraOverlayView != null) {
                            this.cameraController.dynamicCameraOverlayView.invalidate();
                        }
                        if (!StringUtils.isEmptyOrNull(hintName)) {
                            hintIndicator = CameraTypes.HintIndicator.valueOf(hintName);
                            this.checkNextFrameDelay(hintIndicator);
                        }
                        if (!StringUtils.isEmptyOrNull(errorCodeName) && (errorCode = OCRCommon.ErrorCode.valueOf(errorCodeName)) == OCRCommon.ErrorCode.error_deviceMemory) {
                            String exception = messageData.getString("exceptionError");
                            Intent data = new Intent();
                            data.putExtra("MOBIFLOW_ERROR_DETAILS", exception);
                            ((CameraController)this.looperActivity.get()).setResult(119, data);
                            ((CameraController)this.looperActivity.get()).finish();
                            return;
                        }
                        if ((this.cameraController.isDebug || drawFoundedRectangle) && checkRectBundle != null) {
                            Rect rect = OCRHelper.bundleToRect(checkRectBundle);
                            this.dispatchHintIndicator(messageData);
                            this.sendEmptyMessageDelayed(14, CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY);
                        }
                        this.proceedWithProcessing();
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_PROCESS_NOT_VALID", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 7: {
                        Logger.i(TAG, "MESSAGE_CAPTURE_STILL_IMAGE");
                        this.initProceedingToNextFrameDelay();
                        if (this.cameraController.isFinishing()) {
                            return;
                        }
                        Bundle bundleCaptureStillImage = messageData;
                        if (this.cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW) {
                            Bundle checkRectCaptureBundle = bundleCaptureStillImage.getBundle("checkRect");
                            Rect rect = OCRHelper.bundleToRect(checkRectCaptureBundle);
                            if (this.cameraController.dynamicCameraOverlayView != null) {
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.bottomLeft = checkRectCaptureBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_LEFT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.bottomRight = checkRectCaptureBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_RIGHT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.topRight = checkRectCaptureBundle.getFloatArray("INTENT_CHECK_QUADS_TOP_RIGHT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.topLeft = checkRectCaptureBundle.getFloatArray("INTENT_CHECK_QUADS_TOP_LEFT");
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.isValidRect = true;
                                ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.isRectFound = true;
                            }
                            CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectCaptureBundle);
                            if (this.cameraController.dynamicCameraOverlayView != null) {
                                this.cameraController.dynamicCameraOverlayView.invalidate();
                            }
                            CameraTypes.HintIndicator hintIndicator = CameraTypes.HintIndicator.Hold;
                            if (this.cameraController.dynamicCameraOverlayView != null) {
                                this.cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);
                                this.cameraController.dynamicCameraOverlayView.invalidate();
                            }
                            if (this.cameraController.cameraSessionManager.getMatchRectsCounter() >= CameraManagerController.identicalRectanglesToCapture) {
                                CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).orientation = bundleCaptureStillImage.getDouble("orientation");
                                this.removeAllMessages();
                                this.captureStillImage();
                            } else {
                                this.proceedWithProcessing();
                            }
                        }
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_CAPTURE_STILL_IMAGE", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 20: {
                        Logger.i(TAG, "MESSAGE_BARCODE_DETECTED");
                        if (this.cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW) {
                            OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.cameraController.getApplicationContext());
                            String barcodeType = messageData.getString("barCodeType");
                            String barcodeData = messageData.getString("barCodeData");
                            if (ocrAnalyzeSession.captureMode == CameraTypes.CaptureMode.FRONT) {
                                ocrAnalyzeSession.setFrontBarcodeType(barcodeType);
                                ocrAnalyzeSession.setFrontBarcodeData(barcodeData);
                            } else {
                                ocrAnalyzeSession.setBackBarcodeType(barcodeType);
                                ocrAnalyzeSession.setBackBarcodeData(barcodeData);
                            }
                            Handler handler = new Handler(this.cameraController.getApplicationContext().getMainLooper());
                            handler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    if (DynamicCameraActivityHandler.this.cameraController.dynamicCameraOverlayView != null) {
                                        DynamicCameraActivityHandler.this.cameraController.dynamicCameraOverlayView.clearBoundariesRect();
                                    }
                                    DynamicCameraActivityHandler.this.proceedWithProcessing();
                                }
                            }, 1000L);
                            ocrAnalyzeSession.isBarcodeSession = false;
                            break;
                        }
                        this.proceedWithProcessing();
                        break;
                    }
                    case 18: {
                        Logger.i(TAG, "MESSAGE_ERROR");
                        if (CameraManagerController.isStillMode) {
                            String errorMessage = (String)message.obj;
                            Intent data = new Intent();
                            Logger.e(TAG, errorMessage);
                            data.putExtra("MOBIFLOW_ERROR_DETAILS", errorMessage);
                            activity.setResult(119, data);
                            activity.finish();
                            break;
                        }
                        this.proceedWithProcessing();
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_ERROR", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 8: {
                        Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE");
                        if (this.cameraController.dynamicCameraOverlayView != null) {
                            ((DynamicCaptureCameraController)this.cameraController).dynamicCameraOverlayView.isRectFound = false;
                            this.cameraController.dynamicCameraOverlayView.invalidate();
                        }
                        if (CameraManagerController.isStillMode) {
                            this.cameraController.cameraSessionManager.stopPreviewOnly();
                        }
                        if (this.cameraController.dynamicCameraOverlayView != null) {
                            this.cameraController.dynamicCameraOverlayView.showProcessImg();
                        }
                        String imagePath = (String)message.obj;
                        if (CameraManagerController.isStillMode) {
                            this.removeAllMessages();
                        }
                        if (CameraManagerController.scanBackOnly) {
                            this.cameraController.processCapturedImage(imagePath);
                            CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).frontImageRect = FileUtils.arrayToRect(this.getFrontImageArrayValues());
                            break;
                        }
                        this.cameraController.processCapturedImage(imagePath);
                        break;
                    }
                    default: {
                        super.handleMessage(message);
                        break;
                    }
                }
            }
            catch (Exception e) {
                activity.setResult(119);
                activity.finish();
            }
        }

        double calAngleBetweenPoints(float[] first, float[] second) {
            float heigth1 = second[1] - first[1];
            float width1 = second[0] - first[0];
            float rads = (float)Math.atan2(heigth1, width1);
            return 180.0 * (double)rads / M_PI;
        }
    }

    protected class DynamicPrepareForManualCropping
    extends CameraController.PrepareForManualCropping {
        protected DynamicPrepareForManualCropping() {
            super(DynamicCaptureCameraController.this);
        }

        @Override
        protected void prepareHandlerAndProcessingView() {
            if (DynamicCaptureCameraController.this.handler == null) {
                DynamicCaptureCameraController.this.handler = new DynamicCameraActivityHandler(DynamicCaptureCameraController.getInstance(), false);
            }
            DynamicCaptureCameraController.this.handler.stopPreview();
            if (DynamicCaptureCameraController.this.dynamicCameraOverlayView != null) {
                ((DynamicCaptureCameraController)DynamicCaptureCameraController.this).dynamicCameraOverlayView.isRectFound = false;
                DynamicCaptureCameraController.this.dynamicCameraOverlayView.invalidate();
                DynamicCaptureCameraController.this.dynamicCameraOverlayView.showProcessImg();
            }
            DynamicCaptureCameraController.this.handler.removeAllMessages();
        }

        @Override
        protected GenericBoundingBoxResult doInBackground(String ... params) {
            CameraManagerController.getOcrAnalyzeSession(DynamicCaptureCameraController.this.getApplicationContext()).setImagePath(params[0]);
            GenericBoundingBoxResult genericBoundingBoxResult = this.tryFindGenericBoundingBox();
            if (genericBoundingBoxResult == null || genericBoundingBoxResult.width == 0 || genericBoundingBoxResult.height == 0) {
                if (DynamicCaptureCameraController.this.cameraSessionManager.previewCallback.genericBoundingBoxResult == null) {
                    return null;
                }
                genericBoundingBoxResult = DynamicCaptureCameraController.this.cameraSessionManager.previewCallback.lastGenericBoundingBoxWithSize;
                if (genericBoundingBoxResult == null || genericBoundingBoxResult.width == 0 || genericBoundingBoxResult.height == 0) {
                    return null;
                }
                float xRatio = CameraConfigurationManager.stillWidthRes / CameraConfigurationManager.videoResolutionWidth;
                float yRatio = CameraConfigurationManager.stillHeightRes / CameraConfigurationManager.videoResolutionHeight;
                float[] points = new float[8];
                UserInterfaceUtils.fillPointsArrayFromBoundingBox(points, genericBoundingBoxResult);
                UserInterfaceUtils.convertPointsToRatio(points, new PointF(xRatio, yRatio));
                UserInterfaceUtils.fillGenericBBUsingPointsArr(genericBoundingBoxResult, points);
            }
            return genericBoundingBoxResult;
        }
    }
}

