/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.os.Bundle;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.util.UserInterfaceUtils;
import org.opencv.core.Rect;

public class CheckBoundaries {
    private static final int CHECK_SIZE_MIN_WIDTH = 430;
    private static final float RATIO_BETWEEN_MIN_AND_VALIDATION_RECTANGLES = 0.0f;
    private float heightUsage;
    private float widthUsage = 0.99f;
    private Rect minCheckRect;
    private Rect validationRect;
    private Rect minCheckRectBack;
    private Rect validationRectBack;
    private int minCheckWidth;
    private int minCheckWidthBack;
    private static float validationRectWidth = 0.0f;
    private static float validationRectHeight = 0.0f;
    private CameraTypes.CaptureMode captureMode;
    private float defaultRectScale = 1.0f;

    public CheckBoundaries(Context context, CameraTypes.CaptureMode captureMode, boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack, float maxFrameWidth, float maxFrameHeight) {
        this(context, captureMode, isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax, hwRatioMinBack, hwRatioMaxBack, maxFrameWidth, maxFrameHeight, 1.0f);
    }

    public CheckBoundaries(Context context, CameraTypes.CaptureMode captureMode, boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack, float maxFrameWidth, float maxFrameHeight, float scale) {
        this.defaultRectScale = scale;
        this.heightUsage = maxFrameHeight;
        this.widthUsage = maxFrameWidth;
        this.captureMode = captureMode;
        this.updateValidationRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax, hwRatioMinBack, hwRatioMaxBack);
        this.updateMinCheckRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax, hwRatioMinBack, hwRatioMaxBack);
    }

    public void setValidationRect(Rect rect) {
        this.validationRect = rect;
    }

    private void updateMinCheckRect(boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack) {
        this.minCheckRect = new Rect();
        float minWidth = 0.0f * (float)this.validationRect.width;
        float minHeight = minWidth * hwRatioMin;
        this.updateRect(displayWidth, displayHeight, minWidth, minHeight, this.minCheckRect);
        this.minCheckRectBack = new Rect(this.minCheckRect.x, this.minCheckRect.y, this.minCheckRect.width, this.minCheckRect.height);
        if (isUseCustomAlgorithmForBack) {
            float hwRatioMidBack = (hwRatioMaxBack + hwRatioMinBack) / 2.0f;
            float heightBack = minWidth * hwRatioMidBack;
            float widthBack = minWidth;
            if (heightBack > minHeight) {
                float scaleHRatio = heightBack / minHeight;
                widthBack = (heightBack /= scaleHRatio) / hwRatioMaxBack;
            }
            this.updateRect(displayWidth, displayHeight, widthBack, heightBack, this.minCheckRectBack);
        }
    }

    private void updateValidationRect(boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack) {
        this.validationRect = new Rect();
        validationRectHeight = (float)displayHeight * this.heightUsage * this.defaultRectScale;
        validationRectWidth = (float)displayWidth * this.defaultRectScale * this.widthUsage;
        float currentRatio = validationRectHeight / validationRectWidth;
        float hwRatioMid = (hwRatioMax + hwRatioMin) / 2.0f;
        if (currentRatio > hwRatioMid) {
            validationRectHeight = hwRatioMid * validationRectWidth;
        } else {
            validationRectWidth = validationRectHeight / hwRatioMid;
        }
        this.updateRect(displayWidth, displayHeight, validationRectWidth, validationRectHeight, this.validationRect);
        this.validationRectBack = new Rect(this.validationRect.x, this.validationRect.y, this.validationRect.width, this.validationRect.height);
        if (isUseCustomAlgorithmForBack) {
            float hwRatioMidBack = (hwRatioMaxBack + hwRatioMinBack) / 2.0f;
            float heightBack = validationRectWidth * hwRatioMidBack;
            float widthBack = validationRectWidth;
            if (heightBack > validationRectHeight) {
                float scaleHRatio = heightBack / validationRectHeight;
                widthBack = (heightBack /= scaleHRatio) / hwRatioMidBack;
            }
            this.updateRect(displayWidth, displayHeight, widthBack, heightBack, this.validationRectBack);
        }
    }

    public CheckBoundaries(Bundle bundle) {
        this.validationRect = UserInterfaceUtils.bundleToRect(bundle.getBundle("validationRect"));
        this.minCheckRect = UserInterfaceUtils.bundleToRect(bundle.getBundle("minCheckRect"));
        this.validationRectBack = UserInterfaceUtils.bundleToRect(bundle.getBundle("validationRectBack"));
        this.minCheckRectBack = UserInterfaceUtils.bundleToRect(bundle.getBundle("minCheckRectBack"));
        this.minCheckWidth = bundle.getInt("minCheckWidth");
    }

    public void setCaptureMode(CameraTypes.CaptureMode captureMode) {
        this.captureMode = captureMode;
    }

    private void updateRect(int displayWidth, int displayHeight, float width, float height, Rect rect) {
        rect.width = (int)width;
        rect.height = (int)height;
        rect.x = (displayWidth - rect.width) / 2;
        rect.y = (int)((double)(displayHeight - rect.height) / 2.2);
    }

    public Rect getValidationBoundariesRectByCaptureMode() {
        return this.captureMode == CameraTypes.CaptureMode.FRONT ? this.validationRect : this.validationRectBack;
    }

    public Rect getValidationRect() {
        return this.validationRect;
    }

    public Rect getValidationRectBack() {
        return this.validationRectBack;
    }

    public Rect getMinCheckRectByCaptureMode() {
        return this.captureMode == CameraTypes.CaptureMode.FRONT ? this.minCheckRect : this.minCheckRectBack;
    }

    public Rect getMinCheckRect() {
        return this.minCheckRect;
    }

    public Rect getMinCheckRectBack() {
        return this.minCheckRectBack;
    }

    public int getMinCheckWidth() {
        return this.captureMode == CameraTypes.CaptureMode.FRONT ? this.minCheckWidth : this.minCheckWidthBack;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putBundle("validationRect", UserInterfaceUtils.rectToBundle(this.validationRect));
        bundle.putBundle("minCheckRect", UserInterfaceUtils.rectToBundle(this.minCheckRect));
        bundle.putBundle("validationRectBack", UserInterfaceUtils.rectToBundle(this.validationRectBack));
        bundle.putBundle("minCheckRectBack", UserInterfaceUtils.rectToBundle(this.minCheckRectBack));
        bundle.putInt("minCheckWidth", this.minCheckWidth);
        return bundle;
    }
}

