/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import com.topimagesystems.R;
import com.topimagesystems.util.ActivityUtil;
import java.util.List;

public class NavigationManager {
    private static NavigationManager instance = new NavigationManager(){};
    private Class<?> _currentScreenClass;

    public static NavigationManager getInstance() {
        return instance;
    }

    public void showNewScreen(Activity baseActivity, Class<?> activityClass, Bundle extras, boolean isFinishCurrentActivity) {
        this.showNewScreen(baseActivity, activityClass, extras, null, -1, isFinishCurrentActivity);
    }

    public void showNewScreen(Activity baseActivity, Class<?> activityClass, Bundle extras, int requestCode, boolean isFinishCurrentActivity) {
        this.showNewScreen(baseActivity, activityClass, extras, null, requestCode, isFinishCurrentActivity);
    }

    public void showNewScreen(Activity baseActivity, Class<?> activityClass, Bundle extras, List<Integer> flags, int requestCode, boolean isFinishCurrentActivity) {
        if (baseActivity == null) {
            return;
        }
        this.showActivity(baseActivity, activityClass, extras, flags, requestCode);
        baseActivity.overridePendingTransition(NavigationManager.enterAnimation(), NavigationManager.outAnimation());
        this._currentScreenClass = activityClass;
        if (isFinishCurrentActivity) {
            this.closePreviousActivity(baseActivity);
        }
    }

    public Class<?> getCurrentScreenClass() {
        return this._currentScreenClass;
    }

    public static int enterAnimation() {
        return R.anim.screen_enter;
    }

    public static int outAnimation() {
        return R.anim.screen_exit;
    }

    public static int enterDialogAnimation() {
        return R.anim.dialog_enter;
    }

    public static int outDialogAnimation() {
        return R.anim.dialog_exit;
    }

    public void clearCurrentScreen() {
        this._currentScreenClass = null;
    }

    private void showActivity(Activity baseActivity, Class<?> activityClass, Bundle extras, List<Integer> flags, int requestCode) {
        Intent intent = ActivityUtil.createIntent(baseActivity.getApplicationContext(), activityClass);
        if (extras != null) {
            intent.putExtras(extras);
        }
        if (flags != null) {
            for (Integer flag : flags) {
                intent.setFlags(flag.intValue());
            }
        }
        intent.setFlags(65536);
        intent.setFlags(0x4000000);
        if (requestCode > -1) {
            baseActivity.startActivityForResult(intent, requestCode);
        } else {
            baseActivity.startActivity(intent);
        }
    }

    private void closePreviousActivity(final Activity previousActivity) {
        Runnable runnableClosePreviousActivity = new Runnable(){

            @Override
            public void run() {
                previousActivity.finish();
            }
        };
        Handler handler = new Handler(previousActivity.getMainLooper());
        handler.postDelayed(runnableClosePreviousActivity, 1000L);
    }

    public int getCommonInTransition() {
        return NavigationManager.enterAnimation();
    }

    public int getCommonOutTransition() {
        return NavigationManager.outAnimation();
    }

    static enum AnimationType {
        FADE,
        SLIDE_DOWN,
        SLIDE_UP;

    }

    static enum ScreenType {
        CLOSABLE,
        KEEP_ALIVE;

    }
}

