/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.topimagesystems.R;
import com.topimagesystems.ui.ActionBar;
import com.topimagesystems.util.StringUtils;

public abstract class BaseController
extends Activity {
    protected Button btnBack;
    protected Button btnRightButton;
    protected TextView txtActionBarTitle;
    protected ImageView imgActionBarIcon;
    protected ActionBar actionBar;
    private ProgressDialog progressDialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.ensureActionBar();
    }

    protected void onCreate(Bundle savedInstanceState, int layoutResID) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        if (layoutResID > -1) {
            this.setContentView(layoutResID);
        }
        this.ensureActionBar();
    }

    protected abstract void ensureActionBar();

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.mbck_main_menu, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return super.onOptionsItemSelected(item);
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    protected void showError(final String title, final String message, final DialogInterface.OnClickListener onclickListener) {
        if (!this.isFinishing()) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BaseController.this.showProgressDialog(false);
                    AlertDialog alertDialog = new AlertDialog.Builder((Context)BaseController.this).setTitle((CharSequence)title).setMessage((CharSequence)message).setCancelable(false).setPositiveButton((CharSequence)StringUtils.dynamicString(BaseController.this.getBaseContext(), "TISFlowOK"), onclickListener).create();
                    alertDialog.show();
                }
            });
        }
    }

    protected void showProgressDialog(boolean isShow) {
        this.showProgressDialog(isShow, StringUtils.dynamicString((Context)this, "TISProcessing"));
    }

    protected void showProgressDialog(final boolean isShow, final String message) {
        if (!this.isFinishing()) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (isShow) {
                        if (BaseController.this.progressDialog == null) {
                            BaseController.this.progressDialog = new ProgressDialog((Context)BaseController.this);
                            BaseController.this.progressDialog.requestWindowFeature(1);
                        }
                        BaseController.this.progressDialog.setMessage((CharSequence)message);
                        BaseController.this.progressDialog.show();
                    } else if (BaseController.this.progressDialog != null) {
                        BaseController.this.progressDialog.dismiss();
                    }
                }
            });
        }
    }
}

