/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.hardware.Camera;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import com.topimagesystems.camera.CameraConfigurationUtils;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.util.Logger;
import org.opencv.core.Rect;

public class UserInterfaceUtils {
    private static final String tag = Logger.makeLogTag("UIUtils");
    private static String STUB = "payment";
    private static String CHECK = "check";
    private static final boolean CAN_USE_IMMERSIVE_MODE = Build.VERSION.SDK_INT >= 19;

    public static Point getDisplayDimensions(Context context) {
        return UserInterfaceUtils.getDisplayDimensions(context, CAN_USE_IMMERSIVE_MODE || CameraConfigurationManager.adjustedPreviewSize);
    }

    public static Point getDisplayDimensions(Context context, boolean useRealSize) {
        Point size = new Point();
        WindowManager wm = context != null ? (WindowManager)context.getSystemService("window") : (WindowManager)CameraController.getInstance().getSystemService("window");
        if (Build.VERSION.SDK_INT >= 11) {
            UserInterfaceUtils.getSizeAboveAPI13(size, wm, useRealSize);
        } else {
            UserInterfaceUtils.getSizePriorApi13(size, wm);
        }
        if (CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT && size.x > size.y || CameraManagerController.sessionType != CaptureIntent.SessionType.PORTRAIT && size.x < size.y) {
            return new Point(size.y, size.x);
        }
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasHardwareAcceleration(Activity activity) {
        try {
            Window window = activity.getWindow();
            if (window != null && (window.getAttributes().flags & 0x1000000) != 0) {
                return true;
            }
            try {
                ActivityInfo info = activity.getPackageManager().getActivityInfo(activity.getComponentName(), 0);
                if ((info.flags & 0x200) == 0) return false;
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)"hasHardwareAcceleration", (String)"getActivityInfo(self) should not fail");
            }
            return false;
        }
        catch (Exception e) {
            Logger.e("hasHardwareAcceleration", Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    public static Point getCameraPreviewResolution(Context context, Camera.Parameters parameters) {
        if (CameraManagerController.invertedCamera) {
            return CameraConfigurationUtils.findBestPreviewSizeValue(parameters, UserInterfaceUtils.getDisplayDimensions(context, true));
        }
        return CameraConfigurationManager.getCameraPreviewResolution(parameters, UserInterfaceUtils.getDisplayDimensions(context), context);
    }

    public static String getVersionName(Context context) {
        String app_ver = "unknown";
        try {
            app_ver = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.v(tag, e.getMessage());
        }
        return app_ver;
    }

    private static void getSizePriorApi13(Point size, WindowManager wm) {
        Display d = wm.getDefaultDisplay();
        size.x = d.getWidth();
        size.y = d.getHeight();
    }

    @TargetApi(value=13)
    private static void getSizeAboveAPI13(Point size, WindowManager wm, boolean useRealSize) {
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 17 && useRealSize) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)display, realSize);
                size.x = realSize.x;
                size.y = realSize.y;
            }
            catch (Exception ignored) {
                display.getSize(size);
            }
        } else {
            display.getSize(size);
        }
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics;
    }

    public static int getAPILevel() {
        return Build.VERSION.SDK_INT;
    }

    public static Bundle rectToBundle(Rect rect) {
        Bundle bundle = new Bundle();
        if (rect != null) {
            bundle.putInt("x", rect.x);
            bundle.putInt("y", rect.y);
            bundle.putInt("width", rect.width);
            bundle.putInt("height", rect.height);
        }
        return bundle;
    }

    public static Rect bundleToRect(Bundle bundle) {
        Rect rect = new Rect();
        if (bundle != null) {
            rect.x = bundle.getInt("x");
            rect.y = bundle.getInt("y");
            rect.width = bundle.getInt("width");
            rect.height = bundle.getInt("height");
        }
        return rect;
    }

    public static Rect getFitRectangle(int frameWidth, int frameHeight, int imageWidth, int imageHeight) {
        int y;
        int height;
        int x;
        int width;
        if (frameWidth * imageHeight > frameHeight * imageWidth) {
            width = imageWidth * frameHeight / imageHeight;
            x = (frameWidth - width) / 2;
            height = frameHeight;
            y = 0;
        } else {
            width = frameWidth;
            x = 0;
            height = imageHeight * frameWidth / imageWidth;
            y = (frameHeight - height) / 2;
        }
        return new Rect(x, y, width, height);
    }

    public static Rect getFillRectangle(int frameWidth, int frameHeight, int imageWidth, int imageHeight) {
        int y;
        int height;
        int x;
        int width;
        if (frameWidth * imageHeight > frameHeight * imageWidth) {
            width = frameWidth;
            x = 0;
            height = imageHeight * frameWidth / imageWidth;
            y = (frameHeight - height) / 2;
        } else {
            width = imageWidth * frameHeight / imageHeight;
            x = (frameWidth - width) / 2;
            height = frameHeight;
            y = 0;
        }
        return new Rect(x, y, width, height);
    }

    public static void fillPointsArrayFromBoundingBox(float[] points, GenericBoundingBoxResult bb) {
        points[0] = bb.topLeftX;
        points[1] = bb.topLeftY;
        points[2] = bb.topRightX;
        points[3] = bb.topRightY;
        points[4] = bb.bottomRightX;
        points[5] = bb.bottomRightY;
        points[6] = bb.bottomLeftX;
        points[7] = bb.bottomLeftY;
    }

    public static void fillGenericBBUsingPointsArr(GenericBoundingBoxResult bb, float[] points) {
        bb.topLeftX = points[0];
        bb.topLeftY = points[1];
        bb.topRightX = points[2];
        bb.topRightY = points[3];
        bb.bottomLeftX = points[4];
        bb.bottomLeftY = points[5];
        bb.bottomRightX = points[6];
        bb.bottomRightY = points[7];
        bb.x = Math.round(Math.min(bb.topLeftX, bb.bottomLeftX));
        bb.y = Math.round(Math.min(bb.topLeftY, bb.topRightY));
        bb.width = Math.round(Math.max(bb.topRightX, bb.bottomRightX)) - bb.x + 1;
        bb.height = Math.round(Math.max(bb.bottomLeftY, bb.bottomRightY)) - bb.y + 1;
    }

    public static float[] convertPointsToRatio(float[] origPoints, PointF ratio) {
        if (origPoints == null) {
            return null;
        }
        float[] convertedPoints = new float[origPoints.length];
        Matrix scaleMat = new Matrix();
        scaleMat.setScale(ratio.x, ratio.y);
        scaleMat.mapPoints(convertedPoints, origPoints);
        return convertedPoints;
    }

    public static int getScreenOrientation(Context context) {
        WindowManager wm = (WindowManager)CameraController.getInstance().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int orientation = 0;
        orientation = display.getWidth() == display.getHeight() ? 3 : (display.getWidth() < display.getHeight() ? 1 : 2);
        return orientation;
    }

    public static void sortPointsClockwise(PointF[] points, PointF center) {
        int i = 0;
        while (i < points.length - 1) {
            PointF lowest = points[i];
            int currentIndex = i;
            int j = i + 1;
            while (j < points.length) {
                if (UserInterfaceUtils.comparePointCW(lowest, points[j], center)) {
                    lowest = points[j];
                    currentIndex = j;
                }
                ++j;
            }
            if (currentIndex != i) {
                points[currentIndex] = points[i];
                points[i] = lowest;
            }
            ++i;
        }
    }

    private static boolean comparePointCW(PointF a, PointF b, PointF center) {
        if (a.x - center.x >= 0.0f && b.x - center.x < 0.0f) {
            return true;
        }
        if (a.x - center.x < 0.0f && b.x - center.x >= 0.0f) {
            return false;
        }
        if (a.x - center.x == 0.0f && b.x - center.x == 0.0f) {
            if (a.y - center.y >= 0.0f || b.y - center.y >= 0.0f) {
                return a.y > b.y;
            }
            return b.y > a.y;
        }
        double det = (a.x - center.x) * (b.y - center.y) - (b.x - center.x) * (a.y - center.y);
        if (det < 0.0) {
            return true;
        }
        if (det > 0.0) {
            return false;
        }
        double d1 = (a.x - center.x) * (a.x - center.x) + (a.y - center.y) * (a.y - center.y);
        double d2 = (b.x - center.x) * (b.x - center.x) + (b.y - center.y) * (b.y - center.y);
        return d1 > d2;
    }
}

